/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.util.DLExpressivityChecker;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.profiles.CheckOWL2Profile;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class OntologyLoader {
    protected OWLDataFactory dataFactory;
    protected OWLOntologyManager managerOnto;
    protected OWLOntology onto;
    protected String iri_onto_str;
    protected int size_signature;
    protected int size_classes;
    protected Set<OWLAxiom> axiomSet = new HashSet<OWLAxiom>();
    private String DLNameOnto;
    private CheckOWL2Profile profileChecker;
    private boolean inOWL2DL;
    private boolean inOWL2EL;
    private OWLProfileReport owl2DLProfileReport;
    private boolean keepLogicalAxiomsOnly;

    public OntologyLoader(String phy_iri_onto, boolean keepLogicalAxiomsOnly) throws OWLOntologyCreationException {
        this.managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
        this.dataFactory = this.managerOnto.getOWLDataFactory();
        this.keepLogicalAxiomsOnly = keepLogicalAxiomsOnly;
        this.loadOWLOntology(phy_iri_onto);
    }

    public OntologyLoader(String phy_iri_onto) throws OWLOntologyCreationException {
        this(phy_iri_onto, false);
    }

    public OntologyLoader(File file, boolean keepLogicalAxiomsOnly) throws OWLOntologyCreationException {
        this.managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
        this.dataFactory = this.managerOnto.getOWLDataFactory();
        this.keepLogicalAxiomsOnly = keepLogicalAxiomsOnly;
        this.loadOWLOntologyFromFile(file);
    }

    public OntologyLoader(File file) throws OWLOntologyCreationException {
        this(file, false);
    }

    public OntologyLoader(OWLOntology given_onto) throws OWLOntologyCreationException {
        this.managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
        this.dataFactory = this.managerOnto.getOWLDataFactory();
        this.setOWLOntology(given_onto);
    }

    private void setSilentMissingImportStrategy() {
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config = config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.managerOnto.setOntologyLoaderConfiguration(config);
    }

    private String getURIFromClasses(OWLOntology ontology) {
        Iterator iterator = ontology.getClassesInSignature(Imports.INCLUDED).iterator();
        if (iterator.hasNext()) {
            OWLClass cls = (OWLClass)iterator.next();
            return Utilities.getNameSpaceFromURI(cls.getIRI().toString());
        }
        return "http://logmap.cs.ox.ac.uk/ontology.owl";
    }

    public void setOWLOntology(OWLOntology given_onto) throws OWLOntologyCreationException {
        try {
            this.iri_onto_str = given_onto.getOntologyID().getOntologyIRI() != null && given_onto.getOntologyID().getOntologyIRI().isPresent() ? ((IRI)given_onto.getOntologyID().getOntologyIRI().get()).toString() : this.getURIFromClasses(given_onto);
            HashSet axioms = new HashSet();
            axioms.addAll(given_onto.getAxioms(Imports.INCLUDED));
            try {
                for (OWLOntology imported_onto : given_onto.getImportsClosure()) {
                    axioms.addAll(imported_onto.getAxioms(Imports.INCLUDED));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onto = this.managerOnto.createOntology(axioms, IRI.create((String)this.iri_onto_str));
            this.size_signature = this.onto.getSignature(Imports.INCLUDED).size();
            this.size_classes = this.onto.getClassesInSignature(Imports.INCLUDED).size();
            if (this.size_classes == 0) {
                this.addDummyAxiom2Ontology();
            }
        }
        catch (Exception e) {
            System.err.println("Error creating OWL ontology 4 LogMap: " + e.getMessage());
            e.printStackTrace();
            throw new OWLOntologyCreationException();
        }
    }

    public void loadOWLOntologyFromFile(File file) throws OWLOntologyCreationException {
        try {
            this.setSilentMissingImportStrategy();
            this.onto = this.managerOnto.loadOntologyFromOntologyDocument(file);
            this.loadOntologyInformation();
        }
        catch (Exception e) {
            System.err.println("Error loading OWL ontology: " + e.getMessage());
            throw new OWLOntologyCreationException();
        }
    }

    public void loadOWLOntology(String phy_iri_onto) throws OWLOntologyCreationException {
        try {
            this.setSilentMissingImportStrategy();
            this.onto = this.managerOnto.loadOntology(IRI.create((String)phy_iri_onto));
            this.loadOntologyInformation();
        }
        catch (Exception e) {
            System.err.println("Error loading OWL ontology: " + e.getMessage());
            throw new OWLOntologyCreationException();
        }
    }

    protected void loadOntologyInformation() throws OWLOntologyCreationException {
        this.iri_onto_str = this.onto.getOntologyID().getOntologyIRI() != null && this.onto.getOntologyID().getOntologyIRI().isPresent() ? ((IRI)this.onto.getOntologyID().getOntologyIRI().get()).toString() : this.getURIFromClasses(this.onto);
        this.size_signature = this.onto.getSignature(Imports.INCLUDED).size();
        this.size_classes = this.onto.getClassesInSignature(Imports.INCLUDED).size();
        if (this.size_classes == 0) {
            this.addDummyAxiom2Ontology();
        }
        if (this.keepLogicalAxiomsOnly) {
            HashSet filteredAxioms = new HashSet();
            filteredAxioms.addAll(this.onto.getTBoxAxioms(Imports.INCLUDED));
            filteredAxioms.addAll(this.onto.getRBoxAxioms(Imports.INCLUDED));
            filteredAxioms.addAll(this.onto.getABoxAxioms(Imports.INCLUDED));
            this.managerOnto.removeOntology(this.onto);
            this.onto = this.managerOnto.createOntology(filteredAxioms, IRI.create((String)this.iri_onto_str));
        }
        try {
            Set importsClosure = this.managerOnto.getImportsClosure(this.onto);
            DLExpressivityChecker checker = new DLExpressivityChecker(importsClosure);
            this.DLNameOnto = checker.getDescriptionLogicName();
            this.profileChecker = new CheckOWL2Profile(this.onto);
            this.owl2DLProfileReport = this.profileChecker.getReport4OWL2DL();
            if (!this.owl2DLProfileReport.isInProfile()) {
                this.inOWL2DL = false;
                this.inOWL2EL = false;
            } else {
                this.inOWL2DL = true;
                this.inOWL2EL = this.profileChecker.getReport4OWL2EL().isInProfile();
            }
        }
        catch (Exception e) {
            LogOutput.printError("Error checking DL expressivity: " + e.getMessage());
        }
    }

    public String getDLNameOntology() {
        return this.DLNameOnto;
    }

    public boolean isOntologyInOWL2DL() {
        return this.inOWL2DL;
    }

    public boolean isOntologyInOWL2EL() {
        return this.inOWL2EL;
    }

    public List<OWLProfileViolation> getOWL2DLProfileViolation() {
        return this.owl2DLProfileReport.getViolations();
    }

    public void addDummyAxiom2Ontology() {
        OWLClass dummycls = this.dataFactory.getOWLClass(IRI.create((String)"http://logmap.cs.ox.ac.uk/ontologies#TopClass"));
        this.managerOnto.applyChange((OWLOntologyChange)new AddAxiom(this.onto, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)dummycls)));
        this.managerOnto.applyChange((OWLOntologyChange)new AddAxiom(this.onto, (OWLAxiom)this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)dummycls, (OWLClassExpression)this.dataFactory.getOWLThing())));
    }

    public void createAxiomSet() {
        this.axiomSet.addAll(this.onto.getAxioms());
        this.axiomSet.addAll(this.onto.getTBoxAxioms(Imports.INCLUDED));
        this.axiomSet.addAll(this.onto.getABoxAxioms(Imports.INCLUDED));
        this.axiomSet.addAll(this.onto.getRBoxAxioms(Imports.INCLUDED));
    }

    public void clearAxiomSet() {
        this.axiomSet.clear();
    }

    public Set<OWLAxiom> getAxiomSet() {
        return this.axiomSet;
    }

    public void clearOntology() {
        this.managerOnto.removeOntology(this.onto);
        this.onto = null;
        this.managerOnto = null;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.managerOnto;
    }

    public OWLOntology getOWLOntology() {
        return this.onto;
    }

    public String getOntologyIRIStr() {
        return this.iri_onto_str;
    }

    public IRI getOntologyIRI() {
        return IRI.create((String)this.iri_onto_str);
    }

    public Set<OWLClass> getClassesInSignature() {
        return this.onto.getClassesInSignature(Imports.INCLUDED);
    }

    public int getSignatureSize() {
        return this.size_signature;
    }

    public int getClassesInSignatureSize() {
        return this.size_classes;
    }

    public void applyChanges(List<OWLOntologyChange> listchanges) {
        this.managerOnto.applyChanges(listchanges);
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void saveOntology(String phy_iri_onto) throws Exception {
        this.managerOnto.saveOntology(this.onto, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)phy_iri_onto));
    }
}

