/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.indexing.ReasonerBasedIndexManager;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcess;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcessAmbiguity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.mappings.CandidateMappingManager;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.overlapping.LexicalOverlappingExtractor;
import uk.ac.ox.krr.logmap2.overlapping.NoOverlappingExtractor;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerManager;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap2.repair.AnchorsAssessmentFullReasoning;
import uk.ac.ox.krr.logmap2.statistics.StatisticsManager;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class LogMap_Full {
    private OverlappingExtractor overlappingExtractor;
    private IndexManager index;
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private MappingManager mapping_extractor;
    private AnchorsAssessmentFullReasoning anchor_assessment;
    private InteractiveProcess interactiveProcessManager;
    private Set<MappingObjectStr> mappings_gs = new HashSet<MappingObjectStr>();
    private LexicalUtilities lexicalUtilities = new LexicalUtilities();
    private String prefix4IRIs;
    private String gs_mappings;
    long init_global;
    long init;
    long fin;
    private int reasoner_id = ReasonerManager.HERMIT;

    public LogMap_Full(String iri1_str, String iri2_str, String gs_mappings, int ReasonerID) throws Exception {
        this.reasoner_id = ReasonerID;
        this.gs_mappings = gs_mappings;
        this.init_global = this.init = Calendar.getInstance().getTimeInMillis();
        this.InitLogMap();
        this.OverlappingEstimation(iri1_str, iri2_str);
        this.IndexLexiconAndStructure();
        this.init = Calendar.getInstance().getTimeInMillis();
        if (!gs_mappings.equals("")) {
            this.loadMappingsGS();
        }
        LogOutput.printAlways("\n\nCLEANING ANCHORS");
        LogOutput.printAlways("---------------------------");
        this.createAndCleanAnchors();
        LogOutput.printAlways("\n\nCLEANING CANDIDATES 1");
        LogOutput.printAlways("---------------------------");
        this.createCandidateMappings();
        this.mapping_extractor.printStatisticsMappingEvaluation();
        StatisticsManager.setPrecisionAndRecallAnchors(this.mapping_extractor.getStringGoldStandardAnchors().size());
        StatisticsManager.printStatisticsLogMap_mappings();
        this.mapping_extractor.createObjectPropertyAnchors();
        this.mapping_extractor.createDataPropertyAnchors();
        this.onto_process1.clearInvertedFiles4properties();
        this.onto_process2.clearInvertedFiles4properties();
        LogOutput.printAlways("\n\nCLEANING CANDIDATES 2");
        LogOutput.printAlways("---------------------------");
        this.createMappingsInteractiveProcess(false);
        if (!gs_mappings.equals("")) {
            this.getPrecisionAndRecallMappings();
        }
        LogOutput.printAlways("Average time taxonomic queries: " + this.index.getAvgTime4TaxCalls() + ". Total: " + this.index.getTime4TaxCalls() + ". Num calls: " + this.index.getNumberOfTaxCalls());
        LogOutput.printAlways("Average time disjointness queries: " + this.index.getAvgTime4DisjCalls() + ". Total: " + this.index.getTime4DisjCalls() + ". Num calls: " + this.index.getNumberOfDisjCalls());
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("TOTAL TIME (s): " + (double)((float)((double)this.fin - (double)this.init_global)) / 1000.0);
        this.impactIntegration();
    }

    private void impactIntegration() throws Exception {
        OWLOntology mappings_onto = this.getOWLOntology4Mappings();
        System.out.println("ONTO 1 axioms: " + this.overlappingExtractor.getTBOXOverlappingOnto1().size());
        System.out.println("ONTO 2 axioms: " + this.overlappingExtractor.getTBOXOverlappingOnto2().size());
        System.out.println("Mappings: " + mappings_onto.getAxiomCount());
        SatisfiabilityIntegration sat_checker = new SatisfiabilityIntegration(this.overlappingExtractor.getTBOXOverlappingOnto1(), this.overlappingExtractor.getTBOXOverlappingOnto2(), mappings_onto.getAxioms(), false, false);
        System.out.println("Num unsat classes: " + sat_checker.getNumUnsatClasses());
    }

    private OWLOntology getOWLOntology4Mappings() throws Exception {
        OWLAlignmentFormat owlformat = new OWLAlignmentFormat("");
        for (int ide1 : this.getClassMappings().keySet()) {
            for (int ide2 : this.getClassMappings().get(ide1)) {
                int dir_mapping = this.getDirClassMapping(ide1, ide2);
                if (dir_mapping == -3) continue;
                if (dir_mapping != -1) {
                    owlformat.addClassMapping2Output(this.getIRI4ConceptIdentifier(ide1), this.getIRI4ConceptIdentifier(ide2), dir_mapping, this.getConfidence4ConceptMapping(ide1, ide2));
                    continue;
                }
                owlformat.addClassMapping2Output(this.getIRI4ConceptIdentifier(ide2), this.getIRI4ConceptIdentifier(ide1), dir_mapping, this.getConfidence4ConceptMapping(ide1, ide2));
            }
        }
        for (int ide1 : this.getDataPropMappings().keySet()) {
            owlformat.addDataPropMapping2Output(this.getIRI4DataPropIdentifier(ide1), this.getIRI4DataPropIdentifier(this.getDataPropMappings().get(ide1)), -2, 1.0);
        }
        for (int ide1 : this.getObjectPropMappings().keySet()) {
            owlformat.addObjPropMapping2Output(this.getIRI4ObjectPropIdentifier(ide1), this.getIRI4ObjectPropIdentifier(this.getObjectPropMappings().get(ide1)), -2, 1.0);
        }
        return owlformat.getOWLOntology();
    }

    public Map<Integer, Set<Integer>> getClassMappings() {
        return this.mapping_extractor.getLogMapMappings();
    }

    public int getDirClassMapping(int ide1, int ide2) {
        return this.mapping_extractor.getDirMapping(ide1, ide2);
    }

    public String getIRIOntology1() {
        return this.onto_process1.getOntoIRI();
    }

    public String getIRIOntology2() {
        return this.onto_process2.getOntoIRI();
    }

    public Map<Integer, Integer> getDataPropMappings() {
        return this.mapping_extractor.getDataPropertyAnchors();
    }

    public Map<Integer, Integer> getObjectPropMappings() {
        return this.mapping_extractor.getObjectPropertyAnchors();
    }

    public double getConfidence4ConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4Mapping(ide1, ide2);
    }

    public double getConfidence4DataPropConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4DataPropertyAnchor(ide1, ide2);
    }

    public double getConfidence4ObjectPropConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4ObjectPropertyAnchor(ide1, ide2);
    }

    public String getIRI4ConceptIdentifier(int ide) {
        return this.index.getIRIStr4ConceptIndex(ide);
    }

    public String getIRI4DataPropIdentifier(int ide) {
        return this.index.getIRIStr4DataPropIndex(ide);
    }

    public String getIRI4ObjectPropIdentifier(int ide) {
        return this.index.getIRIStr4ObjPropIndex(ide);
    }

    private void InitLogMap() throws Exception {
        LogOutput.showOutpuLog(false);
        this.lexicalUtilities.loadStopWords();
        if (Parameters.use_umls_lexicon) {
            this.lexicalUtilities.loadUMLSLexiconResources();
        }
        this.lexicalUtilities.setStemmer();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time initializing lexical utilities (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    private void OverlappingEstimation(String iri1_str, String iri2_str) throws Exception {
        LogOutput.print("OVERLAPPING");
        this.init = Calendar.getInstance().getTimeInMillis();
        this.overlappingExtractor = !Parameters.use_overlapping ? new NoOverlappingExtractor() : new LexicalOverlappingExtractor(this.lexicalUtilities, true);
        this.overlappingExtractor.createOverlapping(iri1_str, iri2_str);
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting overlapping (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    private void IndexLexiconAndStructure() throws Exception {
        this.index = new ReasonerBasedIndexManager();
        this.onto_process1 = new OntologyProcessing(this.overlappingExtractor.getOverlappingOnto1(), this.index, this.lexicalUtilities);
        this.onto_process2 = new OntologyProcessing(this.overlappingExtractor.getOverlappingOnto2(), this.index, this.lexicalUtilities);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.precessLexicon();
        this.onto_process2.precessLexicon();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting lexicon and IF (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.lexicalUtilities.clearStructures();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_extractor = new CandidateMappingManager(this.index, this.onto_process1, this.onto_process2);
        StatisticsManager.reInitValues();
        StatisticsManager.setMappingManager(this.mapping_extractor);
        this.mapping_extractor.intersectInvertedFiles();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time intersecting IF and extracting IF weak (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.onto_process1.clearStemmedLabels();
        this.onto_process2.clearStemmedLabels();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.setTaxonomicData();
        this.onto_process2.setTaxonomicData();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting structural information (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.overlappingExtractor.keepOnlyTBOXOverlapping();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_extractor.extractAllWeakMappings();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time creating all weak anchors (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_extractor.extractCandidatesSubsetFromWeakMappings();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time creating candidate subset of weak anchors (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.onto_process1.clearFrequencyRelatedStructures();
        this.onto_process2.clearFrequencyRelatedStructures();
        this.index.clearSingleWordInvertedIndex();
        this.index.clearStemmedAlternativeLabels4Classes();
    }

    private void createAndCleanAnchors() throws Exception {
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_extractor.createAnchors();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time creating anchors (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.countAnchors();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.anchor_assessment = new AnchorsAssessmentFullReasoning(this.reasoner_id, this.index, this.mapping_extractor, this.overlappingExtractor, true);
        this.anchor_assessment.classifyAndRepairUnsatisfiability();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time cleaning anchors with DL reasoner (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.mapping_extractor.setExactAsFixed(true);
        this.index.setJointReasoner(this.anchor_assessment.getReasoner());
        this.countAnchors();
    }

    private void countAnchors() {
        int numMappings = 0;
        for (int ide1 : this.mapping_extractor.getLogMapMappings().keySet()) {
            for (int ide2 : this.mapping_extractor.getLogMapMappings().get(ide1)) {
                if (ide1 >= ide2) continue;
                ++numMappings;
            }
        }
        LogOutput.print("\nNum Anchors: " + numMappings + "\n");
    }

    private void createCandidateMappings() throws Exception {
        this.mapping_extractor.createCandidates();
        this.index.clearAlternativeLabels4Classes();
        this.countAnchors();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.anchor_assessment.clearStructures();
        this.anchor_assessment = new AnchorsAssessmentFullReasoning(this.reasoner_id, this.index, this.mapping_extractor, this.overlappingExtractor, false);
        this.anchor_assessment.classifyAndRepairUnsatisfiability();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time cleaning new candidates DL Reasoner (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.mapping_extractor.moveMappingsToReview2AnchorList();
        this.countAnchors();
        this.mapping_extractor.getMappings2Review().clear();
        this.index.setJointReasoner(this.anchor_assessment.getReasoner());
        this.mapping_extractor.assessMappings2AskUser();
        StatisticsManager.extractStatisticsAnchors();
        this.mapping_extractor.printHarDiscardedStatistics();
    }

    private void createMappingsInteractiveProcess(boolean useThreshold) throws Exception {
        this.init = Calendar.getInstance().getTimeInMillis();
        this.interactiveProcessManager = new InteractiveProcessAmbiguity(this.index, this.mapping_extractor, false, false, 0, false, false, "");
        this.interactiveProcessManager.endInteractiveProcess(this.mapping_extractor.isFilterWithHeuristicsSecondLevelMappings());
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time interactive process (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.anchor_assessment.clearStructures();
        this.anchor_assessment = new AnchorsAssessmentFullReasoning(this.reasoner_id, this.index, this.mapping_extractor, this.overlappingExtractor, false);
        this.anchor_assessment.classifyAndRepairUnsatisfiability();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time cleaning interacrtive mappings DL reasoner (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.mapping_extractor.moveMappingsToReview2AnchorList();
        this.mapping_extractor.getMappings2Review().clear();
    }

    private void loadMappingsGS() throws Exception {
        ReadFile reader = new ReadFile(this.gs_mappings);
        String line = reader.readLine();
        while (line != null) {
            if (line.indexOf("|") < 0) {
                line = reader.readLine();
                continue;
            }
            String[] elements = line.split("\\|");
            int index1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(elements[0]));
            int index2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(elements[1]));
            if (index1 > 0 && index2 > 0) {
                this.mapping_extractor.addMapping2GoldStandardAnchors(index1, index2);
            }
            this.mappings_gs.add(new MappingObjectStr(elements[0], elements[1]));
            this.mapping_extractor.getStringGoldStandardAnchors().add(new MappingObjectStr(elements[0], elements[1]));
            line = reader.readLine();
        }
        reader.closeBuffer();
    }

    private void getPrecisionAndRecallMappings() throws Exception {
        this.mapping_extractor.setStringAnchors();
        StatisticsManager.setMFinal(this.mapping_extractor.getStringLogMapMappings().size());
        LogOutput.print("MAPPINGS: " + this.mapping_extractor.getStringLogMapMappings().size());
        HashSet<MappingObjectStr> intersection = new HashSet<MappingObjectStr>(this.mapping_extractor.getStringLogMapMappings());
        intersection.retainAll(this.mappings_gs);
        StatisticsManager.setGoodMFinal(intersection.size());
        double precision = (double)intersection.size() / (double)this.mapping_extractor.getStringLogMapMappings().size();
        double recall = (double)intersection.size() / (double)this.mappings_gs.size();
        System.out.println("MAPPINGS: " + this.mapping_extractor.getStringLogMapMappings().size());
        System.out.println("WRT GS MAPPINGS");
        System.out.println("\tPrecision Mappings: " + precision);
        System.out.println("\tRecall Mapping: " + recall);
        System.out.println("\tF measure: " + 2.0 * recall * precision / (precision + recall));
        LogOutput.print("WRT GS MAPPINGS");
        LogOutput.print("\tPrecision Mappings: " + precision);
        LogOutput.print("\tRecall Mapping: " + recall);
        LogOutput.print("\tF measure: " + 2.0 * recall * precision / (precision + recall));
        HashSet<MappingObjectStr> difference = new HashSet<MappingObjectStr>(this.mappings_gs);
        difference.removeAll(this.mapping_extractor.getStringLogMapMappings());
        System.out.println("Difference in GS: " + difference.size());
        HashSet<MappingObjectStr> difference2 = new HashSet<MappingObjectStr>(this.mapping_extractor.getStringLogMapMappings());
        difference2.removeAll(this.mappings_gs);
        System.out.println("Difference in Candidates: " + difference2.size());
        StatisticsManager.setMMissing(difference.size());
    }

    public static void main(String[] args) {
        int reasoner_id;
        int ontopair;
        String uri1 = "";
        String uri2 = "";
        String gs_mappings = "";
        if (args.length == 2) {
            ontopair = Integer.valueOf(args[0]);
            reasoner_id = Integer.valueOf(args[1]);
            LogOutput.print("Ontology pair: " + args[0] + "  " + args[1]);
        } else if (args.length == 4) {
            uri1 = args[0];
            uri2 = args[1];
            gs_mappings = args[2];
            reasoner_id = Integer.valueOf(args[3]);
            ontopair = -1;
            LogOutput.print("Ontology pair: " + uri1 + "  " + uri2 + "  " + gs_mappings + "  " + reasoner_id);
        } else {
            reasoner_id = ReasonerManager.HERMIT;
            ontopair = 5;
        }
        if (ontopair == 0) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_FMA_whole_ontology.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_NCI_whole_ontology.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_FMA_NCI_cleantDG.txt";
        } else if (ontopair == 1) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_FMA_whole_ontology.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/snomed20090131_replab.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_FMA_SNOMED_cleantDG.txt";
        } else if (ontopair == 2) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/snomed20090131_replab.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_NCI_whole_ontology.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_source_data/onto_mappings_SNOMED_NCI_cleantDG.txt";
        } else if (ontopair == 5) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/mouse_anatomy_2010.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/nci_anatomy_2010.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/Anatomy/GSAll_Anatomy_2010.txt";
        } else if (ontopair == 3) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/snomed20110131_replab_with_ids.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/LUCADAOntology15September2011.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/references_to_snomed.txt";
        } else if (ontopair == 8) {
            uri1 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/fma2nci_dataset/oaei2012_NCI_whole_ontology.owl";
            uri2 = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/LUCADAOntology15September2011.owl";
            gs_mappings = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/references_to_nci.txt";
        }
        try {
            new LogMap_Full(uri1, uri2, gs_mappings, reasoner_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

