/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.OntologyLoader;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.JointIndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.mappings.CandidateMappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReaderManager;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor4Mappings;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap2.repair.AnchorAssessment;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class LogMap2_RepairFacility {
    private long init_global;
    private long init;
    private long fin;
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private JointIndexManager index;
    private CandidateMappingManager mapping_manager;
    private AnchorAssessment mapping_assessment;
    private OWLOntology onto1;
    private OWLOntology onto2;
    private Set<MappingObjectStr> input_mappings;
    private boolean overlapping;
    private boolean method_optimal;
    private boolean useLogMapConfidences;
    private TreeSet<MappingObjectStr> ordered_mappings = new TreeSet<MappingObjectStr>(new MappingComparator());
    private Set<MappingObjectStr> clean_mappings = new HashSet<MappingObjectStr>();
    protected Map<Integer, Set<Integer>> mappings2Review_step2 = new HashMap<Integer, Set<Integer>>();
    private double average_confidence = 0.0;
    int num_anchors = 0;
    int num_mappings2review = 0;

    public LogMap2_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> mappings, boolean sat_check) {
        this(onto1, onto2, mappings, false, false, sat_check, "");
    }

    public LogMap2_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> mappings, boolean overlapping, boolean optimal) {
        this(onto1, onto2, mappings, overlapping, optimal, false, "");
    }

    public LogMap2_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> mappings, boolean overlapping, boolean optimal, boolean chechSatisfiability, String outPutFileName) {
        this(onto1, onto2, mappings, overlapping, optimal, false, chechSatisfiability, outPutFileName);
    }

    public LogMap2_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> mappings, boolean overlapping, boolean optimal, boolean useLogMapConfidences, boolean chechSatisfiability, String outPutFileName) {
        this.onto1 = onto1;
        this.onto2 = onto2;
        this.input_mappings = mappings;
        this.overlapping = overlapping;
        this.method_optimal = optimal;
        this.useLogMapConfidences = useLogMapConfidences;
        try {
            this.init_global = this.init = Calendar.getInstance().getTimeInMillis();
            this.setUpStructures();
            this.assessMappings();
            this.keepRepairedMappings();
            if (!outPutFileName.equals("")) {
                this.saveRepairedMappings(outPutFileName);
            }
            if (chechSatisfiability) {
                this.checkSatisfiabilityMappings(this.clean_mappings);
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            System.out.println("TOTAL REPAIR TIME (s): " + (double)((float)((double)this.fin - (double)this.init_global)) / 1000.0);
        }
        catch (Exception e) {
            System.out.println("Error repairing mappings using LogMap repair module: " + e.getMessage());
        }
    }

    public LogMap2_RepairFacility(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> fixedmappings, Set<MappingObjectStr> mappings2review) {
        this.onto1 = onto1;
        this.onto2 = onto2;
        this.input_mappings = fixedmappings;
        this.overlapping = false;
        this.method_optimal = true;
        try {
            this.init_global = this.init = Calendar.getInstance().getTimeInMillis();
            this.setUpStructures();
            this.assessMappings();
            this.keepRepairedMappings();
            this.fin = Calendar.getInstance().getTimeInMillis();
            System.out.println("TOTAL REPAIR TIME (s): " + (double)((float)((double)this.fin - (double)this.init_global)) / 1000.0);
        }
        catch (Exception e) {
            System.out.println("Error repairing mappings using LogMap repair module: " + e.getMessage());
        }
    }

    private void addSubMapping2Mappings2Review(int index1, int index2) {
        if (!this.mappings2Review_step2.containsKey(index1)) {
            this.mappings2Review_step2.put(index1, new HashSet());
        }
        this.mappings2Review_step2.get(index1).add(index2);
    }

    private void associateType2Mappings() {
        int num_original_class_mappings = 0;
        int num_original_dprop_mappings = 0;
        int num_original_oprop_mappings = 0;
        int num_original_instance_mappings = 0;
        int num_mixed_mappings = 0;
        double min_confidence = 2.0;
        double max_confidence = 0.0;
        this.average_confidence = 0.0;
        for (MappingObjectStr map : this.input_mappings) {
            this.average_confidence += map.getConfidence();
            if (map.getConfidence() < min_confidence) {
                min_confidence = map.getConfidence();
            }
            if (map.getConfidence() > max_confidence) {
                max_confidence = map.getConfidence();
            }
            if (this.onto1.containsClassInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsClassInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(0);
                this.ordered_mappings.add(map);
                ++num_original_class_mappings;
                continue;
            }
            if (this.onto1.containsObjectPropertyInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsObjectPropertyInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(2);
                this.ordered_mappings.add(map);
                ++num_original_oprop_mappings;
                continue;
            }
            if (this.onto1.containsDataPropertyInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsDataPropertyInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(1);
                this.ordered_mappings.add(map);
                ++num_original_dprop_mappings;
                continue;
            }
            if (this.onto1.containsIndividualInSignature(IRI.create((String)map.getIRIStrEnt1()), true) && this.onto2.containsIndividualInSignature(IRI.create((String)map.getIRIStrEnt2()), true)) {
                map.setTypeOfMapping(3);
                this.ordered_mappings.add(map);
                ++num_original_instance_mappings;
                continue;
            }
            ++num_mixed_mappings;
        }
        this.average_confidence /= (double)this.input_mappings.size();
        LogOutput.printAlways("Num original mappings: " + this.input_mappings.size());
        LogOutput.print("\tNum original class mappings: " + num_original_class_mappings);
        LogOutput.print("\tNum original object property mappings: " + num_original_oprop_mappings);
        LogOutput.print("\tNum original data property mappings: " + num_original_dprop_mappings);
        LogOutput.print("\tNum original instance mappings: " + num_original_instance_mappings);
        LogOutput.print("\tNum mixed mappings: " + num_mixed_mappings);
        LogOutput.print("\tMin confidence: " + min_confidence);
        LogOutput.print("\tMax confidence: " + max_confidence);
        LogOutput.print("\tAVERAGE confidence: " + this.average_confidence);
        if (!this.method_optimal) {
            this.average_confidence = -1.0;
        }
    }

    private void addMapping2Structures() {
        this.mappings2Review_step2.clear();
        Iterator<MappingObjectStr> it = this.ordered_mappings.descendingIterator();
        while (it.hasNext()) {
            MappingObjectStr map = it.next();
            if (map.getTypeOfMapping() == 0) {
                this.addClassMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() == 2) {
                this.addObjectPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() == 1) {
                this.addDataPropertyMapping(map);
                continue;
            }
            if (map.getTypeOfMapping() != 3) continue;
            this.addInstanceMapping(map);
        }
        this.ordered_mappings.clear();
        LogOutput.print("Numb of reliable mappings: " + this.num_anchors);
        LogOutput.print("Numb of other mappings: " + this.num_mappings2review);
    }

    private void setUpStructures() throws Exception {
        LogOutput.showOutpuLog(false);
        this.associateType2Mappings();
        this.index = new JointIndexManager();
        if (this.overlapping) {
            OverlappingExtractor4Mappings overlapping = new OverlappingExtractor4Mappings();
            overlapping.createOverlapping(this.onto1, this.onto2, this.input_mappings);
            this.onto_process1 = new OntologyProcessing(overlapping.getOverlappingOnto1(), this.index, new LexicalUtilities());
            this.onto_process2 = new OntologyProcessing(overlapping.getOverlappingOnto2(), this.index, new LexicalUtilities());
        } else {
            this.onto_process1 = new OntologyProcessing(this.onto1, this.index, new LexicalUtilities());
            this.onto_process2 = new OntologyProcessing(this.onto2, this.index, new LexicalUtilities());
        }
        this.mapping_manager = new CandidateMappingManager(this.index, this.onto_process1, this.onto_process2);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.precessLexicon(this.useLogMapConfidences);
        this.onto_process2.precessLexicon(this.useLogMapConfidences);
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time indexing entities (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.onto_process1.setTaxonomicData();
        this.onto_process2.setTaxonomicData();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time extracting structural information (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        this.addMapping2Structures();
        this.onto_process1.clearReasoner();
        this.onto_process1.getClass2Identifier().clear();
        this.onto_process2.clearReasoner();
        this.onto_process2.getClass2Identifier().clear();
    }

    private void assessMappings() {
        if (this.method_optimal) {
            this.assessClassMappings2steps();
        } else {
            this.assessClassMappings1step();
        }
        if (this.mapping_manager.getDataPropertyAnchors().size() > 0 || this.mapping_manager.getObjectPropertyAnchors().size() > 0) {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.mapping_manager.evaluateCompatibilityDataPropertyMappings();
            this.mapping_manager.evaluateCompatibilityObjectPropertyMappings();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime assessing property mappings (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
        if (this.mapping_manager.getInstanceMappings().size() > 0) {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.mapping_manager.evaluateCompatibilityInstanceMappings();
            if (this.mapping_manager.getInstanceMappings().size() > 0) {
                this.init = Calendar.getInstance().getTimeInMillis();
                this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG_Individuals(this.mapping_manager.getInstanceMappings());
                this.fin = Calendar.getInstance().getTimeInMillis();
                LogOutput.print("Time cleaning instance mappings D&G (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            }
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime assessing instance mappings (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
    }

    private void assessClassMappings2steps() {
        int discarded_with_index = 0;
        this.mapping_assessment = new AnchorAssessment(this.index, this.mapping_manager);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_manager.getLogMapMappings());
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime cleaning reliable class mappings Dowling and Gallier (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        LogOutput.print("\tRepaired Root Unsat using Dowling and Gallier (aproximation): " + this.mapping_assessment.getNumRepairedUnsatClasses());
        this.mapping_manager.setExactAsFixed(true);
        try {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.index.setIntervalLabellingIndex(this.mapping_manager.getFixedMappings());
            this.index.clearAuxStructuresforLabellingSchema();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime indexing hierarchy + anchors (ILS) (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            for (int ide1 : this.mappings2Review_step2.keySet()) {
                for (int ide2 : this.mappings2Review_step2.get(ide1)) {
                    if (this.mapping_manager.isMappingInConflictWithFixedMappings(ide1, ide2)) {
                        ++discarded_with_index;
                        continue;
                    }
                    this.mapping_manager.addSubMapping2Mappings2Review(ide1, ide2);
                }
            }
            LogOutput.print("Discarded with index: " + discarded_with_index);
        }
        catch (Exception e) {
            System.out.println("Error creating Interval Labelling index 1: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.mapping_manager.getMappings2Review().size() > 0) {
            this.mapping_manager.setExactAsFixed(false);
            this.init = Calendar.getInstance().getTimeInMillis();
            this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_manager.getMappings2Review());
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("Time cleaning rest of the mappings using D&G (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            LogOutput.print("\tRepaired Root Unsat using Dowling and Gallier 2 (aproximation): " + this.mapping_assessment.getNumRepairedUnsatClasses());
            this.mapping_manager.moveMappingsToReview2AnchorList();
            try {
                this.init = Calendar.getInstance().getTimeInMillis();
                this.index.setIntervalLabellingIndex(this.mapping_manager.getLogMapMappings());
                this.index.clearAuxStructuresforLabellingSchema();
                this.fin = Calendar.getInstance().getTimeInMillis();
                LogOutput.print("Time indexing hierarchy + anchors and candidates I (ILS) (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
            }
            catch (Exception e) {
                System.out.println("Error creating Interval Labelling index 2: " + e.getMessage());
                e.printStackTrace();
            }
        }
        for (int ide1 : this.mapping_manager.getWeakenedDandGMappings().keySet()) {
            for (int ide2 : this.mapping_manager.getWeakenedDandGMappings().get(ide1)) {
                if (this.mapping_manager.isMappingInConflictWithFixedMappings(ide1, ide2)) continue;
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            }
        }
    }

    private void assessClassMappings1step() {
        this.mapping_assessment = new AnchorAssessment(this.index, this.mapping_manager);
        this.init = Calendar.getInstance().getTimeInMillis();
        this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_manager.getLogMapMappings());
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\tTime cleaning class mappings Dowling and Gallier (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        LogOutput.print("\tRepaired Root Unsat using Dowling and Gallier (aproximation): " + this.mapping_assessment.getNumRepairedUnsatClasses());
        try {
            this.init = Calendar.getInstance().getTimeInMillis();
            this.index.setIntervalLabellingIndex(this.mapping_manager.getLogMapMappings());
            this.index.clearAuxStructuresforLabellingSchema();
            this.fin = Calendar.getInstance().getTimeInMillis();
            LogOutput.print("\tTime indexing hierarchy + anchors (ILS) (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        }
        catch (Exception e) {
            System.out.println("Error creating Interval Labelling index: " + e.getMessage());
            e.printStackTrace();
        }
        for (int ide1 : this.mapping_manager.getWeakenedDandGMappings().keySet()) {
            for (int ide2 : this.mapping_manager.getWeakenedDandGMappings().get(ide1)) {
                if (this.mapping_manager.isMappingInConflictWithFixedMappings(ide1, ide2)) continue;
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            }
        }
    }

    private void addClassMapping(MappingObjectStr map) {
        double scoreScope;
        double scoreISUB;
        int ide1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Classes not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        if (this.useLogMapConfidences) {
            scoreISUB = this.mapping_manager.extractISUB4Mapping(ide1, ide2);
            scoreScope = this.mapping_manager.extractScopeAll4Mapping(ide1, ide2);
        } else {
            this.mapping_manager.addIsub2Structure(ide1, ide2, map.getConfidence());
            this.mapping_manager.addIsub2Structure(ide2, ide1, map.getConfidence());
            scoreISUB = map.getConfidence();
            scoreScope = map.getConfidence();
        }
        if (this.method_optimal) {
            if (scoreISUB >= Parameters.good_isub_anchors && scoreScope > Parameters.bad_score_scope && map.getMappingDirection() == -2) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
                ++this.num_anchors;
            } else if (map.getMappingDirection() == 0) {
                this.addSubMapping2Mappings2Review(ide1, ide2);
                ++this.num_mappings2review;
            } else {
                this.addSubMapping2Mappings2Review(ide2, ide1);
                ++this.num_mappings2review;
            }
        } else {
            ++this.num_anchors;
            if (map.getMappingDirection() == -2) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
            } else if (map.getMappingDirection() == 0) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
            } else {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
            }
        }
    }

    private void addClassMapping2(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Classes not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addIsub2Structure(ide1, ide2, map.getConfidence());
        this.mapping_manager.addIsub2Structure(ide2, ide1, map.getConfidence());
        if (2 * this.num_anchors < this.ordered_mappings.size() || !this.method_optimal) {
            ++this.num_anchors;
            if (map.getMappingDirection() == -2) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
            } else if (map.getMappingDirection() == 0) {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide1, ide2);
                if (this.method_optimal) {
                    this.addSubMapping2Mappings2Review(ide1, ide2);
                }
            } else {
                this.mapping_manager.addSubMapping2ListOfAnchors(ide2, ide1);
                if (this.method_optimal) {
                    this.addSubMapping2Mappings2Review(ide2, ide1);
                }
            }
        } else {
            ++this.num_mappings2review;
            if (map.getMappingDirection() == -2) {
                this.addSubMapping2Mappings2Review(ide1, ide2);
                this.addSubMapping2Mappings2Review(ide2, ide1);
            } else if (map.getMappingDirection() == 0) {
                this.addSubMapping2Mappings2Review(ide1, ide2);
            } else {
                this.addSubMapping2Mappings2Review(ide2, ide1);
            }
        }
    }

    private void addObjectPropertyMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4ObjectPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Object properties not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addObjectPropertyAnchor(ide1, ide2);
        this.mapping_manager.addObjectPropertyAnchorConfidence(ide1, map.getConfidence());
    }

    private void addDataPropertyMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4DataPropName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Data properties not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addDataPropertyAnchor(ide1, ide2);
        this.mapping_manager.addDataPropertyAnchorConfidence(ide1, map.getConfidence());
    }

    private void addInstanceMapping(MappingObjectStr map) {
        int ide1 = this.onto_process1.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt1()));
        int ide2 = this.onto_process2.getIdentifier4InstanceName(Utilities.getEntityLabelFromURI(map.getIRIStrEnt2()));
        if (ide1 < 0 || ide2 < 0) {
            LogOutput.print("Individuals not found in ontology.");
            LogOutput.print("\t" + ide1 + "  " + map.getIRIStrEnt1());
            LogOutput.print("\t" + ide2 + "  " + map.getIRIStrEnt2());
            return;
        }
        this.mapping_manager.addInstanceMapping(ide1, ide2);
        this.mapping_manager.addInstanceAnchorConfidence(ide1, ide2, map.getConfidence());
    }

    public void saveRepairedMappings(String outPutFileName) {
        this.saveRepairedMappings(outPutFileName, 4);
    }

    public void saveRepairedMappings(String outPutFileName, int format) {
        OutPutFilesManager outPutFilesManager = new OutPutFilesManager();
        int num_clean_mappings = 0;
        int num_clean_class_mappings = 0;
        int num_clean_dprop_mappings = 0;
        int num_clean_oprop_mappings = 0;
        int num_clean_instance_mappings = 0;
        try {
            outPutFilesManager.createOutFiles(outPutFileName, format, this.onto_process1.getOntoIRI(), this.onto_process1.getOntoIRI());
            for (int idea : this.mapping_manager.getLogMapMappings().keySet()) {
                for (int ideb : this.mapping_manager.getLogMapMappings().get(idea)) {
                    if (this.mapping_manager.isId1SmallerThanId2(idea, ideb)) {
                        int dirMapping = this.mapping_manager.isMappingAlreadyInList(ideb, idea) ? -2 : 0;
                        ++num_clean_mappings;
                        ++num_clean_class_mappings;
                        outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(idea), this.index.getIRIStr4ConceptIndex(ideb), dirMapping, this.mapping_manager.getConfidence4Mapping(idea, ideb));
                        continue;
                    }
                    if (this.mapping_manager.isMappingAlreadyInList(ideb, idea)) continue;
                    ++num_clean_mappings;
                    ++num_clean_class_mappings;
                    outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(ideb), this.index.getIRIStr4ConceptIndex(idea), -1, this.mapping_manager.getConfidence4Mapping(idea, ideb));
                }
            }
            for (int ide1 : this.mapping_manager.getDataPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_dprop_mappings;
                outPutFilesManager.addDataPropMapping2Files(this.index.getIRIStr4DataPropIndex(ide1), this.index.getIRIStr4DataPropIndex(this.mapping_manager.getDataPropertyAnchors().get(ide1)), -2, this.mapping_manager.getConfidence4DataPropertyAnchor(ide1, this.mapping_manager.getDataPropertyAnchors().get(ide1)));
            }
            for (int ide1 : this.mapping_manager.getObjectPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_oprop_mappings;
                outPutFilesManager.addObjPropMapping2Files(this.index.getIRIStr4ObjPropIndex(ide1), this.index.getIRIStr4ObjPropIndex(this.mapping_manager.getObjectPropertyAnchors().get(ide1)), -2, this.mapping_manager.getConfidence4ObjectPropertyAnchor(ide1, this.mapping_manager.getObjectPropertyAnchors().get(ide1)));
            }
            for (int ide1 : this.mapping_manager.getInstanceMappings().keySet()) {
                for (int ide2 : this.mapping_manager.getInstanceMappings().get(ide1)) {
                    ++num_clean_mappings;
                    ++num_clean_instance_mappings;
                    outPutFilesManager.addInstanceMapping2Files(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), this.mapping_manager.getConfidence4InstanceMapping(ide1, ide2));
                }
            }
            LogOutput.printAlways("Num repaired mappings: " + num_clean_mappings);
            LogOutput.print("\tNum repaired class mappings: " + num_clean_class_mappings);
            LogOutput.print("\tNum repaired object property mappings: " + num_clean_oprop_mappings);
            LogOutput.print("\tNum repaired data property mappings: " + num_clean_dprop_mappings);
            LogOutput.print("\tNum repaired instance mappings: " + num_clean_instance_mappings);
            outPutFilesManager.closeAndSaveFiles();
        }
        catch (Exception e) {
            System.err.println("Error saving mappings...");
            e.printStackTrace();
        }
    }

    public Set<MappingObjectStr> getCleanMappings() {
        return this.clean_mappings;
    }

    public Set<MappingObjectStr> getInputMappings() {
        return this.input_mappings;
    }

    public int getSizeOfRepair() {
        int clauses = 0;
        for (int ide1 : this.mapping_manager.getConflictiveMappings().keySet()) {
            clauses += this.mapping_manager.getConflictiveMappings().get(ide1).size();
        }
        return clauses;
    }

    public void checkSatisfiabilityInputMappings() throws Exception {
        this.checkSatisfiabilityMappings(this.input_mappings);
    }

    public void checkSatisfiabilityCleanMappings() throws Exception {
        this.checkSatisfiabilityMappings(this.clean_mappings);
    }

    public void checkSatisfiabilityMappings(Set<MappingObjectStr> mappings) throws Exception {
        OWLOntology mappins_owl_onto = this.getOWLOntology4GivenMappings(mappings);
        SatisfiabilityIntegration.setTimeoutClassSatisfiabilityCheck(60);
        SatisfiabilityIntegration sat_checker = new SatisfiabilityIntegration(this.onto1, this.onto2, mappins_owl_onto, true, true, false);
        LogOutput.print("Num unsat classes lead by repaired mappings using LogMap: " + sat_checker.getNumUnsatClasses());
    }

    public OWLOntology getOWLOntology4CleanMappings() throws Exception {
        return this.getOWLOntology4GivenMappings(this.clean_mappings);
    }

    public OWLOntology getOWLOntology4GivenMappings(Set<MappingObjectStr> mappings) throws Exception {
        OWLAlignmentFormat owlformat = new OWLAlignmentFormat("");
        for (MappingObjectStr mapping : mappings) {
            if (mapping.getTypeOfMapping() == 12) {
                owlformat.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 0) {
                owlformat.addClassMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() == 2) {
                owlformat.addObjPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.getTypeOfMapping() != 1) continue;
            owlformat.addDataPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        }
        return owlformat.getOWLOntology();
    }

    private void keepRepairedMappings() {
        int num_clean_mappings = 0;
        int num_clean_class_mappings = 0;
        int num_clean_dprop_mappings = 0;
        int num_clean_oprop_mappings = 0;
        int num_clean_instance_mappings = 0;
        this.clean_mappings.clear();
        try {
            for (int idea : this.mapping_manager.getLogMapMappings().keySet()) {
                for (int ideb : this.mapping_manager.getLogMapMappings().get(idea)) {
                    if (this.mapping_manager.isId1SmallerThanId2(idea, ideb)) {
                        int dirMapping = this.mapping_manager.isMappingAlreadyInList(ideb, idea) ? -2 : 0;
                        ++num_clean_mappings;
                        ++num_clean_class_mappings;
                        this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(idea), this.index.getIRIStr4ConceptIndex(ideb), this.mapping_manager.getConfidence4Mapping(idea, ideb), dirMapping, 0));
                        continue;
                    }
                    if (this.mapping_manager.isMappingAlreadyInList(ideb, idea)) continue;
                    ++num_clean_mappings;
                    ++num_clean_class_mappings;
                    this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(ideb), this.index.getIRIStr4ConceptIndex(idea), this.mapping_manager.getConfidence4Mapping(idea, ideb), -1, 0));
                }
            }
            for (int ide1 : this.mapping_manager.getDataPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_dprop_mappings;
                this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ConceptIndex(ide1), this.index.getIRIStr4DataPropIndex(this.mapping_manager.getDataPropertyAnchors().get(ide1)), this.mapping_manager.getConfidence4DataPropertyAnchor(ide1, this.mapping_manager.getDataPropertyAnchors().get(ide1)), -2, 1));
            }
            for (int ide1 : this.mapping_manager.getObjectPropertyAnchors().keySet()) {
                ++num_clean_mappings;
                ++num_clean_oprop_mappings;
                this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4ObjPropIndex(ide1), this.index.getIRIStr4ObjPropIndex(this.mapping_manager.getObjectPropertyAnchors().get(ide1)), this.mapping_manager.getConfidence4ObjectPropertyAnchor(ide1, this.mapping_manager.getObjectPropertyAnchors().get(ide1)), -2, 2));
            }
            for (int ide1 : this.mapping_manager.getInstanceMappings().keySet()) {
                for (int ide2 : this.mapping_manager.getInstanceMappings().get(ide1)) {
                    ++num_clean_mappings;
                    ++num_clean_instance_mappings;
                    this.clean_mappings.add(new MappingObjectStr(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), this.mapping_manager.getConfidence4InstanceMapping(ide1, ide2), -2, 3));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error keeping mappings...");
            e.printStackTrace();
        }
    }

    private static Set<MappingObjectStr> emptyMappings() throws Exception {
        HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
        mappings.add(new MappingObjectStr("http://csu6325.cs.ox.ac.uk/ontologies/matching_21_05_2012/emptyOntology.owl#lala", "http://csu6325.cs.ox.ac.uk/ontologies/matching_31_05_2012/ontology_31_05_2012__18_53_50_221#lala", 1.0, -2));
        return mappings;
    }

    private static Set<MappingObjectStr> readMappings(String file) throws Exception {
        HashSet<MappingObjectStr> mappings = new HashSet<MappingObjectStr>();
        ReadFile reader = new ReadFile(file);
        String line = reader.readLine();
        while (line != null) {
            if (line.indexOf("|") < 0) {
                line = reader.readLine();
                continue;
            }
            String[] elements = line.split("\\|");
            if (elements.length < 4) continue;
            int dir = elements[2].equals(">") ? -1 : (elements[2].equals("<") ? 0 : -2);
            mappings.add(new MappingObjectStr(elements[0], elements[1], Double.valueOf(elements[3]), dir));
            line = reader.readLine();
        }
        reader.closeBuffer();
        return mappings;
    }

    private static String getHelpMessage() {
        return "LogMap's repair facility requires 7 parameters:\n\t1. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t2. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t3. Format mappings e.g.: OWL  or  RDF  or  TXT\n\t4. Full IRI or full Path:\n\t\ta. Full IRI of input mappings if OWL format. e.g.: file:/C://mymappings.owl  or  file:/usr/local/mymappings.owl  or http://mymappings.owl\n\t\tb. Full path of input mappings if formats RDF or TXT. e.g.: C://mymappings.rdf  or  /usr/local/mymappings.txt\n\t5. Full output path for the repaired mappings: e.g. /usr/local/output_path or C://output_path\n\t6. Extract modules for repair?: true or false\n\t7. Check satisfiability after repair using HermiT? true or false\n";
    }

    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                System.out.println(LogMap2_RepairFacility.getHelpMessage());
                return;
            }
            String iri_onto1 = args[0];
            String iri_onto2 = args[1];
            String format_mappings = args[2];
            String input_mappings_path = args[3];
            String output_path = args[4];
            boolean overlapping = Boolean.valueOf(args[5]);
            boolean satisfiability_check = Boolean.valueOf(args[6]);
            LogOutput.printAlways("Loading ontologies...");
            OntologyLoader loader1 = new OntologyLoader(iri_onto1);
            OntologyLoader loader2 = new OntologyLoader(iri_onto2);
            LogOutput.printAlways("...Done");
            MappingsReaderManager readermanager = new MappingsReaderManager(input_mappings_path, format_mappings);
            new LogMap2_RepairFacility(loader1.getOWLOntology(), loader2.getOWLOntology(), readermanager.getMappingObjects(), overlapping, false, satisfiability_check, output_path + "/mappings_repaired_with_LogMap");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class MappingComparator
    implements Comparator<MappingObjectStr> {
        private MappingComparator() {
        }

        @Override
        public int compare(MappingObjectStr m1, MappingObjectStr m2) {
            if (m1.getConfidence() < m2.getConfidence()) {
                return -1;
            }
            return 1;
        }
    }
}

