/*
 * Decompiled with CFR 0.152.
 */
package org.ictclas4j.segment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.ictclas4j.bean.Dictionary;
import org.ictclas4j.bean.MidResult;
import org.ictclas4j.bean.SegNode;
import org.ictclas4j.bean.SegResult;
import org.ictclas4j.bean.Sentence;
import org.ictclas4j.segment.AdjustSeg;
import org.ictclas4j.segment.AtomSeg;
import org.ictclas4j.segment.GraphGenerate;
import org.ictclas4j.segment.NShortPath;
import org.ictclas4j.segment.PosTagger;
import org.ictclas4j.segment.SegGraph;
import org.ictclas4j.segment.SentenceSeg;
import org.ictclas4j.utility.Utility;
import uk.ac.ox.krr.logmap2.Parameters;

public class SegTag2 {
    private Dictionary coreDict;
    private Dictionary bigramDict;
    private PosTagger personTagger;
    private PosTagger transPersonTagger;
    private PosTagger placeTagger;
    private PosTagger lexTagger;
    private int segPathCount = 1;

    public SegTag2(int segPathCount) {
        this.segPathCount = segPathCount;
        this.coreDict = new Dictionary(Parameters.path_chinese_segmenter_dict + "/coreDict.dct");
        this.bigramDict = new Dictionary(Parameters.path_chinese_segmenter_dict + "/bigramDict.dct");
        this.personTagger = new PosTagger(Utility.TAG_TYPE.TT_PERSON, Parameters.path_chinese_segmenter_dict + "/nr", this.coreDict);
        this.transPersonTagger = new PosTagger(Utility.TAG_TYPE.TT_TRANS_PERSON, Parameters.path_chinese_segmenter_dict + "/tr", this.coreDict);
        this.placeTagger = new PosTagger(Utility.TAG_TYPE.TT_TRANS_PERSON, Parameters.path_chinese_segmenter_dict + "/ns", this.coreDict);
        this.lexTagger = new PosTagger(Utility.TAG_TYPE.TT_NORMAL, Parameters.path_chinese_segmenter_dict + "/lexical", this.coreDict);
    }

    public SegTag2(int segPathCount, InputStream coreDictIn, InputStream bigramDictIn, InputStream personTaggerDctIn, InputStream personTaggerCtxIn, InputStream transPersonTaggerDctIn, InputStream transPersonTaggerCtxIn, InputStream placeTaggerDctIn, InputStream placeTaggerCtxIn, InputStream lexTaggerCtxIn) {
        this.segPathCount = segPathCount;
        this.coreDict = new Dictionary();
        this.coreDict.load(coreDictIn, false);
        this.bigramDict = new Dictionary();
        this.bigramDict.load(bigramDictIn, false);
        this.personTagger = new PosTagger(Utility.TAG_TYPE.TT_PERSON, personTaggerDctIn, personTaggerCtxIn, this.coreDict);
        this.transPersonTagger = new PosTagger(Utility.TAG_TYPE.TT_TRANS_PERSON, transPersonTaggerDctIn, transPersonTaggerCtxIn, this.coreDict);
        this.placeTagger = new PosTagger(Utility.TAG_TYPE.TT_TRANS_PERSON, placeTaggerDctIn, placeTaggerCtxIn, this.coreDict);
        this.lexTagger = new PosTagger(Utility.TAG_TYPE.TT_NORMAL, null, lexTaggerCtxIn, this.coreDict);
    }

    public SegResult split(String src) {
        SegResult sr = new SegResult(src);
        String finalResult = null;
        if (src != null) {
            finalResult = "";
            int index = 0;
            String midResult = null;
            sr.setRawContent(src);
            SentenceSeg ss = new SentenceSeg(src);
            ArrayList sens = ss.getSens();
            for (Sentence sen : sens) {
                long start = System.currentTimeMillis();
                MidResult mr = new MidResult();
                mr.setIndex(index++);
                mr.setSource(sen.getContent());
                if (sen.isSeg()) {
                    AtomSeg as = new AtomSeg(sen.getContent());
                    ArrayList atoms = as.getAtoms();
                    mr.setAtoms(atoms);
                    SegTag2.println2Err("[atom time]:" + (System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    SegGraph segGraph = GraphGenerate.generate((ArrayList)atoms, (Dictionary)this.coreDict);
                    mr.setSegGraph(segGraph.getSnList());
                    SegGraph biSegGraph = GraphGenerate.biGenerate((SegGraph)segGraph, (Dictionary)this.coreDict, (Dictionary)this.bigramDict);
                    mr.setBiSegGraph(biSegGraph.getSnList());
                    SegTag2.println2Err("[graph time]:" + (System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    NShortPath nsp = new NShortPath(biSegGraph, this.segPathCount);
                    ArrayList bipath = nsp.getPaths();
                    mr.setBipath(bipath);
                    SegTag2.println2Err("[NSP time]:" + (System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    for (ArrayList onePath : bipath) {
                        ArrayList<SegNode> segPath = this.getSegPath(segGraph, onePath);
                        ArrayList firstPath = AdjustSeg.firstAdjust(segPath);
                        String firstResult = this.outputResult(firstPath);
                        mr.addFirstResult(firstResult);
                        SegTag2.println2Err("[first time]:" + (System.currentTimeMillis() - start));
                        start = System.currentTimeMillis();
                        SegGraph optSegGraph = new SegGraph(firstPath);
                        ArrayList<SegNode> sns = this.clone(firstPath);
                        this.personTagger.recognition(optSegGraph, sns);
                        this.transPersonTagger.recognition(optSegGraph, sns);
                        this.placeTagger.recognition(optSegGraph, sns);
                        mr.setOptSegGraph(optSegGraph.getSnList());
                        SegTag2.println2Err("[unknown time]:" + (System.currentTimeMillis() - start));
                        start = System.currentTimeMillis();
                        SegGraph optBiSegGraph = GraphGenerate.biGenerate((SegGraph)optSegGraph, (Dictionary)this.coreDict, (Dictionary)this.bigramDict);
                        mr.setOptBiSegGraph(optBiSegGraph.getSnList());
                        NShortPath optNsp = new NShortPath(optBiSegGraph, this.segPathCount);
                        ArrayList optBipath = optNsp.getPaths();
                        mr.setOptBipath(optBipath);
                        ArrayList adjResult = null;
                        Iterator iterator = optBipath.iterator();
                        if (!iterator.hasNext()) continue;
                        ArrayList optOnePath = (ArrayList)iterator.next();
                        ArrayList<SegNode> optSegPath = this.getSegPath(optSegGraph, optOnePath);
                        this.lexTagger.recognition(optSegPath);
                        String optResult = this.outputResult(optSegPath);
                        mr.addOptResult(optResult);
                        adjResult = AdjustSeg.finaAdjust(optSegPath, (PosTagger)this.personTagger, (PosTagger)this.placeTagger);
                        String adjrs = this.outputResult(adjResult);
                        SegTag2.println2Err("[last time]:" + (System.currentTimeMillis() - start));
                        start = System.currentTimeMillis();
                        if (midResult != null) continue;
                        midResult = adjrs;
                    }
                    sr.addMidResult(mr);
                } else {
                    midResult = sen.getContent();
                }
                finalResult = finalResult + midResult;
                midResult = null;
            }
            sr.setFinalResult(finalResult);
        }
        return sr;
    }

    private ArrayList<SegNode> clone(ArrayList<SegNode> sns) {
        ArrayList<SegNode> result = null;
        if (sns != null && sns.size() > 0) {
            result = new ArrayList<SegNode>();
            for (SegNode sn : sns) {
                result.add(sn.clone());
            }
        }
        return result;
    }

    private ArrayList<SegNode> getSegPath(SegGraph sg, ArrayList<Integer> bipath) {
        ArrayList path = null;
        if (sg != null && bipath != null) {
            ArrayList sns = sg.getSnList();
            path = new ArrayList();
            for (int index : bipath) {
                path.add(sns.get(index));
            }
        }
        return path;
    }

    private String outputResult(ArrayList<SegNode> wrList) {
        String result = null;
        String temp = null;
        char[] pos = new char[2];
        if (wrList != null && wrList.size() > 0) {
            result = "";
            for (int i = 0; i < wrList.size(); ++i) {
                SegNode sn = wrList.get(i);
                if (sn.getPos() == 1 || sn.getPos() == 4) continue;
                int tag = Math.abs(sn.getPos());
                pos[0] = (char)(tag / 256);
                pos[1] = (char)(tag % 256);
                temp = "" + pos[0];
                if (pos[1] > '\u0000') {
                    temp = temp + "" + pos[1];
                }
                result = result + sn.getSrcWord() + "/" + temp + " ";
            }
        }
        return result;
    }

    public void setSegPathCount(int segPathCount) {
        this.segPathCount = segPathCount;
    }

    public static void main(String[] args) {
        SegTag2 segTag = new SegTag2(1);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                try {
                    SegResult seg_res = segTag.split("\u6211\u662f\u4e2d\u56fd\u4eba");
                    System.out.println(seg_res.getFinalResult());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void println2Err(String str) {
    }
}

