/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataRangeVisitor;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLDatatypeRestrictionImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLDatatypeRestriction {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final List<OWLFacetRestriction> facetRestrictions;

    @Override
    protected int index() {
        return 4006;
    }

    public OWLDatatypeRestrictionImpl(@Nonnull OWLDatatype datatype, @Nonnull Set<OWLFacetRestriction> facetRestrictions) {
        this.datatype = (OWLDatatype)OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        OWLAPIPreconditions.checkNotNull(facetRestrictions, (String)"facetRestrictions cannot be null");
        this.facetRestrictions = CollectionFactory.sortOptionally(facetRestrictions);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
        for (OWLFacetRestriction facetRestriction : this.facetRestrictions) {
            this.addSignatureEntitiesToSetForValue(entities, (HasSignature)facetRestriction);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (OWLFacetRestriction facetRestriction : this.facetRestrictions) {
            this.addAnonymousIndividualsToSetForValue(anons, (HasAnonymousIndividuals)facetRestriction);
        }
    }

    public DataRangeType getDataRangeType() {
        return DataRangeType.DATATYPE_RESTRICTION;
    }

    public boolean isDatatype() {
        return false;
    }

    public boolean isTopDatatype() {
        return false;
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    public Set<OWLFacetRestriction> getFacetRestrictions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.facetRestrictions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OWLDatatypeRestriction)) {
            return false;
        }
        if (obj instanceof OWLDatatypeRestrictionImpl) {
            OWLDatatypeRestrictionImpl other = (OWLDatatypeRestrictionImpl)obj;
            return other.getDatatype().equals(this.datatype) && other.facetRestrictions.equals(this.facetRestrictions);
        }
        OWLDatatypeRestriction other = (OWLDatatypeRestriction)obj;
        return other.getDatatype().equals(this.datatype) && other.getFacetRestrictions().equals(this.getFacetRestrictions());
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLDatatypeRestriction)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDatatypeRestriction)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatypeRestriction)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatypeRestriction)this);
    }

    public void accept(OWLDataRangeVisitor visitor) {
        visitor.visit((OWLDatatypeRestriction)this);
    }

    public <O> O accept(OWLDataRangeVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatypeRestriction)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDatatypeRestriction other = (OWLDatatypeRestriction)object;
        int diff = this.datatype.compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return OWLDatatypeRestrictionImpl.compareSets(this.facetRestrictions, other.getFacetRestrictions());
    }
}

