/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLAnnotationPropertyImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLAnnotationProperty {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI iri;

    @Override
    protected int index() {
        return 1006;
    }

    public OWLAnnotationPropertyImpl(@Nonnull IRI i) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)i, (String)"i cannot be null");
    }

    public IRI getIRI() {
        return this.iri;
    }

    public EntityType<?> getEntityType() {
        return EntityType.ANNOTATION_PROPERTY;
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isDeprecated() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
    }

    @Override
    protected int compareObjectOfSameType(@Nonnull OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLAnnotationProperty)object).getIRI());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    public boolean isComment() {
        return this.iri.equals((Object)OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    }

    public boolean isLabel() {
        return this.iri.equals((Object)OWLRDFVocabulary.RDFS_LABEL.getIRI());
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not OWLClass");
    }

    public <O> O accept(OWLPropertyExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not OWLDataProperty");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not OWLDatatype");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not OWLIndividual");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not OWLObjectProperty");
    }

    public boolean isBuiltIn() {
        return OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(this.getIRI());
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        return this;
    }

    public boolean isOWLAnnotationProperty() {
        return true;
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationProperty)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLAnnotationProperty)) {
            return false;
        }
        OWLAnnotationProperty other = (OWLAnnotationProperty)obj;
        return this.iri.equals((Object)other.getIRI());
    }

    public boolean isAnonymous() {
        return false;
    }

    public void accept(OWLPropertyExpressionVisitor visitor) {
        visitor.visit((OWLAnnotationProperty)this);
    }

    public boolean isDataPropertyExpression() {
        return false;
    }

    public boolean isObjectPropertyExpression() {
        return false;
    }

    public boolean isOWLTopObjectProperty() {
        return false;
    }

    public boolean isOWLBottomObjectProperty() {
        return false;
    }

    public boolean isOWLTopDataProperty() {
        return false;
    }

    public boolean isOWLBottomDataProperty() {
        return false;
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }
}

