import sys
import unittest

sys.path.append(".")
import pandas as pd
from reademptionlib.vizalign import AlignViz


class Alignviz(unittest.TestCase):
    maxDiff = None
    read_alignment_stats_content = {
        "Species": {
            0: "all",
            1: "all",
            2: "all",
            3: "all",
            4: "all",
            5: "all",
            6: "all",
            7: "all",
            8: "all",
            9: "all",
            10: "all",
            11: "all",
            12: "all",
            13: "all",
            14: "all",
            15: "all",
            16: "all",
            17: "all",
            18: "all",
            19: "homo sapiens",
            20: "homo sapiens",
            21: "homo sapiens",
            22: "homo sapiens",
            23: "homo sapiens",
            24: "homo sapiens",
            25: "homo sapiens",
            26: "homo sapiens",
            27: "homo sapiens",
            28: "homo sapiens",
            29: "homo sapiens",
            30: "homo sapiens",
            31: "Staphylococcus aureus",
            32: "Staphylococcus aureus",
            33: "Staphylococcus aureus",
            34: "Staphylococcus aureus",
            35: "Staphylococcus aureus",
            36: "Staphylococcus aureus",
            37: "Staphylococcus aureus",
            38: "Staphylococcus aureus",
            39: "Staphylococcus aureus",
            40: "Staphylococcus aureus",
            41: "Staphylococcus aureus",
            42: "Staphylococcus aureus",
            43: "Influenza A",
            44: "Influenza A",
            45: "Influenza A",
            46: "Influenza A",
            47: "Influenza A",
            48: "Influenza A",
            49: "Influenza A",
            50: "Influenza A",
            51: "Influenza A",
            52: "Influenza A",
            53: "Influenza A",
            54: "Influenza A",
            55: "homo sapiens",
            56: "homo sapiens",
            57: "homo sapiens",
            58: "homo sapiens",
            59: "homo sapiens",
            60: "homo sapiens",
            61: "homo sapiens",
            62: "homo sapiens",
            63: "homo sapiens",
            64: "homo sapiens",
            65: "homo sapiens",
            66: "homo sapiens",
            67: "homo sapiens",
            68: "homo sapiens",
            69: "homo sapiens",
            70: "homo sapiens",
            71: "homo sapiens",
            72: "homo sapiens",
            73: "homo sapiens",
            74: "homo sapiens",
            75: "homo sapiens",
            76: "homo sapiens",
            77: "homo sapiens",
            78: "homo sapiens",
            79: "homo sapiens",
            80: "homo sapiens",
            81: "homo sapiens",
            82: "homo sapiens",
            83: "homo sapiens",
            84: "homo sapiens",
            85: "homo sapiens",
            86: "homo sapiens",
            87: "homo sapiens",
            88: "homo sapiens",
            89: "homo sapiens",
            90: "homo sapiens",
            91: "homo sapiens",
            92: "homo sapiens",
            93: "homo sapiens",
            94: "homo sapiens",
            95: "homo sapiens",
            96: "homo sapiens",
            97: "homo sapiens",
            98: "homo sapiens",
            99: "homo sapiens",
            100: "homo sapiens",
            101: "homo sapiens",
            102: "homo sapiens",
            103: "homo sapiens",
            104: "homo sapiens",
            105: "homo sapiens",
            106: "homo sapiens",
            107: "homo sapiens",
            108: "homo sapiens",
            109: "homo sapiens",
            110: "Staphylococcus aureus",
            111: "Staphylococcus aureus",
            112: "Staphylococcus aureus",
            113: "Staphylococcus aureus",
            114: "Staphylococcus aureus",
            115: "Influenza A",
            116: "Influenza A",
            117: "Influenza A",
            118: "Influenza A",
            119: "Influenza A",
            120: "Influenza A",
            121: "Influenza A",
            122: "Influenza A",
            123: "Influenza A",
            124: "Influenza A",
        },
        "Statistic": {
            0: "No. of input reads",
            1: "No. of reads - PolyA detected and removed",
            2: "No. of reads - Single 3' A removed",
            3: "No. of reads - Unmodified",
            4: "No. of reads - Removed as too short",
            5: "No. of reads - Long enough and used for alignment",
            6: "Total no. of aligned reads",
            7: "Total no. of unaligned reads",
            8: "Total no. of uniquely aligned reads",
            9: "Total no. of split aligned reads",
            10: "Total no. of multiple aligned reads",
            11: "Total no. of cross aligned reads",
            12: "Total no. of alignments",
            13: "Percentage of aligned reads (compared to no. of input reads)",
            14: "Percentage of aligned reads (compared to no. of long enough reads)",
            15: "Percentage of uniquely aligned reads (in relation to all aligned reads)",
            16: "Percentage of split aligned reads (in relation to all aligned reads)",
            17: "Percentage of multiple aligned reads (in relation to all aligned reads)",
            18: "Percentage of cross aligned reads (in relation to all aligned reads)",
            19: "Total no. of aligned reads",
            20: "Total no. of uniquely aligned reads",
            21: "Total no. of split aligned reads",
            22: "Total no. of multiple aligned reads",
            23: "Total no. of cross aligned reads",
            24: "Total no. of alignments",
            25: "Percentage of aligned reads (compared to no. of input reads)",
            26: "Percentage of aligned reads (compared to no. of long enough reads)",
            27: "Percentage of uniquely aligned reads (in relation to all aligned reads)",
            28: "Percentage of split aligned reads (in relation to all aligned reads)",
            29: "Percentage of multiple aligned reads (in relation to all aligned reads)",
            30: "Percentage of cross aligned reads (in relation to all aligned reads)",
            31: "Total no. of aligned reads",
            32: "Total no. of uniquely aligned reads",
            33: "Total no. of split aligned reads",
            34: "Total no. of multiple aligned reads",
            35: "Total no. of cross aligned reads",
            36: "Total no. of alignments",
            37: "Percentage of aligned reads (compared to no. of input reads)",
            38: "Percentage of aligned reads (compared to no. of long enough reads)",
            39: "Percentage of uniquely aligned reads (in relation to all aligned reads)",
            40: "Percentage of split aligned reads (in relation to all aligned reads)",
            41: "Percentage of multiple aligned reads (in relation to all aligned reads)",
            42: "Percentage of cross aligned reads (in relation to all aligned reads)",
            43: "Total no. of aligned reads",
            44: "Total no. of uniquely aligned reads",
            45: "Total no. of split aligned reads",
            46: "Total no. of multiple aligned reads",
            47: "Total no. of cross aligned reads",
            48: "Total no. of alignments",
            49: "Percentage of aligned reads (compared to no. of input reads)",
            50: "Percentage of aligned reads (compared to no. of long enough reads)",
            51: "Percentage of uniquely aligned reads (in relation to all aligned reads)",
            52: "Percentage of split aligned reads (in relation to all aligned reads)",
            53: "Percentage of multiple aligned reads (in relation to all aligned reads)",
            54: "Percentage of cross aligned reads (in relation to all aligned reads)",
            55: "GL000008.2 - No. of aligned reads",
            56: "GL000008.2 - No. of uniquely aligned reads",
            57: "GL000008.2 - No. of split aligned reads",
            58: "GL000008.2 - No. of multiple aligned reads",
            59: "GL000008.2 - No. of alignments",
            60: "chr1 - No. of aligned reads",
            61: "chr1 - No. of uniquely aligned reads",
            62: "chr1 - No. of split aligned reads",
            63: "chr1 - No. of multiple aligned reads",
            64: "chr1 - No. of alignments",
            65: "chr2 - No. of aligned reads",
            66: "chr2 - No. of uniquely aligned reads",
            67: "chr2 - No. of split aligned reads",
            68: "chr2 - No. of multiple aligned reads",
            69: "chr2 - No. of alignments",
            70: "chr3 - No. of aligned reads",
            71: "chr3 - No. of uniquely aligned reads",
            72: "chr3 - No. of split aligned reads",
            73: "chr3 - No. of multiple aligned reads",
            74: "chr3 - No. of alignments",
            75: "chr19 - No. of aligned reads",
            76: "chr19 - No. of uniquely aligned reads",
            77: "chr19 - No. of split aligned reads",
            78: "chr19 - No. of multiple aligned reads",
            79: "chr19 - No. of alignments",
            80: "chr20 - No. of aligned reads",
            81: "chr20 - No. of uniquely aligned reads",
            82: "chr20 - No. of split aligned reads",
            83: "chr20 - No. of multiple aligned reads",
            84: "chr20 - No. of alignments",
            85: "chr21 - No. of aligned reads",
            86: "chr21 - No. of uniquely aligned reads",
            87: "chr21 - No. of split aligned reads",
            88: "chr21 - No. of multiple aligned reads",
            89: "chr21 - No. of alignments",
            90: "chr22 - No. of aligned reads",
            91: "chr22 - No. of uniquely aligned reads",
            92: "chr22 - No. of split aligned reads",
            93: "chr22 - No. of multiple aligned reads",
            94: "chr22 - No. of alignments",
            95: "chr23 - No. of aligned reads",
            96: "chr23 - No. of uniquely aligned reads",
            97: "chr23 - No. of split aligned reads",
            98: "chr23 - No. of multiple aligned reads",
            99: "chr23 - No. of alignments",
            100: "chrX - No. of aligned reads",
            101: "chrX - No. of uniquely aligned reads",
            102: "chrX - No. of split aligned reads",
            103: "chrX - No. of multiple aligned reads",
            104: "chrX - No. of alignments",
            105: "KQ031388.1 - No. of aligned reads",
            106: "KQ031388.1 - No. of uniquely aligned reads",
            107: "KQ031388.1 - No. of split aligned reads",
            108: "KQ031388.1 - No. of multiple aligned reads",
            109: "KQ031388.1 - No. of alignments",
            110: "NC_007795.1 - No. of aligned reads",
            111: "NC_007795.1 - No. of uniquely aligned reads",
            112: "NC_007795.1 - No. of split aligned reads",
            113: "NC_007795.1 - No. of multiple aligned reads",
            114: "NC_007795.1 - No. of alignments",
            115: "NC_007373.1 - No. of aligned reads",
            116: "NC_007373.1 - No. of uniquely aligned reads",
            117: "NC_007373.1 - No. of split aligned reads",
            118: "NC_007373.1 - No. of multiple aligned reads",
            119: "NC_007373.1 - No. of alignments",
            120: "NC_007372.1 - No. of aligned reads",
            121: "NC_007372.1 - No. of uniquely aligned reads",
            122: "NC_007372.1 - No. of split aligned reads",
            123: "NC_007372.1 - No. of multiple aligned reads",
            124: "NC_007372.1 - No. of alignments",
        },
        "library_one": {
            0: 15.0,
            1: 0.0,
            2: 0.0,
            3: 15.0,
            4: 1.0,
            5: 14.0,
            6: 13.0,
            7: 1.0,
            8: 6.0,
            9: 3.0,
            10: 1.0,
            11: 3.0,
            12: 19.0,
            13: 86.67,
            14: 92.86,
            15: 46.15,
            16: 23.08,
            17: 7.69,
            18: 23.08,
            19: 9.0,
            20: 3.0,
            21: 3.0,
            22: 1.0,
            23: 2.0,
            24: 11.0,
            25: 60.0,
            26: 64.29,
            27: 33.33,
            28: 33.33,
            29: 11.11,
            30: 22.22,
            31: 5.0,
            32: 2.0,
            33: 0.0,
            34: 0.0,
            35: 3.0,
            36: 5.0,
            37: 33.33,
            38: 35.71,
            39: 40.0,
            40: 0.0,
            41: 0.0,
            42: 60.0,
            43: 3.0,
            44: 1.0,
            45: 0.0,
            46: 0.0,
            47: 2.0,
            48: 3.0,
            49: 20.0,
            50: 21.43,
            51: 33.33,
            52: 0.0,
            53: 0.0,
            54: 66.67,
            55: 0.0,
            56: 0.0,
            57: 0.0,
            58: 0.0,
            59: 0.0,
            60: 3.0,
            61: 2.0,
            62: 0.0,
            63: 0.0,
            64: 3.0,
            65: 2.0,
            66: 1.0,
            67: 0.0,
            68: 1.0,
            69: 3.0,
            70: 1.0,
            71: 0.0,
            72: 0.0,
            73: 1.0,
            74: 1.0,
            75: 2.0,
            76: 0.0,
            77: 2.0,
            78: 0.0,
            79: 2.0,
            80: 1.0,
            81: 0.0,
            82: 0.0,
            83: 0.0,
            84: 1.0,
            85: 0.0,
            86: 0.0,
            87: 0.0,
            88: 0.0,
            89: 0.0,
            90: 1.0,
            91: 0.0,
            92: 1.0,
            93: 0.0,
            94: 1.0,
            95: 0.0,
            96: 0.0,
            97: 0.0,
            98: 0.0,
            99: 0.0,
            100: 0.0,
            101: 0.0,
            102: 0.0,
            103: 0.0,
            104: 0.0,
            105: 0.0,
            106: 0.0,
            107: 0.0,
            108: 0.0,
            109: 0.0,
            110: 5.0,
            111: 2.0,
            112: 0.0,
            113: 0.0,
            114: 5.0,
            115: 2.0,
            116: 1.0,
            117: 0.0,
            118: 0.0,
            119: 2.0,
            120: 1.0,
            121: 0.0,
            122: 0.0,
            123: 0.0,
            124: 1.0,
        },
        "library_two": {
            0: 30.0,
            1: 0.0,
            2: 0.0,
            3: 30.0,
            4: 2.0,
            5: 28.0,
            6: 26.0,
            7: 2.0,
            8: 12.0,
            9: 6.0,
            10: 2.0,
            11: 6.0,
            12: 38.0,
            13: 86.67,
            14: 92.86,
            15: 46.15,
            16: 23.08,
            17: 7.69,
            18: 23.08,
            19: 18.0,
            20: 6.0,
            21: 6.0,
            22: 2.0,
            23: 4.0,
            24: 22.0,
            25: 60.0,
            26: 64.29,
            27: 33.33,
            28: 33.33,
            29: 11.11,
            30: 22.22,
            31: 10.0,
            32: 4.0,
            33: 0.0,
            34: 0.0,
            35: 6.0,
            36: 10.0,
            37: 33.33,
            38: 35.71,
            39: 40.0,
            40: 0.0,
            41: 0.0,
            42: 60.0,
            43: 6.0,
            44: 2.0,
            45: 0.0,
            46: 0.0,
            47: 4.0,
            48: 6.0,
            49: 20.0,
            50: 21.43,
            51: 33.33,
            52: 0.0,
            53: 0.0,
            54: 66.67,
            55: 0.0,
            56: 0.0,
            57: 0.0,
            58: 0.0,
            59: 0.0,
            60: 6.0,
            61: 4.0,
            62: 0.0,
            63: 0.0,
            64: 6.0,
            65: 4.0,
            66: 2.0,
            67: 0.0,
            68: 2.0,
            69: 6.0,
            70: 2.0,
            71: 0.0,
            72: 0.0,
            73: 2.0,
            74: 2.0,
            75: 4.0,
            76: 0.0,
            77: 4.0,
            78: 0.0,
            79: 4.0,
            80: 2.0,
            81: 0.0,
            82: 0.0,
            83: 0.0,
            84: 2.0,
            85: 0.0,
            86: 0.0,
            87: 0.0,
            88: 0.0,
            89: 0.0,
            90: 2.0,
            91: 0.0,
            92: 2.0,
            93: 0.0,
            94: 2.0,
            95: 0.0,
            96: 0.0,
            97: 0.0,
            98: 0.0,
            99: 0.0,
            100: 0.0,
            101: 0.0,
            102: 0.0,
            103: 0.0,
            104: 0.0,
            105: 0.0,
            106: 0.0,
            107: 0.0,
            108: 0.0,
            109: 0.0,
            110: 10.0,
            111: 4.0,
            112: 0.0,
            113: 0.0,
            114: 10.0,
            115: 4.0,
            116: 2.0,
            117: 0.0,
            118: 0.0,
            119: 4.0,
            120: 2.0,
            121: 0.0,
            122: 0.0,
            123: 0.0,
            124: 2.0,
        },
    }
    read_alignment_stats = pd.DataFrame(read_alignment_stats_content)
    lib_names = ["library_one", "library_two"]
    read_processing_stats_path = "reademption_analysis_dual/output/align/reports_and_stats/stats_data_json/read_processing.json"
    read_aligner_stats_path = "reademption_analysis_dual/output/align/reports_and_stats/stats_data_json/read_alignments_final.json"
    read_alignment_stats_table_path = "reademption_analysis_dual/output/align/reports_and_stats/read_alignment_stats.csv"
    viz_align_aligned_reads_by_species_paths = {
        "human": "reademption_analysis_dual/output/human_viz_align/human_aligned_reads",
        "staphylococcus": "reademption_analysis_dual/output/staphylococcus_viz_align/staphylococcus_aligned_reads",
        "influenza": "reademption_analysis_dual/output/influenza_viz_align/influenza_aligned_reads",
    }
    species_folder_prefixes_and_display_names = {
        "human": "homo sapiens",
        "staphylococcus": "Staphylococcus aureus",
        "influenza": "Influenza A",
    }

    align_viz = AlignViz(
        lib_names,
        read_processing_stats_path,
        read_aligner_stats_path,
        read_alignment_stats_table_path,
        viz_align_aligned_reads_by_species_paths,
        species_folder_prefixes_and_display_names,
    )

    def test_get_all_stats_selection(self):
        expected_all_stats_selection = pd.DataFrame(
            data=[[1.0, 2.0], [3.0, 6.0]],
            index=pd.Series(
                [
                    "Total no. of unaligned reads",
                    "Total no. of cross aligned reads",
                ],
                name="Statistic",
            ),
            columns=["library_one", "library_two"],
        )
        calculated_all_stats_selection = (
            self.align_viz._get_all_stats_selection(self.read_alignment_stats)
        )
        pd.testing.assert_frame_equal(
            expected_all_stats_selection, calculated_all_stats_selection
        )

    def test_get_species_exclusive_reads_combined(self):
        expected_total_no_of_species_exclusive_reads = pd.DataFrame(
            data=[[7.0, 14.0], [2.0, 4.0], [1.0, 2.0]],
            index=pd.Series(
                [
                    "homo sapiens - Total no. of species exclusively aligned reads",
                    "Staphylococcus aureus - Total no. of species exclusively aligned reads",
                    "Influenza A - Total no. of species exclusively aligned reads",
                ],
                name="Statistic",
            ),
            columns=["library_one", "library_two"],
        )
        calculated_total_no_of_species_exclusive_reads = (
            self.align_viz._get_species_exclusive_reads_combined(
                self.read_alignment_stats
            )
        )
        pd.testing.assert_frame_equal(
            expected_total_no_of_species_exclusive_reads,
            calculated_total_no_of_species_exclusive_reads,
        )
