from typing import no_type_check


@no_type_check
def _shader_db(var_type, DB):
    """Build a database of material parameters to their types."""
    [FLAG, MATERIAL, STR, TEXTURE, INT, FLOAT, BOOL, COLOR, VEC2, VEC3, VEC4, MATRIX, MATRIX_4X2, FOUR_CC] = var_type
    DB['%compile2dsky'] = FLAG
    DB['%compileblocklos'] = FLAG
    DB['%compileclip'] = FLAG
    DB['%compiledetail'] = FLAG
    DB['%compilefog'] = FLAG
    DB['%compilegrenadeclip'] = FLAG
    DB['%compilehint'] = FLAG
    DB['%compileladder'] = FLAG
    DB['%compilenochop'] = FLAG
    DB['%compilenodraw'] = FLAG
    DB['%compilenolight'] = FLAG
    DB['%compilenonsolid'] = FLAG
    DB['%compilenpcclip'] = FLAG
    DB['%compileorigin'] = FLAG
    DB['%compilepassbullets'] = FLAG
    DB['%compileskip'] = FLAG
    DB['%compilesky'] = FLAG
    DB['%compileslime'] = FLAG
    DB['%compileteam'] = FLAG
    DB['%compiletrigger'] = FLAG
    DB['%compilewater'] = FLAG
    DB['%nopaint'] = FLAG
    DB['%noportal'] = FLAG
    DB['%notooltexture'] = FLAG
    DB['%playerclip'] = FLAG

    DB['additive'] = FLAG
    DB['allowalphatocoverage'] = FLAG
    DB['alphamodifiedbyproxy_do_not_set_in_vmt'] = FLAG
    DB['alphatest'] = FLAG
    DB['basealphaenvmapmask'] = FLAG
    DB['debug'] = FLAG
    DB['decal'] = FLAG
    DB['envmapcameraspace'] = FLAG
    DB['envmapmode'] = FLAG
    DB['envmapsphere'] = FLAG
    DB['flat'] = FLAG
    DB['halflambert'] = FLAG
    DB['ignorez'] = FLAG
    DB['model'] = FLAG
    DB['multipass'] = FLAG
    DB['multiply'] = FLAG
    DB['no_draw'] = FLAG
    DB['no_fullbright'] = FLAG
    DB['noalphamod'] = FLAG
    DB['nocull'] = FLAG
    DB['nodecal'] = FLAG
    DB['nofog'] = FLAG
    DB['normalmapalphaenvmapmask'] = FLAG
    DB['notint'] = FLAG
    DB['opaquetexture'] = FLAG
    DB['pseudotranslucent'] = FLAG
    DB['selfillum'] = FLAG
    DB['softwareskin'] = FLAG
    DB['translucent'] = FLAG
    DB['use_in_fillrate_mode'] = FLAG
    DB['vertexalpha'] = FLAG
    DB['vertexfog'] = FLAG
    DB['wireframe'] = FLAG
    DB['xxxxxxunusedxxxxx'] = FLAG
    DB['znearer'] = FLAG

    DB['bottommaterial'] = MATERIAL
    DB['crackmaterial'] = MATERIAL
    DB['translucent_material'] = MATERIAL

    DB['%detailtype'] = STR
    DB['%keywords'] = STR
    DB['fallback'] = STR
    DB['pixshader'] = STR
    DB['surfaceprop'] = STR
    DB['surfaceprop2'] = STR
    DB['vertexshader'] = STR

    DB['%tooltexture'] = TEXTURE
    DB['albedo'] = TEXTURE
    DB['alphamasktexture'] = TEXTURE
    DB['ambientoccltexture'] = TEXTURE
    DB['anisodirtexture'] = TEXTURE
    DB['ao'] = TEXTURE
    DB['aomap'] = TEXTURE
    DB['aoscreenbuffer'] = TEXTURE
    DB['aotexture'] = TEXTURE
    DB['backingtexture'] = TEXTURE
    DB['basetexture'] = TEXTURE
    DB['basetexture2'] = TEXTURE
    DB['basetexture3'] = TEXTURE
    DB['basetexture4'] = TEXTURE
    DB['blendmodulatetexture'] = TEXTURE
    DB['bloomtexture'] = TEXTURE
    DB['blurredtexture'] = TEXTURE
    DB['blurtexture'] = TEXTURE
    DB['bumpcompress'] = TEXTURE
    DB['bumpmap'] = TEXTURE
    DB['bumpmap2'] = TEXTURE
    DB['bumpmask'] = TEXTURE
    DB['bumpstretch'] = TEXTURE
    DB['canvas'] = TEXTURE
    DB['cbtexture'] = TEXTURE
    DB['cloudalphatexture'] = TEXTURE
    DB['colorbar'] = TEXTURE
    DB['colorwarptexture'] = TEXTURE
    DB['compress'] = TEXTURE
    DB['cookietexture'] = TEXTURE
    DB['corecolortexture'] = TEXTURE
    DB['corneatexture'] = TEXTURE
    DB['crtexture'] = TEXTURE
    DB['decaltexture'] = TEXTURE
    DB['delta'] = TEXTURE
    DB['depthtexture'] = TEXTURE
    DB['detail'] = TEXTURE
    DB['detail1'] = TEXTURE
    DB['detail2'] = TEXTURE
    DB['detailnormal'] = TEXTURE
    DB['displacementmap'] = TEXTURE
    DB['distortmap'] = TEXTURE
    DB['dudvmap'] = TEXTURE
    DB['dust_texture'] = TEXTURE
    DB['effectmaskstexture'] = TEXTURE
    DB['emissiveblendbasetexture'] = TEXTURE
    DB['emissiveblendflowtexture'] = TEXTURE
    DB['emissiveblendtexture'] = TEXTURE
    DB['envmap'] = TEXTURE
    DB['envmapmask'] = TEXTURE
    DB['envmapmask2'] = TEXTURE
    DB['exposure_texture'] = TEXTURE
    DB['exptexture'] = TEXTURE
    DB['fb_texture'] = TEXTURE
    DB['fbtexture'] = TEXTURE
    DB['fleshbordertexture1d'] = TEXTURE
    DB['fleshcubetexture'] = TEXTURE
    DB['fleshinteriornoisetexture'] = TEXTURE
    DB['fleshinteriortexture'] = TEXTURE
    DB['fleshnormaltexture'] = TEXTURE
    DB['fleshsubsurfacetexture'] = TEXTURE
    DB['flow_noise_texture'] = TEXTURE
    DB['flowbounds'] = TEXTURE
    DB['flowmap'] = TEXTURE
    DB['fow'] = TEXTURE
    DB['frame_texture'] = TEXTURE
    DB['frametexture'] = TEXTURE
    DB['fresnelcolorwarptexture'] = TEXTURE
    DB['fresnelrangestexture'] = TEXTURE
    DB['fresnelwarptexture'] = TEXTURE
    DB['frontndtexture'] = TEXTURE
    DB['glassenvmap'] = TEXTURE
    DB['glint'] = TEXTURE
    DB['gradienttexture'] = TEXTURE
    DB['grain'] = TEXTURE
    DB['grain_texture'] = TEXTURE
    DB['grime'] = TEXTURE
    DB['grunge'] = TEXTURE
    DB['grungetexture'] = TEXTURE
    DB['hdrbasetexture'] = TEXTURE
    DB['hdrcompressedtexture'] = TEXTURE
    DB['hdrcompressedtexture0'] = TEXTURE
    DB['hdrcompressedtexture1'] = TEXTURE
    DB['hdrcompressedtexture2'] = TEXTURE
    DB['holomask'] = TEXTURE
    DB['holospectrum'] = TEXTURE
    DB['input'] = TEXTURE
    DB['input_texture'] = TEXTURE
    DB['internal_vignettetexture'] = TEXTURE
    DB['iridescentwarp'] = TEXTURE
    DB['iris'] = TEXTURE
    DB['lightmap'] = TEXTURE
    DB['lightwarptexture'] = TEXTURE
    DB['logomap'] = TEXTURE
    DB['maskmap'] = TEXTURE
    DB['maps1'] = TEXTURE
    DB['maps2'] = TEXTURE
    DB['maps3'] = TEXTURE
    DB['masks1'] = TEXTURE
    DB['masks2'] = TEXTURE
    DB['maskstexture'] = TEXTURE
    DB['materialmask'] = TEXTURE
    DB['noise'] = TEXTURE
    DB['noisemap'] = TEXTURE
    DB['noisetexture'] = TEXTURE
    DB['normalmap'] = TEXTURE
    DB['normalmap2'] = TEXTURE
    DB['offsetmap'] = TEXTURE
    DB['opacitytexture'] = TEXTURE
    DB['originaltexture'] = TEXTURE
    DB['paintsplatenvmap'] = TEXTURE
    DB['paintsplatnormalmap'] = TEXTURE
    DB['painttexture'] = TEXTURE
    DB['pattern'] = TEXTURE
    DB['pattern1'] = TEXTURE
    DB['pattern2'] = TEXTURE
    DB['phongexponenttexture'] = TEXTURE
    DB['phongwarptexture'] = TEXTURE
    DB['portalcolortexture'] = TEXTURE
    DB['portalmasktexture'] = TEXTURE
    DB['postexture'] = TEXTURE
    DB['ramptexture'] = TEXTURE
    DB['reflecttexture'] = TEXTURE
    DB['refracttexture'] = TEXTURE
    DB['refracttinttexture'] = TEXTURE
    DB['sampleoffsettexture'] = TEXTURE
    DB['scenedepth'] = TEXTURE
    DB['screeneffecttexture'] = TEXTURE
    DB['selfillummap'] = TEXTURE
    DB['selfillummask'] = TEXTURE
    DB['selfillumtexture'] = TEXTURE
    DB['shadowdepthtexture'] = TEXTURE
    DB['sheenmap'] = TEXTURE
    DB['sheenmapmask'] = TEXTURE
    DB['sidespeed'] = TEXTURE
    DB['simpleoverlay'] = TEXTURE
    DB['smallfb'] = TEXTURE
    DB['sourcemrtrendertarget'] = TEXTURE
    DB['specmasktexture'] = TEXTURE
    DB['spectexture'] = TEXTURE
    DB['spectexture2'] = TEXTURE
    DB['spectexture3'] = TEXTURE
    DB['spectexture4'] = TEXTURE
    DB['spherenormal'] = TEXTURE
    DB['srctexture0'] = TEXTURE
    DB['srctexture1'] = TEXTURE
    DB['srctexture2'] = TEXTURE
    DB['srctexture3'] = TEXTURE
    DB['staticblendtexture'] = TEXTURE
    DB['stitchtexture'] = TEXTURE
    DB['stretch'] = TEXTURE
    DB['stripetexture'] = TEXTURE
    DB['surfacetexture'] = TEXTURE
    DB['test_texture'] = TEXTURE
    DB['texture0'] = TEXTURE
    DB['texture1'] = TEXTURE
    DB['texture2'] = TEXTURE
    DB['texture3'] = TEXTURE
    DB['texture4'] = TEXTURE
    DB['tintmasktexture'] = TEXTURE
    DB['transmatmaskstexture'] = TEXTURE
    DB['underwateroverlay'] = TEXTURE
    DB['velocity_texture'] = TEXTURE
    DB['vignette_texture'] = TEXTURE
    DB['vignette_tile'] = TEXTURE
    DB['warptexture'] = TEXTURE
    DB['weartexture'] = TEXTURE
    DB['ytexture'] = TEXTURE

    DB['addoverblend'] = INT
    DB['alpha_blend'] = INT
    DB['alpha_blend_color_overlay'] = INT
    DB['alphablend'] = INT
    DB['alphadepth'] = INT
    DB['alphamask'] = INT
    DB['alphamasktextureframe'] = INT
    DB['ambientboostmaskmode'] = INT
    DB['ambientonly'] = INT
    DB['aomode'] = INT
    DB['basediffuseoverride'] = INT
    DB['basemapalphaphongmask'] = INT
    DB['basemapluminancephongmask'] = INT
    DB['bloomtintenable'] = INT
    DB['bloomtype'] = INT
    DB['bumpframe'] = INT
    DB['bumpframe2'] = INT
    DB['clearalpha'] = INT
    DB['cleardepth'] = INT
    DB['combine_mode'] = INT
    DB['compositemode'] = INT
    DB['cookieframenum'] = INT
    DB['copyalpha'] = INT
    DB['corecolortextureframe'] = INT
    DB['cstrike'] = INT
    DB['cull'] = INT
    DB['decalblendmode'] = INT
    DB['decalstyle'] = INT
    DB['depth_feather'] = INT
    DB['depthtest'] = INT
    DB['desaturateenable'] = INT
    DB['detail1blendmode'] = INT
    DB['detail1frame'] = INT
    DB['detail2blendmode'] = INT
    DB['detail2frame'] = INT
    DB['detailblendmode'] = INT
    DB['detailframe'] = INT
    DB['detailframe2'] = INT
    DB['disable_color_writes'] = INT
    DB['dualsequence'] = INT
    DB['dudvframe'] = INT
    DB['effect'] = INT
    DB['enableshadows'] = INT
    DB['envmapframe'] = INT
    DB['envmapmaskframe'] = INT
    DB['envmapmaskframe2'] = INT
    DB['envmapoptional'] = INT
    DB['exponentmode'] = INT
    DB['extractgreenalpha'] = INT
    DB['fade'] = INT
    DB['flowmapframe'] = INT
    DB['frame'] = INT
    DB['frame2'] = INT
    DB['frame3'] = INT
    DB['frame4'] = INT
    DB['fullbright'] = INT
    DB['gammacolorread'] = INT
    DB['ghostoverlay'] = INT
    DB['hudtranslucent'] = INT
    DB['hudundistort'] = INT
    DB['invertphongmask'] = INT
    DB['irisframe'] = INT
    DB['isfloat'] = INT
    DB['kernel'] = INT
    DB['linearread_basetexture'] = INT
    DB['linearread_texture1'] = INT
    DB['linearread_texture2'] = INT
    DB['linearread_texture3'] = INT
    DB['linearwrite'] = INT
    DB['maskedblending'] = INT
    DB['maxlumframeblend1'] = INT
    DB['maxlumframeblend2'] = INT
    DB['mirroraboutviewportedges'] = INT
    DB['mode'] = INT
    DB['mrtindex'] = INT
    DB['multiplycolor'] = INT
    DB['ncolors'] = INT
    DB['nocolorwrite'] = INT
    DB['nodiffusebumplighting'] = INT
    DB['notint'] = INT
    DB['noviewportfixup'] = INT
    DB['nowritez'] = INT
    DB['num_lookups'] = INT
    DB['orientation'] = INT
    DB['paintstyle'] = INT
    DB['parallaxmap'] = INT
    DB['passcount'] = INT
    DB['patternreplaceindex'] = INT
    DB['phongintensity'] = INT
    DB['pointsample_basetexture'] = INT
    DB['pointsample_texture1'] = INT
    DB['pointsample_texture2'] = INT
    DB['pointsample_texture3'] = INT
    DB['quality'] = INT
    DB['receiveflashlight'] = INT
    DB['refracttinttextureframe'] = INT
    DB['reloadzcull'] = INT
    DB['renderfixz'] = INT
    DB['selector0'] = INT
    DB['selector1'] = INT
    DB['selector2'] = INT
    DB['selector3'] = INT
    DB['selector4'] = INT
    DB['selector5'] = INT
    DB['selector6'] = INT
    DB['selector7'] = INT
    DB['selector8'] = INT
    DB['selector9'] = INT
    DB['selector10'] = INT
    DB['selector11'] = INT
    DB['selector12'] = INT
    DB['selector13'] = INT
    DB['selector14'] = INT
    DB['selector15'] = INT
    DB['selfillumtextureframe'] = INT
    DB['sequence_blend_mode'] = INT
    DB['shadowdepth'] = INT
    DB['sheenindex'] = INT
    DB['sheenmapmaskdirection'] = INT
    DB['sheenmapmaskframe'] = INT
    DB['singlepassflashlight'] = INT
    DB['splinetype'] = INT
    DB['spriteorientation'] = INT
    DB['spriterendermode'] = INT
    DB['ssbump'] = INT
    DB['stage'] = INT
    DB['staticblendtextureframe'] = INT
    DB['tcsize0'] = INT
    DB['tcsize1'] = INT
    DB['tcsize2'] = INT
    DB['tcsize3'] = INT
    DB['tcsize4'] = INT
    DB['tcsize5'] = INT
    DB['tcsize6'] = INT
    DB['tcsize7'] = INT
    DB['texture3_blendmode'] = INT
    DB['texture4_blendmode'] = INT
    DB['textureinputcount'] = INT
    DB['texturemode'] = INT
    DB['treesway'] = INT
    DB['tv_gamma'] = INT
    DB['uberlight'] = INT
    DB['usealternateviewmatrix'] = INT
    DB['userendertarget'] = INT
    DB['vertex_lit'] = INT
    DB['vertexalphatest'] = INT
    DB['vertexcolor'] = INT
    DB['vertextransform'] = INT
    DB['writealpha'] = INT
    DB['writedepth'] = INT
    DB['x360appchooser'] = INT

    DB['addbasetexture2'] = FLOAT
    DB['addself'] = FLOAT
    DB['alpha'] = FLOAT
    DB['alpha2'] = FLOAT
    DB['alphasharpenfactor'] = FLOAT
    DB['alphatested'] = FLOAT
    DB['alphatestreference'] = FLOAT
    DB['alphatrailfade'] = FLOAT
    DB['ambientboost'] = FLOAT
    DB['ambientocclusion'] = FLOAT
    DB['ambientreflectionboost'] = FLOAT
    DB['anisotropyamount'] = FLOAT
    DB['armwidthbias'] = FLOAT
    DB['armwidthexp'] = FLOAT
    DB['armwidthscale'] = FLOAT
    DB['autoexpose_max'] = FLOAT
    DB['autoexpose_min'] = FLOAT
    DB['backscatter'] = FLOAT
    DB['bias'] = FLOAT
    DB['blendsoftness'] = FLOAT
    DB['blendtintcoloroverbase'] = FLOAT
    DB['bloomexp'] = FLOAT
    DB['bloomexponent'] = FLOAT
    DB['bloomsaturation'] = FLOAT
    DB['bloomwidth'] = FLOAT
    DB['bluramount'] = FLOAT
    DB['blurredvignettescale'] = FLOAT
    DB['bumpdetailscale1'] = FLOAT
    DB['bumpdetailscale2'] = FLOAT
    DB['bumpstrength'] = FLOAT
    DB['c0_w'] = FLOAT
    DB['c0_x'] = FLOAT
    DB['c0_y'] = FLOAT
    DB['c0_z'] = FLOAT
    DB['c1_w'] = FLOAT
    DB['c1_x'] = FLOAT
    DB['c1_y'] = FLOAT
    DB['c1_z'] = FLOAT
    DB['c2_w'] = FLOAT
    DB['c2_x'] = FLOAT
    DB['c2_y'] = FLOAT
    DB['c2_z'] = FLOAT
    DB['c3_w'] = FLOAT
    DB['c3_x'] = FLOAT
    DB['c3_y'] = FLOAT
    DB['c3_z'] = FLOAT
    DB['c4_w'] = FLOAT
    DB['c4_x'] = FLOAT
    DB['c4_y'] = FLOAT
    DB['c4_z'] = FLOAT
    DB['cavitycontrast'] = FLOAT
    DB['cheapwaterenddistance'] = FLOAT
    DB['cheapwaterstartdistance'] = FLOAT
    DB['cloakfactor'] = FLOAT
    DB['color_flow_displacebynormalstrength'] = FLOAT
    DB['color_flow_lerpexp'] = FLOAT
    DB['color_flow_timeintervalinseconds'] = FLOAT
    DB['color_flow_timescale'] = FLOAT
    DB['color_flow_uvscale'] = FLOAT
    DB['color_flow_uvscrolldistance'] = FLOAT
    DB['colorgamma'] = FLOAT
    DB['contrast'] = FLOAT
    DB['contrast_correction'] = FLOAT
    DB['corneabumpstrength'] = FLOAT
    DB['crosshaircoloradapt'] = FLOAT
    DB['decalfadeduration'] = FLOAT
    DB['decalfadetime'] = FLOAT
    DB['decalscale'] = FLOAT
    DB['deltascale'] = FLOAT
    DB['depthblendscale'] = FLOAT
    DB['depthblurfocaldistance'] = FLOAT
    DB['depthblurstrength'] = FLOAT
    DB['desatbasetint'] = FLOAT
    DB['desaturatewithbasealpha'] = FLOAT
    DB['desaturation'] = FLOAT
    DB['detail1blendfactor'] = FLOAT
    DB['detail1scale'] = FLOAT
    DB['detail2blendfactor'] = FLOAT
    DB['detail2scale'] = FLOAT
    DB['detailblendfactor'] = FLOAT
    DB['detailblendfactor2'] = FLOAT
    DB['detailblendfactor3'] = FLOAT
    DB['detailblendfactor4'] = FLOAT
    DB['detailscale'] = FLOAT
    DB['detailscale2'] = FLOAT
    DB['diffuse_base'] = FLOAT
    DB['diffuse_white'] = FLOAT
    DB['diffuseboost'] = FLOAT
    DB['diffuseexponent'] = FLOAT
    DB['diffusescale'] = FLOAT
    DB['diffusesoftnormal'] = FLOAT
    DB['dilation'] = FLOAT
    DB['dof_max'] = FLOAT
    DB['dof_power'] = FLOAT
    DB['dof_start_distance'] = FLOAT
    DB['dropshadowdepthexaggeration'] = FLOAT
    DB['dropshadowhighlightscale'] = FLOAT
    DB['dropshadowopacity'] = FLOAT
    DB['dropshadowscale'] = FLOAT
    DB['edge_softness'] = FLOAT
    DB['edgesoftnessend'] = FLOAT
    DB['edgesoftnessstart'] = FLOAT
    DB['emissiveblendstrength'] = FLOAT
    DB['endfadesize'] = FLOAT
    DB['envmapanisotropyscale'] = FLOAT
    DB['envmapcontrast'] = FLOAT
    DB['envmapfresnel'] = FLOAT
    DB['envmaplightscale'] = FLOAT
    DB['envmapmaskscale'] = FLOAT
    DB['envmapsaturation'] = FLOAT
    DB['eyeballradius'] = FLOAT
    DB['fadetoblackscale'] = FLOAT
    DB['fakerimboost'] = FLOAT
    DB['falloffamount'] = FLOAT
    DB['falloffdistance'] = FLOAT
    DB['falloffoffset'] = FLOAT
    DB['farblurdepth'] = FLOAT
    DB['farblurradius'] = FLOAT
    DB['farfadeinterval'] = FLOAT
    DB['farfocusdepth'] = FLOAT
    DB['farplane'] = FLOAT
    DB['farz'] = FLOAT
    DB['flashlighttime'] = FLOAT
    DB['flashlighttint'] = FLOAT
    DB['fleshbordernoisescale'] = FLOAT
    DB['fleshbordersoftness'] = FLOAT
    DB['fleshborderwidth'] = FLOAT
    DB['fleshglobalopacity'] = FLOAT
    DB['fleshglossbrightness'] = FLOAT
    DB['fleshscrollspeed'] = FLOAT
    DB['flipfixup'] = FLOAT
    DB['flow_bumpstrength'] = FLOAT
    DB['flow_color_intensity'] = FLOAT
    DB['flow_lerpexp'] = FLOAT
    DB['flow_noise_scale'] = FLOAT
    DB['flow_normaluvscale'] = FLOAT
    DB['flow_timeintervalinseconds'] = FLOAT
    DB['flow_timescale'] = FLOAT
    DB['flow_uvscrolldistance'] = FLOAT
    DB['flow_vortex_size'] = FLOAT
    DB['flow_worlduvscale'] = FLOAT
    DB['flowmaptexcoordoffset'] = FLOAT
    DB['fogend'] = FLOAT
    DB['fogexponent'] = FLOAT
    DB['fogfadeend'] = FLOAT
    DB['fogfadestart'] = FLOAT
    DB['fogscale'] = FLOAT
    DB['fogstart'] = FLOAT
    DB['forcefresnel'] = FLOAT
    DB['forwardscatter'] = FLOAT
    DB['fresnelbumpstrength'] = FLOAT
    DB['fresnelpower'] = FLOAT
    DB['fresnelreflection'] = FLOAT
    DB['glossiness'] = FLOAT
    DB['glowalpha'] = FLOAT
    DB['glowend'] = FLOAT
    DB['glowscale'] = FLOAT
    DB['glowstart'] = FLOAT
    DB['glowx'] = FLOAT
    DB['glowy'] = FLOAT
    DB['gray_power'] = FLOAT
    DB['groundmax'] = FLOAT
    DB['groundmin'] = FLOAT
    DB['grungescale'] = FLOAT
    DB['hdrcolorscale'] = FLOAT
    DB['heat_haze_scale'] = FLOAT
    DB['height_scale'] = FLOAT
    DB['highlight'] = FLOAT
    DB['highlightcycle'] = FLOAT
    DB['hueshiftfresnelexponent'] = FLOAT
    DB['hueshiftintensity'] = FLOAT
    DB['illumfactor'] = FLOAT
    DB['intensity'] = FLOAT
    DB['interiorambientscale'] = FLOAT
    DB['interiorbackgroundboost'] = FLOAT
    DB['interiorbacklightscale'] = FLOAT
    DB['interiorfoglimit'] = FLOAT
    DB['interiorfognormalboost'] = FLOAT
    DB['interiorfogstrength'] = FLOAT
    DB['interiorrefractblur'] = FLOAT
    DB['interiorrefractstrength'] = FLOAT
    DB['iridescenceboost'] = FLOAT
    DB['iridescenceexponent'] = FLOAT
    DB['layerborderoffset'] = FLOAT
    DB['layerbordersoftness'] = FLOAT
    DB['layerborderstrength'] = FLOAT
    DB['layeredgeoffset'] = FLOAT
    DB['layeredgesoftness'] = FLOAT
    DB['layeredgestrength'] = FLOAT
    DB['lightmap_gradients'] = FLOAT
    DB['lightmaptint'] = FLOAT
    DB['localcontrastedgescale'] = FLOAT
    DB['localcontrastmidtonemask'] = FLOAT
    DB['localcontrastscale'] = FLOAT
    DB['localcontrastvignetteend'] = FLOAT
    DB['localrefractdepth'] = FLOAT
    DB['logo2rotate'] = FLOAT
    DB['logo2scale'] = FLOAT
    DB['logo2x'] = FLOAT
    DB['logo2y'] = FLOAT
    DB['logomaskcrisp'] = FLOAT
    DB['logorotate'] = FLOAT
    DB['logoscale'] = FLOAT
    DB['logowear'] = FLOAT
    DB['logox'] = FLOAT
    DB['logoy'] = FLOAT
    DB['lumblendfactor2'] = FLOAT
    DB['lumblendfactor3'] = FLOAT
    DB['lumblendfactor4'] = FLOAT
    DB['magnifyscale'] = FLOAT
    DB['mappingheight'] = FLOAT
    DB['mappingwidth'] = FLOAT
    DB['maps1alpha'] = FLOAT
    DB['maxdistance'] = FLOAT
    DB['maxfalloffamount'] = FLOAT
    DB['maxlight'] = FLOAT
    DB['maxreflectivity'] = FLOAT
    DB['maxsize'] = FLOAT
    DB['metalness'] = FLOAT
    DB['minlight'] = FLOAT
    DB['minreflectivity'] = FLOAT
    DB['minsize'] = FLOAT
    DB['nearblurdepth'] = FLOAT
    DB['nearblurradius'] = FLOAT
    DB['nearfocusdepth'] = FLOAT
    DB['nearplane'] = FLOAT
    DB['noise_scale'] = FLOAT
    DB['noisestrength'] = FLOAT
    DB['normal2softness'] = FLOAT
    DB['numplanes'] = FLOAT
    DB['offsetamount'] = FLOAT
    DB['outlinealpha'] = FLOAT
    DB['outlineend0'] = FLOAT
    DB['outlineend1'] = FLOAT
    DB['outlinestart0'] = FLOAT
    DB['outlinestart1'] = FLOAT
    DB['outputintensity'] = FLOAT
    DB['overbrightfactor'] = FLOAT
    DB['paintphongalbedoboost'] = FLOAT
    DB['parallaxstrength'] = FLOAT
    DB['pattern1scale'] = FLOAT
    DB['pattern2scale'] = FLOAT
    DB['patterndetailinfluence'] = FLOAT
    DB['patternpaintthickness'] = FLOAT
    DB['patternphongfactor'] = FLOAT
    DB['patternrotation'] = FLOAT
    DB['patternscale'] = FLOAT
    DB['peel'] = FLOAT
    DB['phong2softness'] = FLOAT
    DB['phongalbedoboost'] = FLOAT
    DB['phongalbedofactor'] = FLOAT
    DB['phongbasetint'] = FLOAT
    DB['phongbasetint2'] = FLOAT
    DB['phongboost'] = FLOAT
    DB['phongboost2'] = FLOAT
    DB['phongexponent'] = FLOAT
    DB['phongexponent2'] = FLOAT
    DB['phongexponentfactor'] = FLOAT
    DB['phongscale'] = FLOAT
    DB['phongscale2'] = FLOAT
    DB['portalcolorscale'] = FLOAT
    DB['portalopenamount'] = FLOAT
    DB['portalstatic'] = FLOAT
    DB['powerup'] = FLOAT
    DB['previewweaponobjscale'] = FLOAT
    DB['previewweaponuvscale'] = FLOAT
    DB['pulserate'] = FLOAT
    DB['radius'] = FLOAT
    DB['radiustrailfade'] = FLOAT
    DB['reflectamount'] = FLOAT
    DB['reflectance'] = FLOAT
    DB['reflectblendfactor'] = FLOAT
    DB['refractamount'] = FLOAT
    DB['rimhaloboost'] = FLOAT
    DB['rimlightalbedo'] = FLOAT
    DB['rimlightboost'] = FLOAT
    DB['rimlightexponent'] = FLOAT
    DB['rimlightscale'] = FLOAT
    DB['rotation'] = FLOAT
    DB['rotation2'] = FLOAT
    DB['rotation3'] = FLOAT
    DB['rotation4'] = FLOAT
    DB['saturation'] = FLOAT
    DB['scale'] = FLOAT
    DB['scale2'] = FLOAT
    DB['scale3'] = FLOAT
    DB['scale4'] = FLOAT
    DB['screenblurstrength'] = FLOAT
    DB['seamless_scale'] = FLOAT
    DB['selfillum_envmapmask_alpha'] = FLOAT
    DB['selfillumboost'] = FLOAT
    DB['selfillummaskscale'] = FLOAT
    DB['shadowatten'] = FLOAT
    DB['shadowcontrast'] = FLOAT
    DB['shadowfiltersize'] = FLOAT
    DB['shadowjitterseed'] = FLOAT
    DB['shadowrimboost'] = FLOAT
    DB['shadowsaturation'] = FLOAT
    DB['sharpness'] = FLOAT
    DB['sheenmapmaskoffsetx'] = FLOAT
    DB['sheenmapmaskoffsety'] = FLOAT
    DB['sheenmapmaskscalex'] = FLOAT
    DB['sheenmapmaskscaley'] = FLOAT
    DB['silhouettethickness'] = FLOAT
    DB['ssbentnormalintensity'] = FLOAT
    DB['ssdepth'] = FLOAT
    DB['sstintbyalbedo'] = FLOAT
    DB['startfadesize'] = FLOAT
    DB['staticamount'] = FLOAT
    DB['strength'] = FLOAT
    DB['stripe_lm_scale'] = FLOAT
    DB['texture1_lumend'] = FLOAT
    DB['texture1_lumstart'] = FLOAT
    DB['texture2_blendend'] = FLOAT
    DB['texture2_blendstart'] = FLOAT
    DB['texture2_bumpblendfactor'] = FLOAT
    DB['texture2_lumend'] = FLOAT
    DB['texture2_lumstart'] = FLOAT
    DB['texture2_uvscale'] = FLOAT
    DB['texture3_blendend'] = FLOAT
    DB['texture3_blendstart'] = FLOAT
    DB['texture3_bumpblendfactor'] = FLOAT
    DB['texture3_lumend'] = FLOAT
    DB['texture3_lumstart'] = FLOAT
    DB['texture3_uvscale'] = FLOAT
    DB['texture4_blendend'] = FLOAT
    DB['texture4_blendstart'] = FLOAT
    DB['texture4_bumpblendfactor'] = FLOAT
    DB['texture4_lumend'] = FLOAT
    DB['texture4_lumstart'] = FLOAT
    DB['texture4_uvscale'] = FLOAT
    DB['tiling'] = FLOAT
    DB['time'] = FLOAT
    DB['time_scale'] = FLOAT
    DB['toolcolorcorrection'] = FLOAT
    DB['tooltime'] = FLOAT
    DB['treeswayfalloffexp'] = FLOAT
    DB['treeswayheight'] = FLOAT
    DB['treeswayradius'] = FLOAT
    DB['treeswayscrumblefalloffexp'] = FLOAT
    DB['treeswayscrumblefrequency'] = FLOAT
    DB['treeswayscrumblespeed'] = FLOAT
    DB['treeswayscrumblestrength'] = FLOAT
    DB['treeswayspeed'] = FLOAT
    DB['treeswayspeedhighwindmultiplier'] = FLOAT
    DB['treeswayspeedlerpend'] = FLOAT
    DB['treeswayspeedlerpstart'] = FLOAT
    DB['treeswaystartheight'] = FLOAT
    DB['treeswaystartradius'] = FLOAT
    DB['treeswaystrength'] = FLOAT
    DB['uberroundness'] = FLOAT
    DB['unlitfactor'] = FLOAT
    DB['unwearstrength'] = FLOAT
    DB['uvscale'] = FLOAT
    DB['vertexfogamount'] = FLOAT
    DB['vignette_min_bright'] = FLOAT
    DB['vignette_power'] = FLOAT
    DB['volumetricintensity'] = FLOAT
    DB['vomitrefractscale'] = FLOAT
    DB['warpindex'] = FLOAT
    DB['warpparam'] = FLOAT
    DB['waterblendfactor'] = FLOAT
    DB['waterdepth'] = FLOAT
    DB['wave'] = FLOAT
    DB['wearbias'] = FLOAT
    DB['wearexponent'] = FLOAT
    DB['wearprogress'] = FLOAT
    DB['wearremapmax'] = FLOAT
    DB['wearremapmid'] = FLOAT
    DB['wearremapmin'] = FLOAT
    DB['wearwidthmax'] = FLOAT
    DB['wearwidthmin'] = FLOAT
    DB['weight0'] = FLOAT
    DB['weight1'] = FLOAT
    DB['weight2'] = FLOAT
    DB['weight3'] = FLOAT
    DB['weight_default'] = FLOAT
    DB['woodcut'] = FLOAT
    DB['zoomanimateseq2'] = FLOAT

    DB['aaenable'] = BOOL
    DB['abovewater'] = BOOL
    DB['addbumpmaps'] = BOOL
    DB['aimatcamera'] = BOOL
    DB['alloverpaintjob'] = BOOL
    DB['allowdiffusemodulation'] = BOOL
    DB['allowfencerenderstatehack'] = BOOL
    DB['allowlocalcontrast'] = BOOL
    DB['allownoise'] = BOOL
    DB['allowvignette'] = BOOL
    DB['alphaenvmapmask'] = BOOL
    DB['alphatesttocoverage'] = BOOL
    DB['aomaskusesuv2'] = BOOL
    DB['aousesuv2'] = BOOL
    DB['animatearmpulses'] = BOOL
    DB['aopass'] = BOOL
    DB['armature'] = BOOL
    DB['armwiden'] = BOOL
    DB['backsurface'] = BOOL
    DB['basealphaenvmask'] = BOOL
    DB['basemapalphaenvmapmask'] = BOOL
    DB['basealphaphongmask'] = BOOL
    DB['basealphaselfillummask'] = BOOL
    DB['basetexture2noenvmap'] = BOOL
    DB['basetexturenoenvmap'] = BOOL
    DB['blendframes'] = BOOL
    DB['blendtintbybasealpha'] = BOOL
    DB['blendwithsmokegrenade'] = BOOL
    DB['blobbyshadows'] = BOOL
    DB['bloomenable'] = BOOL
    DB['blurredvignetteenable'] = BOOL
    DB['blurrefract'] = BOOL
    DB['bump_force_on'] = BOOL
    DB['bumpalphaenvmask'] = BOOL
    DB['bumpbasetexture2withbumpmap'] = BOOL
    DB['cheapmode'] = BOOL
    DB['cloakpassenabled'] = BOOL
    DB['color_depth'] = BOOL
    DB['contactshadows'] = BOOL
    DB['crosshairmode'] = BOOL
    DB['custompaintjob'] = BOOL
    DB['debug_mode'] = BOOL
    DB['deferredshadows'] = BOOL
    DB['depthblend'] = BOOL
    DB['depthblurenable'] = BOOL
    DB['detail_alpha_mask_base_texture'] = BOOL
    DB['disablecsmlookup'] = BOOL
    DB['displacementwrinkle'] = BOOL
    DB['distancealpha'] = BOOL
    DB['distancealphafromdetail'] = BOOL
    DB['emissiveblendenabled'] = BOOL
    DB['enableclearcolor'] = BOOL
    DB['enablesrgb'] = BOOL
    DB['envmapanisotropy'] = BOOL
    DB['envmapmaskintintmasktexture'] = BOOL
    DB['fadeoutonsilhouette'] = BOOL
    DB['flashlightnolambert'] = BOOL
    DB['fleshdebugforcefleshon'] = BOOL
    DB['fleshinteriorenabled'] = BOOL
    DB['flow_cheap'] = BOOL
    DB['flow_debug'] = BOOL
    DB['fogenable'] = BOOL
    DB['flow_vortex1'] = BOOL
    DB['flow_vortex2'] = BOOL
    DB['forcealphawrite'] = BOOL
    DB['forcebump'] = BOOL
    DB['forcecheap'] = BOOL
    DB['forceenvmap'] = BOOL
    DB['forceexpensive'] = BOOL
    DB['forcephong'] = BOOL
    DB['forcerefract'] = BOOL
    DB['glow'] = BOOL
    DB['ignorevertexcolors'] = BOOL
    DB['interior'] = BOOL
    DB['intro'] = BOOL
    DB['inversedepthblend'] = BOOL
    DB['layeredgenormal'] = BOOL
    DB['layeredgepunchin'] = BOOL
    DB['lightmapwaterfog'] = BOOL
    DB['localcontrastenable'] = BOOL
    DB['localcontrastvignettestart'] = BOOL
    DB['localrefract'] = BOOL
    DB['logo2enabled'] = BOOL
    DB['lowqualityflashlightshadows'] = BOOL
    DB['magnifyenable'] = BOOL
    DB['masked'] = BOOL
    DB['mirrorhorizontal'] = BOOL
    DB['mod2x'] = BOOL
    DB['modeldecalignorez'] = BOOL
    DB['modelformat'] = BOOL
    DB['muloutputbyalpha'] = BOOL
    DB['needsnormals'] = BOOL
    DB['needstangents'] = BOOL
    DB['needstangentt'] = BOOL
    DB['newlayerblending'] = BOOL
    DB['nodiffusebumplighting'] = BOOL
    DB['noenvmapmip'] = BOOL
    DB['nofresnel'] = BOOL
    DB['noiseenable'] = BOOL
    DB['nolowendlightmap'] = BOOL
    DB['noscale'] = BOOL
    DB['nosrgb'] = BOOL
    DB['opaque'] = BOOL
    DB['outline'] = BOOL
    DB['perparticleoutline'] = BOOL
    DB['phong'] = BOOL
    DB['phongalbedotint'] = BOOL
    DB['phongdisablehalflambert'] = BOOL
    DB['pseudotranslucent'] = BOOL
    DB['preview'] = BOOL
    DB['previewignoreweaponscale'] = BOOL
    DB['pulse'] = BOOL
    DB['raytracesphere'] = BOOL
    DB['reflect2dskybox'] = BOOL
    DB['reflectentities'] = BOOL
    DB['reflectonlymarkedentities'] = BOOL
    DB['reflectskyboxonly'] = BOOL
    DB['rimlight'] = BOOL
    DB['rimmask'] = BOOL
    DB['scaleedgesoftnessbasedonscreenres'] = BOOL
    DB['scaleoutlinesoftnessbasedonscreenres'] = BOOL
    DB['seamless_base'] = BOOL
    DB['seamless_detail'] = BOOL
    DB['selfillumfresnel'] = BOOL
    DB['selfillumfresnelenabledthisframe'] = BOOL
    DB['separatedetailuvs'] = BOOL
    DB['shadersrgbread360'] = BOOL
    DB['sheenpassenabled'] = BOOL
    DB['showalpha'] = BOOL
    DB['softedges'] = BOOL
    DB['spheretexkillcombo'] = BOOL
    DB['swappatternmasks'] = BOOL
    DB['thirdperson'] = BOOL
    DB['toolmode'] = BOOL
    DB['translucentgoo'] = BOOL
    DB['treeswaystatic'] = BOOL
    DB['unlit'] = BOOL
    DB['use_fb_texture'] = BOOL
    DB['useinstancing'] = BOOL
    DB['useonstaticprop'] = BOOL
    DB['usingpixelshader'] = BOOL
    DB['vertexcolorlerp'] = BOOL
    DB['vertexcolormodulate'] = BOOL
    DB['vignetteenable'] = BOOL
    DB['volumetexturetest'] = BOOL
    DB['vomitenable'] = BOOL
    DB['writez'] = BOOL
    DB['zfailenable'] = BOOL

    DB['ambientreflectionbouncecolor'] = COLOR
    DB['cloakcolortint'] = COLOR
    DB['color'] = COLOR
    DB['color2'] = COLOR
    DB['colortint'] = COLOR
    DB['crosshaircolortint'] = COLOR
    DB['detailtint'] = COLOR
    DB['detailtint2'] = COLOR
    DB['emissiveblendtint'] = COLOR
    DB['envmaptint'] = COLOR
    DB['fakerimtint'] = COLOR
    DB['fleshbordertint'] = COLOR
    DB['fleshsubsurfacetint'] = COLOR
    DB['flow_color'] = COLOR
    DB['flow_vortex_color'] = COLOR
    DB['fogcolor'] = COLOR
    DB['glassenvmaptint'] = COLOR
    DB['glowcolor'] = COLOR
    DB['layerbordertint'] = COLOR
    DB['layertint1'] = COLOR
    DB['layertint2'] = COLOR
    DB['outlinecolor'] = COLOR
    DB['palettecolor1'] = COLOR
    DB['palettecolor2'] = COLOR
    DB['palettecolor3'] = COLOR
    DB['palettecolor4'] = COLOR
    DB['palettecolor5'] = COLOR
    DB['palettecolor6'] = COLOR
    DB['palettecolor7'] = COLOR
    DB['palettecolor8'] = COLOR
    DB['phongtint'] = COLOR
    DB['portalcolorgradientdark'] = COLOR
    DB['portalcolorgradientlight'] = COLOR
    DB['portalcoopcolorplayeroneportalone'] = COLOR
    DB['portalcoopcolorplayeroneportaltwo'] = COLOR
    DB['portalcoopcolorplayertwoportalone'] = COLOR
    DB['portalcoopcolorplayertwoportaltwo'] = COLOR
    DB['phongcolortint'] = COLOR
    DB['reflectivity'] = COLOR
    DB['reflecttint'] = COLOR
    DB['refracttint'] = COLOR
    DB['rimlighttint'] = COLOR
    DB['scroll1'] = COLOR
    DB['scroll2'] = COLOR
    DB['selfillumtint'] = COLOR
    DB['sheenmaptint'] = COLOR
    DB['silhouettecolor'] = COLOR
    DB['tint'] = COLOR

    DB['base_step_range'] = VEC2
    DB['basetextureoffset'] = VEC2
    DB['basetexturescale'] = VEC2
    DB['bumpoffset'] = VEC2
    DB['canvas_step_range'] = VEC2
    DB['cloudscale'] = VEC2
    DB['cropfactor'] = VEC2
    DB['damagelevels1'] = VEC2
    DB['damagelevels2'] = VEC2
    DB['damagelevels3'] = VEC2
    DB['damagelevels4'] = VEC2
    DB['emissiveblendscrollvector'] = VEC2
    DB['envmaplightscaleminmax'] = VEC2
    DB['flowmapscrollrate'] = VEC2
    DB['gray_step'] = VEC2
    DB['lightmap_step_range'] = VEC2
    DB['magnifycenter'] = VEC2
    DB['maskscale'] = VEC2
    DB['phongmaskcontrastbrightness'] = VEC2
    DB['phongmaskcontrastbrightness2'] = VEC2
    DB['refractionamount'] = VEC2
    DB['scale'] = VEC2

    DB['ambientocclcolor'] = VEC3
    DB['ambientreflectionbouncecenter'] = VEC3
    DB['armcolor'] = VEC3
    DB['basealphaenvmapmaskminmaxexp'] = VEC3
    DB['basecolortint'] = VEC3
    DB['bbmax'] = VEC3
    DB['bbmin'] = VEC3
    DB['blendwithsmokegrenadeposentity'] = VEC3
    DB['blendwithsmokegrenadepossmoke'] = VEC3
    DB['camocolor0'] = VEC3
    DB['camocolor1'] = VEC3
    DB['camocolor2'] = VEC3
    DB['camocolor3'] = VEC3
    DB['canvas_color_end'] = VEC3
    DB['canvas_color_start'] = VEC3
    DB['canvas_scale'] = VEC3
    DB['clearcolor'] = VEC3
    DB['colortint2'] = VEC3
    DB['colortint3'] = VEC3
    DB['colortint4'] = VEC3
    DB['dimensions'] = VEC3
    DB['entcenter'] = VEC3
    DB['entityorigin'] = VEC3
    DB['envmapfresnelminmaxexp'] = VEC3
    DB['eyeorigin'] = VEC3
    DB['eyeup'] = VEC3
    DB['flow_vortex_pos1'] = VEC3
    DB['flow_vortex_pos2'] = VEC3
    DB['forward'] = VEC3
    DB['fresnelranges'] = VEC3
    DB['hsv_correction'] = VEC3
    DB['interiorcolor'] = VEC3
    DB['leafcenter'] = VEC3
    DB['lerpcolor1'] = VEC3
    DB['lerpcolor2'] = VEC3
    DB['light_color'] = VEC3
    DB['light_position'] = VEC3
    DB['pattern1color1'] = VEC3
    DB['pattern1color2'] = VEC3
    DB['pattern1color3'] = VEC3
    DB['pattern1color4'] = VEC3
    DB['pattern2color1'] = VEC3
    DB['pattern2color2'] = VEC3
    DB['pattern2color3'] = VEC3
    DB['pattern2color4'] = VEC3
    DB['phongcolortint'] = VEC3
    DB['phongfresnel'] = VEC3
    DB['phongfresnel2'] = VEC3
    DB['phongfresnelranges'] = VEC3
    DB['spriteorigin'] = VEC3
    DB['sscolortint'] = VEC3
    DB['stripe_color'] = VEC3
    DB['stripe_fade_normal1'] = VEC3
    DB['stripe_fade_normal2'] = VEC3
    DB['stripe_scale'] = VEC3
    DB['texadjustlevels0'] = VEC3
    DB['texadjustlevels1'] = VEC3
    DB['texadjustlevels2'] = VEC3
    DB['texadjustlevels3'] = VEC3
    DB['translucentfresnelminmaxexp'] = VEC3
    DB['uvprojoffset'] = VEC3
    DB['vomitcolor1'] = VEC3
    DB['vomitcolor2'] = VEC3

    DB['aainternal1'] = VEC4
    DB['aainternal2'] = VEC4
    DB['aainternal3'] = VEC4
    DB['attenfactors'] = VEC4
    DB['bloomamount'] = VEC4
    DB['channel_select'] = VEC4
    DB['curvaturewearboost'] = VEC4
    DB['curvaturewearpower'] = VEC4
    DB['damagedetailbrightnessadjustment'] = VEC4
    DB['damagedetailenvboost'] = VEC4
    DB['damagedetailphongboost'] = VEC4
    DB['damagedetailsaturation'] = VEC4
    DB['damageedgeenvboost'] = VEC4
    DB['damageedgephongboost'] = VEC4
    DB['damagegrunge'] = VEC4
    DB['damagenormaledgedepth'] = VEC4
    DB['detailenvboost'] = VEC4
    DB['detailgrunge'] = VEC4
    DB['detailmetalness'] = VEC4
    DB['detailnormaldepth'] = VEC4
    DB['detailphongalbedotint'] = VEC4
    DB['detailphongboost'] = VEC4
    DB['detailscale'] = VEC4
    DB['detailwarpindex'] = VEC4
    DB['distortbounds'] = VEC4
    DB['eyedir'] = VEC4
    DB['eyeposznear'] = VEC4
    DB['fadecolor'] = VEC4
    DB['flashlightcolor'] = VEC4
    DB['flesheffectcenterradius1'] = VEC4
    DB['flesheffectcenterradius2'] = VEC4
    DB['flesheffectcenterradius3'] = VEC4
    DB['flesheffectcenterradius4'] = VEC4
    DB['fresnelopacityranges'] = VEC4
    DB['fxaainternalc'] = VEC4
    DB['fxaainternalq'] = VEC4
    DB['glintu'] = VEC4
    DB['glintv'] = VEC4
    DB['grimebrightnessadjustment'] = VEC4
    DB['grimesaturation'] = VEC4
    DB['grungemax'] = VEC4
    DB['hslnoisescale'] = VEC4
    DB['irisu'] = VEC4
    DB['irisv'] = VEC4
    DB['jitterseed'] = VEC4
    DB['motionblurinternal'] = VEC4
    DB['motionblurviewportinternal'] = VEC4
    DB['noisescale'] = VEC4
    DB['originfarz'] = VEC4
    DB['patterncolorindices'] = VEC4
    DB['phongamount'] = VEC4
    DB['phongamount2'] = VEC4
    DB['quatorientation'] = VEC4
    DB['rimhalobounds'] = VEC4
    DB['scalebias'] = VEC4
    DB['selfillumfresnelminmaxexp'] = VEC4
    DB['shadowsaturationbounds'] = VEC4
    DB['shadowtint'] = VEC4
    DB['tangentsopacityranges'] = VEC4
    DB['tangenttopacityranges'] = VEC4
    DB['uberheightwidth'] = VEC4
    DB['ubernearfar'] = VEC4
    DB['weardetailenvboost'] = VEC4
    DB['weardetailphongboost'] = VEC4
    DB['weights'] = VEC4

    DB['alternateviewmatrix'] = MATRIX
    DB['basetexturetransform'] = MATRIX
    DB['basetexturetransform2'] = MATRIX
    DB['blendmasktransform'] = MATRIX
    DB['blendmodulatetransform'] = MATRIX
    DB['bumptransform'] = MATRIX
    DB['bumptransform2'] = MATRIX
    DB['detail1transform'] = MATRIX
    DB['detail2transform'] = MATRIX
    DB['detail1texturetransform'] = MATRIX
    DB['detail2texturetransform'] = MATRIX
    DB['detailtexturetransform'] = MATRIX
    DB['detailtransform'] = MATRIX
    DB['envmapmasktransform'] = MATRIX
    DB['envmapmasktransform2'] = MATRIX
    DB['grungetexturerotation'] = MATRIX
    DB['grungetexturetransform'] = MATRIX
    DB['orientationmatrix'] = MATRIX
    DB['patterntexturerotation'] = MATRIX
    DB['patterntexturetransform'] = MATRIX
    DB['texture2transform'] = MATRIX
    DB['texturetransform'] = MATRIX
    DB['viewproj'] = MATRIX
    DB['weartexturetransform'] = MATRIX
    DB['worldtotexture'] = MATRIX

    DB['textransform0'] = MATRIX_4X2
    DB['textransform1'] = MATRIX_4X2
    DB['textransform2'] = MATRIX_4X2
    DB['textransform3'] = MATRIX_4X2

    DB['lights'] = FOUR_CC
