import numpy as np
import pandas as pd

NER_INFERENCE_DATA = [
    "what is SEMRUSH PRO? Can you run complex queries ? Can you identify "
    "active usage ?",
    "Thank you for your subscription renewal",
    "you can upgrade your account for an old price,while you can upgrade your "
    "account for $399.95/month",
    "I like EMSI ordered the pro package",
    "Here you go, your account is created",
]


NER_INFERENCE_PRED_TOKEN_SPANS = [
    [
        {
            "start": 4,
            "end": 7,
            "label": "Questions About the Product",
        },
        {
            "start": 12,
            "end": 14,
            "label": "Product Usage",
        },
    ],
    [
        {
            "start": 4,
            "end": 6,
            "label": "Renew",
        },
    ],
    [
        {
            "start": 0,
            "end": 3,
            "label": "Questions About the Product",
        },
        {
            "start": 15,
            "end": 19,
            "label": "Potential Upsell",
        },
    ],
    [],  # No spans
    [
        {
            "start": 0,
            "end": 2,
            "label": "Action item accomplished",
        },
        {
            "start": 7,
            "end": 8,
            "label": "Action item accomplished",
        },
    ],
]


class TestSpacyInfExpectedResults:
    _num_pred_spans = 7

    gt_data = pd.DataFrame(
        data={
            "id": [0, 1, 2, 3, 4],
            "split": ["inference"] * 5,
            "text": [text for text in NER_INFERENCE_DATA],
            "text_token_indices": [
                np.array(
                    [
                        0,
                        4,
                        5,
                        7,
                        8,
                        15,
                        16,
                        19,
                        19,
                        20,
                        21,
                        24,
                        25,
                        28,
                        29,
                        32,
                        33,
                        40,
                        41,
                        48,
                        49,
                        50,
                        51,
                        54,
                        55,
                        58,
                        59,
                        67,
                        68,
                        74,
                        75,
                        80,
                        81,
                        82,
                    ]
                ),
                np.array([0, 5, 6, 9, 10, 13, 14, 18, 19, 31, 32, 39]),
                np.array(
                    [
                        0,
                        3,
                        4,
                        7,
                        8,
                        15,
                        16,
                        20,
                        21,
                        28,
                        29,
                        32,
                        33,
                        35,
                        36,
                        39,
                        40,
                        45,
                        45,
                        46,
                        46,
                        51,
                        52,
                        55,
                        56,
                        59,
                        60,
                        67,
                        68,
                        72,
                        73,
                        80,
                        81,
                        84,
                        85,
                        86,
                        86,
                        92,
                        92,
                        93,
                        93,
                        98,
                    ]
                ),
                np.array([0, 1, 2, 6, 7, 11, 12, 19, 20, 23, 24, 27, 28, 35]),
                np.array([0, 4, 5, 8, 9, 11, 11, 12, 13, 17, 18, 25, 26, 28, 29, 36]),
            ],
            "data_schema_version": [1] * 5,
            "inference_name": ["inf-name"] * 5,
        }
    )

    gt_embs = np.array(
        [
            [
                3.1383953,
                2.3408267,
                2.6516085,
                1.7403995,
                3.2113478,
                0.8757307,
                0.11816832,
                0.69878,
                2.330732,
                -0.05013974,
                2.1761105,
                3.4475605,
                -1.4118704,
                2.6041858,
                1.4076276,
                -0.22175558,
                0.68846196,
                -0.13019323,
                2.0783825,
                0.41265216,
                1.062225,
                -0.56800604,
                -0.09842223,
                -1.5867354,
                2.0830746,
                -0.06078593,
                0.5114797,
                -0.49742976,
                1.5429507,
                1.7722355,
                2.347841,
                -0.57945013,
                0.5443551,
                3.640356,
                0.86564904,
                1.0570426,
                1.6643162,
                1.3445047,
                -0.6975701,
                1.1946363,
                0.92988294,
                -1.7837046,
                2.7919605,
                0.24788739,
                -1.9661951,
                2.3360949,
                1.0168893,
                0.56193614,
                0.8240712,
                0.50280744,
                -0.43305004,
                1.2771021,
                -0.39221463,
                2.6692727,
                -0.3810848,
                1.4361464,
                -0.4678905,
                2.7303379,
                2.109554,
                0.50055045,
                2.2868264,
                2.7649956,
                1.1778748,
                -0.8087464,
            ],
            [
                3.3321967,
                1.7171514,
                4.0586705,
                0.93516237,
                2.3180275,
                0.08586156,
                3.664233,
                1.4751972,
                1.4469926,
                -0.06649423,
                2.4134824,
                0.5079258,
                1.0127695,
                2.1553845,
                1.036542,
                1.45452,
                0.9027786,
                0.36534536,
                2.4171739,
                3.3647738,
                2.6372004,
                0.42923522,
                -1.1852815,
                -0.46614414,
                1.9685413,
                -1.1646935,
                -0.930418,
                -0.88720334,
                -0.15842248,
                3.7730317,
                1.9908421,
                0.24719298,
                3.5114,
                2.9316816,
                4.7479706,
                -0.8322506,
                -0.14628226,
                -0.9489748,
                0.5602751,
                2.2721517,
                0.63377273,
                -0.9134733,
                4.1321335,
                2.0371552,
                -1.7561035,
                -0.7802668,
                0.38712534,
                -0.500168,
                -0.711089,
                0.32723296,
                0.3436008,
                -1.8278565,
                0.4129467,
                2.3861656,
                0.96697414,
                0.07608116,
                -0.29219186,
                4.0129604,
                0.33706594,
                -0.9185832,
                2.0322056,
                0.25113243,
                3.7790494,
                -0.8371177,
            ],
            [
                2.8401604,
                0.63505256,
                -0.10461137,
                2.578117,
                -1.330661,
                0.9475782,
                1.6755155,
                3.6151,
                -0.31356806,
                0.08616984,
                2.729703,
                1.3510982,
                0.97939914,
                1.5334649,
                1.4415653,
                0.13007703,
                -1.4650145,
                1.5482799,
                -1.2853653,
                -1.8809769,
                3.1041138,
                -1.4606898,
                0.13082224,
                2.074159,
                2.5809283,
                1.3996227,
                -3.4564764,
                3.686146,
                -1.408398,
                1.8242207,
                2.166,
                0.24552843,
                0.72455376,
                -1.5005933,
                3.5695937,
                -0.24761796,
                1.0506842,
                -2.27755,
                0.14802724,
                0.6420504,
                0.30908757,
                1.7965071,
                3.200688,
                2.127191,
                0.7679619,
                2.3847578,
                0.68884563,
                2.2493012,
                -0.88085514,
                1.9999274,
                0.2774056,
                1.1710576,
                0.8290166,
                1.5760612,
                0.13326705,
                2.8582237,
                -1.1296625,
                2.1139379,
                0.5856512,
                2.119814,
                0.17019646,
                -0.48156753,
                1.0847967,
                0.2831691,
            ],
            [
                0.10495573,
                3.0870533,
                4.5054717,
                2.4136634,
                -0.24235757,
                2.069043,
                3.7076428,
                2.0332863,
                2.2784576,
                0.20024078,
                -2.5554707,
                3.9429557,
                3.1017733,
                0.3079555,
                0.5005562,
                0.5401815,
                -0.49460337,
                2.1514933,
                1.0002793,
                1.4147598,
                0.19675918,
                0.9913063,
                0.94160074,
                1.9770981,
                1.6148329,
                -0.23298897,
                -2.2282982,
                3.2449398,
                1.9587202,
                2.2918272,
                -0.3165122,
                -0.8986463,
                3.471162,
                0.27623162,
                2.5261238,
                0.5936857,
                -0.51413465,
                0.6445126,
                0.03910549,
                -1.3500549,
                0.92959183,
                2.3944077,
                0.60349846,
                0.38073936,
                -0.32507953,
                -1.6393042,
                0.46910617,
                0.8604531,
                2.198036,
                0.2576604,
                1.9173332,
                -0.10889443,
                1.1242324,
                1.5270033,
                2.5072916,
                1.3392653,
                0.1131917,
                1.2207838,
                0.98492175,
                0.10374689,
                1.4641858,
                1.2484522,
                -0.6606431,
                0.54244953,
            ],
            [
                1.349212,
                2.5045338,
                4.4973307,
                1.0373718,
                0.20255105,
                1.3870025,
                3.0024672,
                1.0057974,
                0.43772727,
                -0.45385814,
                -1.2120736,
                3.6949816,
                3.273583,
                0.674335,
                0.8199037,
                0.50674593,
                0.5163014,
                4.2091146,
                1.3822153,
                1.6951805,
                1.4845037,
                0.5272081,
                0.43332705,
                2.6770892,
                1.0720916,
                0.6923523,
                -1.070011,
                2.6869988,
                -1.2935556,
                2.0409958,
                -0.27134472,
                1.1391652,
                1.4909495,
                -0.0131737,
                1.7881291,
                0.6411554,
                -0.28914273,
                1.8291074,
                0.13586393,
                -1.7164166,
                2.4417126,
                2.0032225,
                2.5052392,
                1.252268,
                0.41742608,
                -1.1458592,
                -0.11723345,
                0.1454942,
                2.1904562,
                0.22656651,
                0.43598676,
                -0.04788433,
                -1.020346,
                0.94824505,
                3.2039342,
                1.2887118,
                1.6858674,
                2.236898,
                1.4377887,
                2.253681,
                2.10099,
                0.5991303,
                0.08879429,
                2.529459,
            ],
            [
                -0.09505077,
                0.32679874,
                2.3400943,
                2.10548,
                1.8904355,
                1.8931297,
                -0.17870778,
                0.7404331,
                1.4551016,
                2.4158943,
                1.109205,
                0.9115504,
                1.3019061,
                1.0680531,
                -1.8533196,
                -1.0955439,
                2.3895948,
                1.4372021,
                3.3017035,
                2.2016115,
                1.9160764,
                0.26692897,
                0.1335612,
                1.8787584,
                1.2671168,
                0.46776912,
                -0.99382305,
                1.2335877,
                3.248602,
                1.278194,
                -1.0149589,
                2.3263988,
                0.57630354,
                1.3025165,
                1.3067601,
                -1.104223,
                -0.7174866,
                1.8391798,
                -0.2888974,
                -1.0227776,
                0.59967285,
                0.89330375,
                1.7685502,
                2.6737447,
                -0.23913033,
                -0.10874215,
                1.2679658,
                -0.6370412,
                -0.12265019,
                1.5359462,
                0.87712854,
                -0.07987761,
                -0.31346488,
                0.38038152,
                3.10736,
                -0.46001062,
                -1.0708827,
                -0.05613124,
                -1.58802,
                0.3528408,
                0.4404718,
                -0.38511515,
                -0.88490534,
                -1.4142962,
            ],
            [
                1.4844549,
                -0.9445604,
                1.0033686,
                0.7202112,
                0.28536844,
                3.1381483,
                -1.0630035,
                1.2837669,
                0.45070922,
                0.85618865,
                1.2805169,
                2.1536958,
                3.3213968,
                -0.03867286,
                1.6885877,
                -1.883349,
                1.489826,
                -0.5832404,
                -0.502236,
                -1.2556882,
                2.3025677,
                2.0023885,
                0.5787802,
                3.5865383,
                -0.02193522,
                4.2582545,
                -2.1319413,
                1.1271908,
                0.3527876,
                0.6668182,
                2.417299,
                3.7933717,
                -1.0236979,
                0.96533644,
                1.7587876,
                0.240152,
                -1.7063031,
                5.309894,
                1.1645286,
                0.52215075,
                2.772215,
                0.44205338,
                0.8797684,
                1.3354323,
                -0.66853106,
                -0.34451294,
                0.74464715,
                3.2473092,
                -0.14753544,
                -1.4195126,
                -0.04751348,
                0.04298371,
                -1.2152971,
                -1.0605416,
                0.6268512,
                2.7919776,
                0.9945015,
                3.9574814,
                -1.0236553,
                2.0193195,
                0.44183183,
                0.20232856,
                -1.1439514,
                -1.941823,
            ],
        ],
        dtype=np.float32,
    )

    gt_conf_prob = np.array(
        [
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.05811495,
                0.02137929,
                0.02137929,
                0.02137929,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.05811495,
                0.02137929,
            ],
            [
                0.06812549,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.02506196,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.06812549,
                0.02506196,
            ],
        ],
        dtype=np.float32,
    )

    gt_probs = pd.DataFrame(
        data={
            "sample_id": [0, 0, 1, 2, 2, 4, 4],
            "split": ["inference"] * _num_pred_spans,
            "is_pred": [True] * _num_pred_spans,
            "span_start": [4, 12, 4, 0, 15, 0, 7],
            "span_end": [7, 14, 6, 3, 19, 2, 8],
            "pred": [
                "Questions About the Product",
                "Product Usage",
                "Renew",
                "Questions About the Product",
                "Potential Upsell",
                "Action item accomplished",
                "Action item accomplished",
            ],
            "inference_name": ["inf-name"] * _num_pred_spans,
        }
    )


NER_INFERENCE_DATA_TOKEN_INDICES = [
    [
        0,
        4,
        5,
        7,
        8,
        15,
        16,
        19,
        19,
        20,
        21,
        24,
        25,
        28,
        29,
        32,
        33,
        40,
        41,
        48,
        49,
        50,
        51,
        54,
        55,
        58,
        59,
        67,
        68,
        74,
        75,
        80,
        81,
        82,
    ],
    [0, 5, 6, 9, 10, 13, 14, 18, 19, 31, 32, 39],
    [
        0,
        3,
        4,
        7,
        8,
        15,
        16,
        20,
        21,
        28,
        29,
        32,
        33,
        35,
        36,
        39,
        40,
        45,
        45,
        46,
        46,
        51,
        52,
        55,
        56,
        59,
        60,
        67,
        68,
        72,
        73,
        80,
        81,
        84,
        85,
        86,
        86,
        92,
        92,
        93,
        93,
        98,
    ],
    [0, 1, 2, 6, 7, 11, 12, 19, 20, 23, 24, 27, 28, 35],
    [0, 4, 5, 8, 9, 11, 11, 12, 13, 17, 18, 25, 26, 28, 29, 36],
]
