"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
let stack;
let api;
beforeEach(() => {
    stack = new cdk.Stack();
    api = new appsync.GraphqlApi(stack, 'api', {
        authorizationConfig: {},
        name: 'api',
        schema: appsync.Schema.fromAsset(path.join(__dirname, 'appsync.test.graphql')),
    });
});
test('appsync should configure pipeline when pipelineConfig has contents', () => {
    // WHEN
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
        pipelineConfig: ['test', 'test'],
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'PIPELINE',
        PipelineConfig: { Functions: ['test', 'test'] },
    });
});
test('appsync should configure resolver as unit when pipelineConfig is empty', () => {
    // WHEN
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'UNIT',
    });
});
test('appsync should configure resolver as unit when pipelineConfig is empty array', () => {
    // WHEN
    new appsync.Resolver(stack, 'resolver', {
        api: api,
        typeName: 'test',
        fieldName: 'test2',
        pipelineConfig: [],
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::Resolver', {
        Kind: 'UNIT',
    });
});
test('when xray is enabled should not throw an Error', () => {
    // WHEN
    new appsync.GraphqlApi(stack, 'api-x-ray', {
        authorizationConfig: {},
        name: 'api',
        schema: appsync.Schema.fromAsset(path.join(__dirname, 'appsync.test.graphql')),
        xrayEnabled: true,
    });
    // THEN
    expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLApi', {
        XrayEnabled: true,
    });
});
//# sourceMappingURL=data:application/json;base64,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