"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
const t = require("./scalar-type-defintions");
const out = 'input Test {\n  test: String\n}\n';
let stack;
let api;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    api = new appsync.GraphqlApi(stack, 'api', {
        name: 'api',
    });
});
describe('testing Input Type properties', () => {
    test('InputType configures properly', () => {
        // WHEN
        const test = new appsync.InputType('Test', {
            definition: { test: t.string },
        });
        api.addType(test);
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
        expect(stack).not.toHaveResource('AWS::AppSync::Resolver');
    });
    test('InputType can addField', () => {
        // WHEN
        const test = new appsync.InputType('Test', { definition: {} });
        api.addType(test);
        test.addField({ fieldName: 'test', field: t.string });
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('appsync fails addField with InputType missing fieldName', () => {
        // WHEN
        const test = new appsync.InputType('Test', { definition: {} });
        api.addType(test);
        // THEN
        expect(() => {
            test.addField({ fieldName: 'test' });
        }).toThrowError('Input Types must have both fieldName and field options.');
    });
    test('appsync fails addField with InputType missing field', () => {
        // WHEN
        const test = new appsync.InputType('Test', { definition: {} });
        api.addType(test);
        // THEN
        expect(() => {
            test.addField({ field: t.string });
        }).toThrowError('Input Types must have both fieldName and field options.');
    });
    test('appsync fails addField with InputType missing both fieldName and field options', () => {
        // WHEN
        const test = new appsync.InputType('Test', { definition: {} });
        api.addType(test);
        // THEN
        expect(() => {
            test.addField({});
        }).toThrowError('Input Types must have both fieldName and field options.');
    });
    test('InputType can be a GraphqlType', () => {
        // WHEN
        const test = new appsync.InputType('Test', {
            definition: { test: t.string },
        });
        api.addType(test);
        api.addType(new appsync.ObjectType('Test2', {
            definition: { input: test.attribute() },
        }));
        const obj = 'type Test2 {\n  input: Test\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}${obj}`,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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