<p align="center">
  <h1 class="no-underline" style="text-align:center"> Pega Data Scientist Tools </h1>
</p>

<p align="center">
<img height="100px" src="https://raw.githubusercontent.com/pegasystems/pega-datascientist-tools/master/images/pegasystems-inc-vector-logo.svg" alt="Pega logo">
</p>

<p align="center">
  <!-- Tests -->
  <a href="https://github.com/pegasystems/pega-datascientist-tools/actions">
    <img src="https://github.com/pegasystems/pega-datascientist-tools/workflows/Python%20tests/badge.svg" alt="Python tests">
  </a>
  <a href="https://github.com/pegasystems/pega-datascientist-tools/actions">
    <img src="https://github.com/pegasystems/pega-datascientist-tools/workflows/R%20tests/badge.svg" alt="R tests">
  </a>
  <!-- Code coverage -->
  <a href="https://codecov.io/gh/pegasystems/pega-datascientist-tools">
    <img src="https://codecov.io/gh/pegasystems/pega-datascientist-tools/branch/master/graph/badge.svg"/>
  </a>
  <!-- Wiki -->
  <a href="https://github.com/pegasystems/pega-datascientist-tools/wiki">
    <img src="https://img.shields.io/badge/wiki-up-success" alt="wiki">
  </a>
  <!-- Documentation -->
  <a href="https://pegasystems.github.io/pega-datascientist-tools/">
    <img src="https://img.shields.io/badge/Documentation-Up-brightgreen" alt="docs">
  </a>
  <!-- License -->
  <a href="https://github.com/pegasystems/pega-datascientist-tools/blob/master/LICENSE">
    <img src="https://img.shields.io/github/license/pegasystems/pega-datascientist-tools" alt="Apache License 2.0">
  </a>
</p>

Open source tooling that helps data scientists working with Pega AI to analyze Pega decisioning and modeling performance.

We release this under the Apache 2.0 license and welcome contributing back, preferably through pull requests, but just submitting an Issue or sending a note to the authors is fine too. Pega does not make any representation or warranty with respect to this free software.

The tools help to do analysis on Pega decisioning and predictive analytics as used in solutions such as Customer Decision Hub or Process AI, pull data from the platform, easily build meaningful plots and more. Tooling exists in both R and Python, as an R package and as notebooks and scripts for Python. See the [Graph Gallery](https://pegasystems.github.io/pega-datascientist-tools/Python/articles/graph_gallery.html) for a sample of the graphs you can build to help get insights from the platform. Or jump right into the examples in [Python examples](https://pegasystems.github.io/pega-datascientist-tools/Python/examples.html), [R vignettes](https://pegasystems.github.io/pega-datascientist-tools/R/articles/index.html), or [browse the example folder](https://github.com/pegasystems/pega-datascientist-tools/tree/master/examples).

# Getting Started

For instructions and information, see the [Pega Data Scientist Tools Wiki page](https://github.com/pegasystems/pega-datascientist-tools/wiki). For further examples and the API reference, see the [Documentation](https://pegasystems.github.io/pega-datascientist-tools/).

# Contributing

We love feedback. If you have interesting analysis plots you would like to share, we are very interested in incoporating them. If you developed tools or library functions that may be of interest to others, consider sending us a pull request. See [Contributing](https://github.com/pegasystems/pega-datascientist-tools/wiki/Contributing) for guidance on developing the R and Python packages.
