# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbcat', 'dbcat.catalog', 'dbcat.migrations', 'dbcat.migrations.versions']

package_data = \
{'': ['*']}

install_requires = \
['PyMySQL>=1.0.2,<2.0.0',
 'PyYAML',
 'SQLAlchemy>=1.3.24,<1.4.0',
 'alembic>=1.6.5,<2.0.0',
 'amundsen-databuilder[athena,bigquery,glue,rds,snowflake]>=6,<7',
 'boto3==1.17.23',
 'botocore>=1.20.23,<1.21.0',
 'click',
 'psycopg2>=2.9.1,<3.0.0',
 'pyathena[sqlalchemy]==1.11.5',
 'pyhocon>=0.3.58,<0.4.0',
 'pyparsing>=2.0,<3.0',
 'snowflake-sqlalchemy==1.2.4',
 'sqlalchemy-mixins>=1.5,<2.0',
 'typer>=0.4.0,<0.5.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.6'],
 'datahub': ['acryl-datahub>=0.8.16,<0.9.0',
             'great-expectations>=0.13.42,<0.14.0']}

entry_points = \
{'console_scripts': ['dbcat = dbcat.__main__:app']}

setup_kwargs = {
    'name': 'dbcat',
    'version': '0.10.8',
    'description': 'Tokern Data Catalog',
    'long_description': '[![dbcat](https://github.com/tokern/dbcat/actions/workflows/ci.yml/badge.svg)](https://github.com/tokern/dbcat/actions/workflows/ci.yml)\n[![PyPI](https://img.shields.io/pypi/v/dbcat.svg)](https://pypi.python.org/pypi/dbcat)\n[![image](https://img.shields.io/pypi/l/dbcat.svg)](https://pypi.org/project/dbcat/)\n[![image](https://img.shields.io/pypi/pyversions/dbcat.svg)](https://pypi.org/project/dbcat/)\n\n# Data Catalog for Databases and Data Warehouses\n\n## Overview\n\n*dbcat* scans and maintains metadata from all your databases and data warehouses. \n*dbcat* also stores metadata generated by other data governance applications such as \n[PIICatcher](https://github.com/tokern/piicatcher) and [Lineage Engine](https://github.com/tokern/data-lineage).\n*dbcat* is typically used alongside other applications. It can also be used stand-alone to generate\na very simple data catalog using the CLI or API.  \n\n*dbcat* stores the catalog in a Postgresql or SQLite database. By default, the catalog is stored in a SQLite\ndatabase in `~/.config/tokern/catalog.db`\n\nThe catalog can be exported to [Datahub](https://datahubproject.io/) or [Amundsen](https://amundsen.io). This is very \nuseful to export PII tags or column lineage generated by PIICatcher or Lineage Engine. \nCheck [documentation for detailed instructions](https://tokern.io/docs/catalog/export) to set PII tags and \ncolumn-level lineage.\n\n\n## Quick Start\n\n*dbcat* is distributed as a python application.\n\n    python3 -m venv .env\n    source .env/bin/activate\n    pip install piicatcher\n\n    # configure the application\n    \n    dbcat catalog add-sqlite --name sample --path <path to sqlite db>\n    dbcat catalog scan --source-name sample\n\n## Documentation\n\nFor advanced usage refer documentation [Catalog Documentation](https://tokern.io/docs/catalog).\n\n## Supported Technologies\n\nThe following databases are supported:\n\n* MySQL/Mariadb\n* PostgreSQL\n* AWS Redshift\n* BigQuery\n* Snowflake\n* AWS Athena\n\n',
    'author': 'Tokern',
    'author_email': 'info@tokern.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://tokern.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<3.9',
}


setup(**setup_kwargs)
