"""Initial run

Revision ID: d1daff1715f7
Revises:
Create Date: 2021-07-13 18:50:29.689178

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy import JSON

# revision identifiers, used by Alembic.
revision = "d1daff1715f7"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "sources",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("source_type", sa.String(), nullable=True),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("dialect", sa.String(), nullable=True),
        sa.Column("uri", sa.String(), nullable=True),
        sa.Column("port", sa.String(), nullable=True),
        sa.Column("username", sa.String(), nullable=True),
        sa.Column("password", sa.String(), nullable=True),
        sa.Column("database", sa.String(), nullable=True),
        sa.Column("instance", sa.String(), nullable=True),
        sa.Column("cluster", sa.String(), nullable=True),
        sa.Column("project_id", sa.String(), nullable=True),
        sa.Column("project_credentials", sa.String(), nullable=True),
        sa.Column("page_size", sa.String(), nullable=True),
        sa.Column("filter_key", sa.String(), nullable=True),
        sa.Column("included_tables_regex", sa.String(), nullable=True),
        sa.Column("key_path", sa.String(), nullable=True),
        sa.Column("account", sa.String(), nullable=True),
        sa.Column("role", sa.String(), nullable=True),
        sa.Column("warehouse", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "jobs",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("context", JSON, nullable=True),
        sa.Column("source_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["source_id"], ["sources.id"],),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
        sa.UniqueConstraint("source_id", "name"),
    )
    op.create_table(
        "schemata",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("source_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["source_id"], ["sources.id"],),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("source_id", "name", name="unique_schema_name"),
    )
    op.create_table(
        "default_schema",
        sa.Column("source_id", sa.Integer(), nullable=False),
        sa.Column("schema_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["schema_id"], ["schemata.id"],),
        sa.ForeignKeyConstraint(["source_id"], ["sources.id"],),
        sa.PrimaryKeyConstraint("source_id"),
    )
    op.create_table(
        "job_executions",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("job_id", sa.Integer(), nullable=True),
        sa.Column("started_at", sa.TIMESTAMP(), nullable=True),
        sa.Column("ended_at", sa.TIMESTAMP(), nullable=True),
        sa.Column(
            "status",
            sa.Enum("SUCCESS", "FAILURE", name="jobexecutionstatus"),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(["job_id"], ["jobs.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "tables",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("schema_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["schema_id"], ["schemata.id"],),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("schema_id", "name", name="unique_table_name"),
    )
    op.create_table(
        "columns",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("data_type", sa.String(), nullable=True),
        sa.Column("sort_order", sa.Integer(), nullable=True),
        sa.Column("table_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["table_id"], ["tables.id"],),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("table_id", "name", name="unique_column_name"),
    )
    op.create_table(
        "column_lineage",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("context", JSON, nullable=True),
        sa.Column("source_id", sa.Integer(), nullable=True),
        sa.Column("target_id", sa.Integer(), nullable=True),
        sa.Column("job_execution_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(["job_execution_id"], ["job_executions.id"],),
        sa.ForeignKeyConstraint(["source_id"], ["columns.id"],),
        sa.ForeignKeyConstraint(["target_id"], ["columns.id"],),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "source_id", "target_id", "job_execution_id", name="unique_lineage"
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("column_lineage")
    op.drop_table("columns")
    op.drop_table("tables")
    op.drop_table("job_executions")
    op.drop_table("default_schema")
    op.drop_table("schemata")
    op.drop_table("jobs")
    op.drop_table("sources")
    # ### end Alembic commands ###
