import * as iam from '@aws-cdk/aws-iam';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { AlarmActions, Domain } from './api';
/**
 * (experimental) Props for `ConstructHub`.
 *
 * @experimental
 */
export interface ConstructHubProps {
    /**
     * (experimental) Connect the hub to a domain (requires a hosted zone and a certificate).
     *
     * @experimental
     */
    readonly domain?: Domain;
    /**
     * (experimental) The name of the CloudWatch Dashboard created to observe this application.
     *
     * Must only contain alphanumerics, dash (-) and underscore (_).
     *
     * @default "construct-hub"
     * @experimental
     */
    readonly dashboardName?: string;
    /**
     * (experimental) Actions to perform when alarms are set.
     *
     * @experimental
     */
    readonly alarmActions: AlarmActions;
    /**
     * (experimental) Whether sensitive Lambda functions (which operate on un-trusted complex data, such as the transliterator, which operates with externally-sourced npm package tarballs) should run in network-isolated environments.
     *
     * This
     * implies the creation of additonal resources, including:
     *
     * - A VPC with only isolated subnets.
     * - VPC Endpoints (CodeArtifact, CodeArtifact API, S3)
     * - A CodeArtifact Repository with an external connection to npmjs.com
     *
     * @default true
     * @experimental
     */
    readonly isolateLambdas?: boolean;
    /**
     * (experimental) The name of the CloudWatch dashboard that represents the health of backend systems.
     *
     * @experimental
     */
    readonly backendDashboardName?: string;
}
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
export declare class ConstructHub extends CoreConstruct implements iam.IGrantable {
    private readonly ingestion;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ConstructHubProps);
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * @experimental
     */
    get ingestionQueue(): sqs.IQueue;
}
