import { GatewayVpcEndpoint, InterfaceVpcEndpoint, IVpc, SubnetSelection } from '@aws-cdk/aws-ec2';
import { IAccessPoint } from '@aws-cdk/aws-efs';
import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Repository } from '../../codeartifact/repository';
import { Monitoring } from '../../monitoring';
import { DocumentationLanguage } from '../shared/language';
export interface TransliteratorProps {
    /**
     * The bucket in which to source assemblies to transliterate.
     */
    readonly bucket: IBucket;
    /**
     * The language to generate documentation for.
     */
    readonly language: DocumentationLanguage;
    /**
     * The CodeArtifact registry to use for regular operations.
     */
    readonly codeArtifact?: Repository;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The VPC in which isolated lambda functions will reside.
     */
    readonly vpc: IVpc;
    /**
     * The subnet selection to use for placement of the Lambda function.
     */
    readonly vpcSubnets?: SubnetSelection;
    /**
     * VPC endpoints to use for interacting with CodeArtifact and S3.
     */
    readonly vpcEndpoints?: TransliteratorVpcEndpoints;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * An optional EFS Access Point to use for allowing to work with larger
     * packages, which otherwise would exceed Lambda's 512MB writable storage
     * limit.
     */
    readonly efsAccessPoint: IAccessPoint;
}
export interface TransliteratorVpcEndpoints {
    /**
     * The VPC endpoint for the CodeArtifact API (service: 'codeartifact.api')
     */
    readonly codeArtifactApi: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the CodeArtifact repositories (service: 'codeartifact.repositories')
     */
    readonly codeArtifact: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the Elastic File System service.
     */
    readonly elasticFileSystem: InterfaceVpcEndpoint;
    /**
     * The VPC endpoint for the S3
     */
    readonly s3: GatewayVpcEndpoint;
}
/**
 * Transliterates jsii assemblies to various other languages.
 */
export declare class Transliterator extends Construct {
    readonly function: IFunction;
    constructor(scope: Construct, id: string, props: TransliteratorProps);
}
