"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logInWithCodeArtifact = void 0;
const child_process_1 = require("child_process");
const aws_sdk_1 = require("aws-sdk");
/**
 * Logs into the provided CodeArtifact registry, and makes it the default NPM
 * registry for this environment.
 */
async function logInWithCodeArtifact({ endpoint, domain, domainOwner, apiEndpoint }) {
    // Remove the protocol part of the endpoint URL, keeping the rest intact.
    const protoRelativeEndpoint = endpoint.replace(/^[^:]+:/, '');
    const { authorizationToken } = await new aws_sdk_1.CodeArtifact({ endpoint: apiEndpoint }).getAuthorizationToken({
        domain,
        domainOwner,
        durationSeconds: 0,
    }).promise();
    await shellOut('npm', 'config', 'set', `registry=${endpoint}`);
    await shellOut('npm', 'config', 'set', `${protoRelativeEndpoint}:_authToken=${authorizationToken}`);
    await shellOut('npm', 'config', 'set', `${protoRelativeEndpoint}:always-auth=true`);
    function shellOut(cmd, ...args) {
        return new Promise((ok, ko) => {
            const child = child_process_1.spawn(cmd, args, { stdio: ['ignore', 'inherit', 'inherit'] });
            child.once('error', ko);
            child.once('close', (code, signal) => {
                if (code === 0) {
                    return ok();
                }
                const reason = code != null
                    ? `exit code ${code}`
                    : `signal ${signal}`;
                ko(new Error(`Command "${cmd} ${args.join(' ')}" failed with ${reason}`));
            });
        });
    }
}
exports.logInWithCodeArtifact = logInWithCodeArtifact;
//# sourceMappingURL=data:application/json;base64,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