"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
const yaml_1 = require("yaml");
const dev_stack_1 = require("./dev-stack");
expect.addSnapshotSerializer({
    test: (val) => val instanceof cxapi.CloudFormationStackArtifact,
    serialize: (val) => yaml_1.stringify(val.template),
});
test('golden snapshot', () => {
    const app = new core_1.App();
    const stack = new dev_stack_1.DevStack(app, 'dev', { isolateLambdas: true });
    expect(app.synth().getStackByName(stack.stackName)).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25hcHNob3QudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9fX3Rlc3RzX18vZGV2YXBwL3NuYXBzaG90LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFFOUIsd0NBQW9DO0FBQ3BDLHlDQUF5QztBQUN6QywrQkFBeUM7QUFFekMsMkNBQXVDO0FBRXZDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztJQUMzQixJQUFJLEVBQUUsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLEdBQUcsWUFBWSxLQUFLLENBQUMsMkJBQTJCO0lBQy9ELFNBQVMsRUFBRSxDQUFDLEdBQXNDLEVBQUUsRUFBRSxDQUFDLGdCQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQztDQUMxRSxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxFQUFFO0lBQzNCLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7SUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxvQkFBUSxDQUFDLEdBQUcsRUFBRSxLQUFLLEVBQUUsRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUNqRSxNQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUN4RSxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuXG5pbXBvcnQgeyBBcHAgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGN4YXBpIGZyb20gJ0Bhd3MtY2RrL2N4LWFwaSc7XG5pbXBvcnQgeyBzdHJpbmdpZnkgYXMgeWFtbCB9IGZyb20gJ3lhbWwnO1xuXG5pbXBvcnQgeyBEZXZTdGFjayB9IGZyb20gJy4vZGV2LXN0YWNrJztcblxuZXhwZWN0LmFkZFNuYXBzaG90U2VyaWFsaXplcih7XG4gIHRlc3Q6ICh2YWwpID0+IHZhbCBpbnN0YW5jZW9mIGN4YXBpLkNsb3VkRm9ybWF0aW9uU3RhY2tBcnRpZmFjdCxcbiAgc2VyaWFsaXplOiAodmFsOiBjeGFwaS5DbG91ZEZvcm1hdGlvblN0YWNrQXJ0aWZhY3QpID0+IHlhbWwodmFsLnRlbXBsYXRlKSxcbn0pO1xuXG50ZXN0KCdnb2xkZW4gc25hcHNob3QnLCAoKSA9PiB7XG4gIGNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbiAgY29uc3Qgc3RhY2sgPSBuZXcgRGV2U3RhY2soYXBwLCAnZGV2JywgeyBpc29sYXRlTGFtYmRhczogdHJ1ZSB9KTtcbiAgZXhwZWN0KGFwcC5zeW50aCgpLmdldFN0YWNrQnlOYW1lKHN0YWNrLnN0YWNrTmFtZSkpLnRvTWF0Y2hTbmFwc2hvdCgpO1xufSk7XG4iXX0=