"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevStack = void 0;
const process = require("process");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const __1 = require("../..");
class DevStack extends core_1.Stack {
    constructor(scope, id, { isolateLambdas = !!process.env.ISOLATE_LAMBDAS } = {}) {
        super(scope, id, {
            env: {
                account: process.env.CDK_DEFAULT_ACCOUNT,
                region: process.env.CDK_DEFAULT_REGION,
            },
        });
        const topic = new sns.Topic(this, 'Topic');
        new __1.ConstructHub(this, 'ConstructHub', {
            alarmActions: {
                normalSeverity: topic.topicArn,
                highSeverity: topic.topicArn,
            },
            backendDashboardName: 'construct-hub-backend',
            isolateLambdas,
        });
    }
}
exports.DevStack = DevStack;
//# sourceMappingURL=data:application/json;base64,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