# flake8: noqa

from typing import Any, Sequence, Tuple, overload

AfterLoadSequence: int
AfterSet: int
AnyType: int
Attention: int
AutoFocusDevice: int
BeforeGet: int
CameraDevice: int
CanCommunicate: int
CanNotCommunicate: int
CoreDevice: int
Done: int
Float: int
FocusDirectionAwayFromSample: int
FocusDirectionTowardSample: int
FocusDirectionUnknown: int
GalvoDevice: int
GenericDevice: int
HIDPort: int
HubDevice: int
ImageProcessorDevice: int
Integer: int
InvalidPort: int
IsSequenceable: int
MagnifierDevice: int
MaxStrLength: int
Misconfigured: int
NoAction: int
SLMDevice: int
SerialDevice: int
SerialPort: int
ShutterDevice: int
SignalIODevice: int
StageDevice: int
StartSequence: int
StateDevice: int
StatusChanged: int
StopSequence: int
String: int
USBPort: int
Undef: int
Unimplemented: int
UnknownType: int
XYStageDevice: int

g_CFGCommand_ConfigGroup: str
g_CFGCommand_ConfigPixelSize: str
g_CFGCommand_Configuration: str
g_CFGCommand_Delay: str
g_CFGCommand_Device: str
g_CFGCommand_Equipment: str
g_CFGCommand_FocusDirection: str
g_CFGCommand_ImageSynchro: str
g_CFGCommand_Label: str
g_CFGCommand_ParentID: str
g_CFGCommand_PixelSizeAffine: str
g_CFGCommand_PixelSize_um: str
g_CFGCommand_Property: str
g_CFGGroup_PixelSizeUm: str
g_CFGGroup_System: str
g_CFGGroup_System_Shutdown: str
g_CFGGroup_System_Startup: str
g_FieldDelimiters: str
g_Keyword_ActualExposure: str
g_Keyword_ActualInterval_ms: str
g_Keyword_AnswerTimeout: str
g_Keyword_BaudRate: str
g_Keyword_Binning: str
g_Keyword_CCDTemperature: str
g_Keyword_CCDTemperatureSetPoint: str
g_Keyword_CameraChannelIndex: str
g_Keyword_CameraChannelName: str
g_Keyword_CameraID: str
g_Keyword_CameraName: str
g_Keyword_Channel: str
g_Keyword_Closed_Position: str
g_Keyword_ColorMode: str
g_Keyword_CoreAutoFocus: str
g_Keyword_CoreAutoShutter: str
g_Keyword_CoreCamera: str
g_Keyword_CoreChannelGroup: str
g_Keyword_CoreDevice: str
g_Keyword_CoreFocus: str
g_Keyword_CoreGalvo: str
g_Keyword_CoreImageProcessor: str
g_Keyword_CoreInitialize: str
g_Keyword_CoreSLM: str
g_Keyword_CoreShutter: str
g_Keyword_CoreTimeoutMs: str
g_Keyword_CoreXYStage: str
g_Keyword_DataBits: str
g_Keyword_Delay: str
g_Keyword_DelayBetweenCharsMs: str
g_Keyword_Description: str
g_Keyword_EMGain: str
g_Keyword_Elapsed_Time_ms: str
g_Keyword_Exposure: str
g_Keyword_Gain: str
g_Keyword_Handshaking: str
g_Keyword_HubID: str
g_Keyword_Interval_ms: str
g_Keyword_Label: str
g_Keyword_Meatdata_Exposure: str
g_Keyword_Metadata_ImageNumber: str
g_Keyword_Metadata_ROI_X: str
g_Keyword_Metadata_ROI_Y: str
g_Keyword_Metadata_Score: str
g_Keyword_Metadata_StartTime: str
g_Keyword_Metadata_TimeInCore: str
g_Keyword_Name: str
g_Keyword_Offset: str
g_Keyword_Parity: str
g_Keyword_PixelType: str
g_Keyword_Port: str
g_Keyword_Position: str
g_Keyword_ReadoutMode: str
g_Keyword_ReadoutTime: str
g_Keyword_Speed: str
g_Keyword_State: str
g_Keyword_StopBits: str
g_Keyword_Transpose_Correction: str
g_Keyword_Transpose_MirrorX: str
g_Keyword_Transpose_MirrorY: str
g_Keyword_Transpose_SwapXY: str
g_Keyword_Type: str
g_Keyword_Version: str

DEVICE_BUFFER_OVERFLOW: int
DEVICE_CAMERA_BUSY_ACQUIRING: int
DEVICE_CAN_NOT_SET_PROPERTY: int
DEVICE_COMM_HUB_MISSING: int
DEVICE_CORE_CHANNEL_PRESETS_FAILED: int
DEVICE_CORE_CONFIG_FAILED: int
DEVICE_CORE_EXPOSURE_FAILED: int
DEVICE_CORE_FOCUS_STAGE_UNDEF: int
DEVICE_DUPLICATE_LABEL: int
DEVICE_DUPLICATE_LIBRARY: int
DEVICE_DUPLICATE_PROPERTY: int
DEVICE_ERR: int
DEVICE_IMAGE_PARAMS_FAILED: int
DEVICE_INCOMPATIBLE_IMAGE: int
DEVICE_INTERNAL_INCONSISTENCY: int
DEVICE_INVALID_INPUT_PARAM: int
DEVICE_INVALID_PROPERTY: int
DEVICE_INVALID_PROPERTY_LIMTS: int
DEVICE_INVALID_PROPERTY_TYPE: int
DEVICE_INVALID_PROPERTY_VALUE: int
DEVICE_LOCALLY_DEFINED_ERROR: int
DEVICE_NATIVE_MODULE_FAILED: int
DEVICE_NONEXISTENT_CHANNEL: int
DEVICE_NOT_CONNECTED: int
DEVICE_NOT_SUPPORTED: int
DEVICE_NOT_YET_IMPLEMENTED: int
DEVICE_NO_CALLBACK_REGISTERED: int
DEVICE_NO_PROPERTY_DATA: int
DEVICE_OK: int
DEVICE_OUT_OF_MEMORY: int
DEVICE_PROPERTY_NOT_SEQUENCEABLE: int
DEVICE_SELF_REFERENCE: int
DEVICE_SEQUENCE_TOO_LARGE: int
DEVICE_SERIAL_BUFFER_OVERRUN: int
DEVICE_SERIAL_COMMAND_FAILED: int
DEVICE_SERIAL_INVALID_RESPONSE: int
DEVICE_SERIAL_TIMEOUT: int
DEVICE_SNAP_IMAGE_FAILED: int
DEVICE_UNKNOWN_LABEL: int
DEVICE_UNKNOWN_POSITION: int
DEVICE_UNSUPPORTED_COMMAND: int
DEVICE_UNSUPPORTED_DATA_FORMAT: int
MM_CODE_ERR: int
MM_CODE_OK: int

def CMMCore_addSearchPath(*args, **kwargs) -> Any: ...
def CMMCore_getDeviceLibraries(*args, **kwargs) -> Any: ...
def CMMCore_noop(*args, **kwargs) -> Any: ...
def MetadataTag_ReadLine(*args, **kwargs) -> Any: ...
def PropertySetting_generateKey(*args, **kwargs) -> Any: ...
def SWIG_PyInstanceMethod_New(*args, **kwargs) -> Any: ...
def disown_MMEventCallback(*args, **kwargs) -> Any: ...

class CMMCore:
    def __init__(self) -> None: ...
    def addGalvoPolygonVertex(self, *args, **kwargs) -> Any: ...
    def addSearchPath(self, *args, **kwargs) -> Any: ...
    def assignImageSynchro(self, *args, **kwargs) -> Any: ...
    def clearCircularBuffer(self) -> Any: ...
    def clearROI(self) -> Any: ...
    def debugLogEnabled(self) -> bool: ...
    def defineConfig(self, *args, **kwargs) -> Any: ...
    def defineConfigGroup(self, *args, **kwargs) -> Any: ...
    def definePixelSizeConfig(self, *args, **kwargs) -> Any: ...
    def definePropertyBlock(self, *args, **kwargs) -> Any: ...
    def defineStateLabel(self, *args, **kwargs) -> Any: ...
    def deleteConfig(self, *args, **kwargs) -> Any: ...
    def deleteConfigGroup(self, *args, **kwargs) -> Any: ...
    def deleteGalvoPolygons(self, *args, **kwargs) -> Any: ...
    def deletePixelSizeConfig(self, *args, **kwargs) -> Any: ...
    def detectDevice(self, *args, **kwargs) -> Any: ...
    def deviceBusy(self, *args, **kwargs) -> Any: ...
    def deviceTypeBusy(self, MM) -> bool: ...
    def displaySLMImage(self, *args, **kwargs) -> Any: ...
    def enableContinuousFocus(self, enable: bool) -> Any: ...
    def enableDebugLog(self, enable: bool) -> Any: ...
    def enableStderrLog(self, enable: bool) -> Any: ...
    def fullFocus(self) -> Any: ...
    def getAPIVersionInfo(self, *args, **kwargs) -> Any: ...
    def getAllowedPropertyValues(self, *args, **kwargs) -> Any: ...
    def getAutoFocusDevice(self, *args, **kwargs) -> Any: ...
    def getAutoFocusOffset(self) -> float: ...
    def getAutoShutter(self) -> bool: ...
    def getAvailableConfigGroups(self) -> Tuple[str]: ...
    def getAvailableConfigs(self, *args, **kwargs) -> Any: ...
    def getAvailableDeviceDescriptions(self, *args, **kwargs) -> Any: ...
    def getAvailableDeviceTypes(self, *args, **kwargs) -> Any: ...
    def getAvailableDevices(self, *args, **kwargs) -> Any: ...
    def getAvailablePixelSizeConfigs(self) -> Tuple[str]: ...
    def getAvailablePropertyBlocks(self) -> Tuple[str]: ...
    def getBufferFreeCapacity(self) -> int: ...
    def getBufferTotalCapacity(self) -> int: ...
    def getBytesPerPixel(self) -> int: ...
    def getCameraChannelName(self, *args, **kwargs) -> Any: ...
    def getCameraDevice(self, *args, **kwargs) -> Any: ...
    def getChannelGroup(self, *args, **kwargs) -> Any: ...
    def getCircularBufferMemoryFootprint(self) -> int: ...
    def getConfigData(self, *args, **kwargs) -> Any: ...
    def getConfigGroupState(self, *args, **kwargs) -> Any: ...
    def getConfigGroupStateFromCache(self, *args, **kwargs) -> Any: ...
    def getConfigState(self, *args, **kwargs) -> Any: ...
    def getCoreErrorText(self, *args, **kwargs) -> Any: ...
    def getCurrentConfig(self, *args, **kwargs) -> Any: ...
    def getCurrentConfigFromCache(self, *args, **kwargs) -> Any: ...
    def getCurrentFocusScore(self) -> float: ...
    def getCurrentPixelSizeConfig(self, *args, **kwargs) -> Any: ...
    def getData(self, *args, **kwargs) -> Any: ...
    def getDeviceAdapterNames(self) -> Tuple[str]: ...
    def getDeviceAdapterSearchPaths(self) -> Tuple[str]: ...
    def getDeviceDelayMs(self, *args, **kwargs) -> Any: ...
    def getDeviceDescription(self, *args, **kwargs) -> Any: ...
    def getDeviceLibraries(self, *args, **kwargs) -> Any: ...
    def getDeviceLibrary(self, *args, **kwargs) -> Any: ...
    def getDeviceName(self, *args, **kwargs) -> Any: ...
    def getDevicePropertyNames(self, *args, **kwargs) -> Any: ...
    def getDeviceType(self, *args, **kwargs) -> Any: ...
    def getExposure(self) -> float: ...
    def getExposureSequenceMaxLength(self, *args, **kwargs) -> Any: ...
    def getFocusDevice(self, *args, **kwargs) -> Any: ...
    def getFocusDirection(self, *args, **kwargs) -> Any: ...
    def getGalvoChannel(self, *args, **kwargs) -> Any: ...
    def getGalvoDevice(self, *args, **kwargs) -> Any: ...
    def getGalvoPosition(self, *args, **kwargs) -> Any: ...
    def getGalvoXMinimum(self, *args, **kwargs) -> Any: ...
    def getGalvoXRange(self, *args, **kwargs) -> Any: ...
    def getGalvoYMinimum(self, *args, **kwargs) -> Any: ...
    def getGalvoYRange(self, *args, **kwargs) -> Any: ...
    def getHostName(self, *args, **kwargs) -> Any: ...
    def getImage(self, numChannel: int) -> Any: ...
    def getImageBitDepth(self) -> int: ...
    def getImageBufferSize(self) -> int: ...
    def getImageHeight(self) -> int: ...
    def getImageProcessorDevice(self, *args, **kwargs) -> Any: ...
    def getImageWidth(self) -> int: ...
    def getInstalledDeviceDescription(self, *args, **kwargs) -> Any: ...
    def getInstalledDevices(self, *args, **kwargs) -> Any: ...
    def getLastFocusScore(self) -> float: ...
    def getLastImage(self, *args, **kwargs) -> Any: ...
    def getLastImageMD(self, Metadatamd) -> Any: ...
    def getLoadedDevices(self) -> Tuple[str]: ...
    def getLoadedDevicesOfType(self, MM) -> Tuple[str]: ...
    def getLoadedPeripheralDevices(self, *args, **kwargs) -> Any: ...
    def getMACAddresses(self) -> Tuple[str]: ...
    def getMagnificationFactor(self) -> float: ...
    def getMultiROI(self, *args, **kwargs) -> Any: ...
    def getNBeforeLastImageMD(self, *args, **kwargs) -> Any: ...
    def getNumberOfCameraChannels(self) -> int: ...
    def getNumberOfComponents(self) -> int: ...
    def getNumberOfStates(self, *args, **kwargs) -> Any: ...
    def getParentLabel(self, *args, **kwargs) -> Any: ...
    @overload
    def getPixelSizeAffine(self) -> Tuple[float]: ...
    @overload
    def getPixelSizeAffine(self, cached: bool) -> Tuple[float]: ...
    def getPixelSizeAffineByID(self, *args, **kwargs) -> Any: ...
    def getPixelSizeConfigData(self, *args, **kwargs) -> Any: ...
    @overload
    def getPixelSizeUm(self) -> float: ...
    @overload
    def getPixelSizeUm(self, cached: bool) -> float: ...
    def getPixelSizeUmByID(self, *args, **kwargs) -> Any: ...
    def getPosition(self) -> float: ...
    def getPrimaryLogFile(self, *args, **kwargs) -> Any: ...
    def getProperty(self, *args, **kwargs) -> Any: ...
    def getPropertyBlockData(self, *args, **kwargs) -> Any: ...
    def getPropertyFromCache(self, *args, **kwargs) -> Any: ...
    def getPropertyLowerLimit(self, *args, **kwargs) -> Any: ...
    def getPropertySequenceMaxLength(self, *args, **kwargs) -> Any: ...
    def getPropertyType(self, *args, **kwargs) -> Any: ...
    def getPropertyUpperLimit(self, *args, **kwargs) -> Any: ...
    def getROI(self) -> Any: ...
    def getRemainingImageCount(self) -> int: ...
    def getSLMBytesPerPixel(self, *args, **kwargs) -> Any: ...
    def getSLMDevice(self, *args, **kwargs) -> Any: ...
    def getSLMExposure(self, *args, **kwargs) -> Any: ...
    def getSLMHeight(self, *args, **kwargs) -> Any: ...
    def getSLMNumberOfComponents(self, *args, **kwargs) -> Any: ...
    def getSLMSequenceMaxLength(self, *args, **kwargs) -> Any: ...
    def getSLMWidth(self, *args, **kwargs) -> Any: ...
    def getSerialPortAnswer(self, *args, **kwargs) -> Any: ...
    def getShutterDevice(self, *args, **kwargs) -> Any: ...
    def getShutterOpen(self) -> bool: ...
    def getStageSequenceMaxLength(self, *args, **kwargs) -> Any: ...
    def getState(self, *args, **kwargs) -> Any: ...
    def getStateFromLabel(self, *args, **kwargs) -> Any: ...
    def getStateLabel(self, *args, **kwargs) -> Any: ...
    def getStateLabelData(self, *args, **kwargs) -> Any: ...
    def getStateLabels(self, *args, **kwargs) -> Any: ...
    def getSystemState(self) -> Configuration: ...
    def getSystemStateCache(self) -> Configuration: ...
    def getTimeoutMs(self) -> int: ...
    def getUserId(self, *args, **kwargs) -> Any: ...
    def getVersionInfo(self, *args, **kwargs) -> Any: ...
    def getXPosition(self) -> float: ...
    def getXYPosition(self) -> Any: ...
    def getXYStageDevice(self, *args, **kwargs) -> Any: ...
    def getXYStageSequenceMaxLength(self, *args, **kwargs) -> Any: ...
    def getYPosition(self) -> float: ...
    def hasProperty(self, *args, **kwargs) -> Any: ...
    def hasPropertyLimits(self, *args, **kwargs) -> Any: ...
    def home(self, *args, **kwargs) -> Any: ...
    def incrementalFocus(self) -> Any: ...
    def initializeAllDevices(self) -> Any: ...
    def initializeCircularBuffer(self) -> Any: ...
    def initializeDevice(self, *args, **kwargs) -> Any: ...
    def isBufferOverflowed(self) -> bool: ...
    def isConfigDefined(self, *args, **kwargs) -> Any: ...
    def isContinuousFocusDrive(self, *args, **kwargs) -> Any: ...
    def isContinuousFocusEnabled(self) -> bool: ...
    def isContinuousFocusLocked(self) -> bool: ...
    def isExposureSequenceable(self, *args, **kwargs) -> Any: ...
    def isGroupDefined(self, *args, **kwargs) -> Any: ...
    def isMultiROIEnabled(self) -> bool: ...
    def isMultiROISupported(self) -> bool: ...
    def isPixelSizeConfigDefined(self, *args, **kwargs) -> Any: ...
    def isPropertyPreInit(self, *args, **kwargs) -> Any: ...
    def isPropertyReadOnly(self, *args, **kwargs) -> Any: ...
    def isPropertySequenceable(self, *args, **kwargs) -> Any: ...
    def isSequenceRunning(self) -> bool: ...
    def isStageLinearSequenceable(self, *args, **kwargs) -> Any: ...
    def isStageSequenceable(self, *args, **kwargs) -> Any: ...
    def isXYStageSequenceable(self, *args, **kwargs) -> Any: ...
    def loadDevice(self, *args, **kwargs) -> Any: ...
    def loadExposureSequence(self, *args, **kwargs) -> Any: ...
    def loadGalvoPolygons(self, *args, **kwargs) -> Any: ...
    def loadPropertySequence(self, *args, **kwargs) -> Any: ...
    def loadSLMSequence(self, *args, **kwargs) -> Any: ...
    def loadStageSequence(self, *args, **kwargs) -> Any: ...
    def loadSystemConfiguration(self, *args, **kwargs) -> Any: ...
    def loadSystemState(self, *args, **kwargs) -> Any: ...
    def loadXYStageSequence(self, *args, **kwargs) -> Any: ...
    def logMessage(self, *args, **kwargs) -> Any: ...
    def noop(self, *args, **kwargs) -> Any: ...
    def pointGalvoAndFire(self, *args, **kwargs) -> Any: ...
    def popNextImage(self, *args, **kwargs) -> Any: ...
    def popNextImageMD(self, Metadatamd) -> Any: ...
    def prepareSequenceAcquisition(self, *args, **kwargs) -> Any: ...
    def readFromSerialPort(self, *args, **kwargs) -> Any: ...
    def registerCallback(self, MMEventCallbackcb) -> Any: ...
    def removeImageSynchro(self, *args, **kwargs) -> Any: ...
    def removeImageSynchroAll(self) -> Any: ...
    def renameConfig(self, *args, **kwargs) -> Any: ...
    def renameConfigGroup(self, *args, **kwargs) -> Any: ...
    def renamePixelSizeConfig(self, *args, **kwargs) -> Any: ...
    def reset(self) -> Any: ...
    def runGalvoPolygons(self, *args, **kwargs) -> Any: ...
    def runGalvoSequence(self, *args, **kwargs) -> Any: ...
    def saveSystemConfiguration(self, *args, **kwargs) -> Any: ...
    def saveSystemState(self, *args, **kwargs) -> Any: ...
    def setAdapterOrigin(self, newZUm: float) -> Any: ...
    def setAdapterOriginXY(self, newXUm: float, newYUm: float) -> Any: ...
    def setAutoFocusDevice(self, *args, **kwargs) -> Any: ...
    def setAutoFocusOffset(self, offset: float) -> Any: ...
    def setAutoShutter(self, state: bool) -> Any: ...
    def setCameraDevice(self, *args, **kwargs) -> Any: ...
    def setChannelGroup(self, *args, **kwargs) -> Any: ...
    def setCircularBufferMemoryFootprint(self, sizeMB: int) -> Any: ...
    def setConfig(self, *args, **kwargs) -> Any: ...
    def setDeviceAdapterSearchPaths(self, paths: Sequence[str]) -> Any: ...
    def setDeviceDelayMs(self, *args, **kwargs) -> Any: ...
    def setExposure(self, exp: float) -> Any: ...
    def setFocusDevice(self, *args, **kwargs) -> Any: ...
    def setFocusDirection(self, *args, **kwargs) -> Any: ...
    def setGalvoDevice(self, *args, **kwargs) -> Any: ...
    def setGalvoIlluminationState(self, *args, **kwargs) -> Any: ...
    def setGalvoPolygonRepetitions(self, *args, **kwargs) -> Any: ...
    def setGalvoPosition(self, *args, **kwargs) -> Any: ...
    def setGalvoSpotInterval(self, *args, **kwargs) -> Any: ...
    def setImageProcessorDevice(self, *args, **kwargs) -> Any: ...
    def setMultiROI(self, *args, **kwargs) -> Any: ...
    def setOrigin(self) -> Any: ...
    def setOriginX(self) -> Any: ...
    def setOriginXY(self) -> Any: ...
    def setOriginY(self) -> Any: ...
    def setParentLabel(self, *args, **kwargs) -> Any: ...
    def setPixelSizeAffine(self, *args, **kwargs) -> Any: ...
    def setPixelSizeConfig(self, *args, **kwargs) -> Any: ...
    def setPixelSizeUm(self, *args, **kwargs) -> Any: ...
    def setPosition(self, position: float) -> Any: ...
    def setPrimaryLogFile(self, *args, **kwargs) -> Any: ...
    def setProperty(self, *args, **kwargs) -> Any: ...
    def setROI(self, x: int, y: int, xSize: int, ySize: int) -> Any: ...
    def setRelativePosition(self, d: float) -> Any: ...
    def setRelativeXYPosition(self, dx: float, dy: float) -> Any: ...
    def setSLMDevice(self, *args, **kwargs) -> Any: ...
    def setSLMExposure(self, *args, **kwargs) -> Any: ...
    def setSLMImage(self, *args, **kwargs) -> Any: ...
    def setSLMPixelsTo(self, *args, **kwargs) -> Any: ...
    def setSerialPortCommand(self, *args, **kwargs) -> Any: ...
    def setSerialProperties(self, *args, **kwargs) -> Any: ...
    def setShutterDevice(self, *args, **kwargs) -> Any: ...
    def setShutterOpen(self, state: bool) -> Any: ...
    def setStageLinearSequence(self, *args, **kwargs) -> Any: ...
    def setState(self, *args, **kwargs) -> Any: ...
    def setStateLabel(self, *args, **kwargs) -> Any: ...
    def setSystemState(self, conf: Configuration) -> Any: ...
    def setTimeoutMs(self, timeoutMs: int) -> Any: ...
    def setXYPosition(self, x: float, y: float) -> Any: ...
    def setXYStageDevice(self, *args, **kwargs) -> Any: ...
    def sleep(self, intervalMs: float) -> Any: ...
    def snapImage(self) -> Any: ...
    def startContinuousSequenceAcquisition(self, intervalMs: float) -> Any: ...
    def startExposureSequence(self, *args, **kwargs) -> Any: ...
    def startPropertySequence(self, *args, **kwargs) -> Any: ...
    def startSLMSequence(self, *args, **kwargs) -> Any: ...
    def startSecondaryLogFile(self, *args, **kwargs) -> Any: ...
    def startSequenceAcquisition(
        self, numImages: int, intervalMs: float, stopOnOverflow: bool
    ) -> Any: ...
    def startStageSequence(self, *args, **kwargs) -> Any: ...
    def startXYStageSequence(self, *args, **kwargs) -> Any: ...
    def stderrLogEnabled(self) -> bool: ...
    def stop(self, *args, **kwargs) -> Any: ...
    def stopExposureSequence(self, *args, **kwargs) -> Any: ...
    def stopPropertySequence(self, *args, **kwargs) -> Any: ...
    def stopSLMSequence(self, *args, **kwargs) -> Any: ...
    def stopSecondaryLogFile(self, handle: int) -> Any: ...
    def stopSequenceAcquisition(self) -> Any: ...
    def stopStageSequence(self, *args, **kwargs) -> Any: ...
    def stopXYStageSequence(self, *args, **kwargs) -> Any: ...
    def supportsDeviceDetection(self, *args, **kwargs) -> Any: ...
    def systemBusy(self) -> bool: ...
    def unloadAllDevices(self) -> Any: ...
    def unloadDevice(self, *args, **kwargs) -> Any: ...
    def unloadLibrary(self, *args, **kwargs) -> Any: ...
    def updateCoreProperties(self) -> Any: ...
    def updateSystemStateCache(self) -> Any: ...
    def usesDeviceDelay(self, *args, **kwargs) -> Any: ...
    def waitForConfig(self, *args, **kwargs) -> Any: ...
    def waitForDevice(self, *args, **kwargs) -> Any: ...
    def waitForDeviceType(self, MM) -> Any: ...
    def waitForImageSynchro(self) -> Any: ...
    def waitForSystem(self) -> Any: ...
    def writeToSerialPort(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class CMMError:
    def __init__(self, *args, **kwargs) -> None: ...
    def getCode(self, *args, **kwargs) -> Any: ...
    def getFullMsg(self, *args, **kwargs) -> Any: ...
    def getMsg(self, *args, **kwargs) -> Any: ...
    def getSpecificCode(self, *args, **kwargs) -> Any: ...
    def getUnderlyingError(self) -> CMMError: ...
    def what(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class Configuration:
    def __init__(self, *args, **kwargs) -> None: ...
    def addSetting(self, setting: PropertySetting) -> Any: ...
    def deleteSetting(self, *args, **kwargs) -> Any: ...
    def getSetting(self, index: int) -> PropertySetting: ...
    def getVerbose(self, *args, **kwargs) -> Any: ...
    def isConfigurationIncluded(self, cfg: Configuration) -> bool: ...
    def isPropertyIncluded(self, *args, **kwargs) -> Any: ...
    def isSettingIncluded(self, ps: PropertySetting) -> bool: ...
    def size(self) -> int: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MMEventCallback:
    def __init__(self, *args, **kwargs) -> None: ...
    def onChannelGroupChanged(self, *args, **kwargs) -> Any: ...
    def onConfigGroupChanged(self, *args, **kwargs) -> Any: ...
    def onExposureChanged(self, *args, **kwargs) -> Any: ...
    def onPixelSizeAffineChanged(
        self, v0: float, v1: float, v2: float, v3: float, v4: float, v5: float
    ) -> Any: ...
    def onPixelSizeChanged(self, newPixelSizeUm: float) -> Any: ...
    def onPropertiesChanged(self) -> Any: ...
    def onPropertyChanged(self, *args, **kwargs) -> Any: ...
    def onSLMExposureChanged(self, *args, **kwargs) -> Any: ...
    def onStagePositionChanged(self, *args, **kwargs) -> Any: ...
    def onSystemConfigurationLoaded(self) -> Any: ...
    def onXYStagePositionChanged(self, *args, **kwargs) -> Any: ...
    def __disown__(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class Metadata:
    def __init__(self, *args, **kwargs) -> None: ...
    def Clear(self) -> Any: ...
    def Dump(self, *args, **kwargs) -> Any: ...
    def GetArrayTag(self, *args, **kwargs) -> Any: ...
    def GetKeys(self) -> Tuple[str]: ...
    def GetSingleTag(self, *args, **kwargs) -> Any: ...
    def HasTag(self, *args, **kwargs) -> Any: ...
    def Merge(self, MetadatanewTags) -> Any: ...
    def RemoveTag(self, *args, **kwargs) -> Any: ...
    def Restore(self, *args, **kwargs) -> Any: ...
    def Serialize(self, *args, **kwargs) -> Any: ...
    def SetTag(self, MetadataTagtag) -> Any: ...
    def readLine(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataArrayTag(MetadataTag):
    def __init__(self, *args, **kwargs) -> None: ...
    def AddValue(self, *args, **kwargs) -> Any: ...
    def Clone(self) -> MetadataTag: ...
    def GetSize(self) -> int: ...
    def GetValue(self, *args, **kwargs) -> Any: ...
    def Restore(self, std) -> bool: ...
    def Serialize(self, *args, **kwargs) -> Any: ...
    def SetValue(self, *args, **kwargs) -> Any: ...
    def ToArrayTag(self) -> MetadataArrayTag: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataError:
    def __init__(self, *args, **kwargs) -> None: ...
    def getMsg(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataIndexError(MetadataError):
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataKeyError(MetadataError):
    def __init__(self, *args, **kwargs) -> None: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataSingleTag(MetadataTag):
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> MetadataTag: ...
    def GetValue(self, *args, **kwargs) -> Any: ...
    def Restore(self, std) -> bool: ...
    def Serialize(self, *args, **kwargs) -> Any: ...
    def SetValue(self, *args, **kwargs) -> Any: ...
    def ToSingleTag(self) -> MetadataSingleTag: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class MetadataTag:
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> MetadataTag: ...
    def GetDevice(self, *args, **kwargs) -> Any: ...
    def GetName(self, *args, **kwargs) -> Any: ...
    def GetQualifiedName(self, *args, **kwargs) -> Any: ...
    def IsReadOnly(self) -> bool: ...
    def ReadLine(self, *args, **kwargs) -> Any: ...
    def Restore(self, std) -> bool: ...
    def Serialize(self, *args, **kwargs) -> Any: ...
    def SetDevice(self, *args, **kwargs) -> Any: ...
    def SetName(self, *args, **kwargs) -> Any: ...
    def SetReadOnly(self, ro: bool) -> Any: ...
    def ToArrayTag(self) -> MetadataArrayTag: ...
    def ToSingleTag(self) -> MetadataSingleTag: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class PropertyBlock:
    def __init__(self, *args, **kwargs) -> None: ...
    def addPair(self, PropertyPairpair) -> Any: ...
    def getPair(self, index: int) -> PropertyPair: ...
    def getValue(self, *args, **kwargs) -> Any: ...
    def size(self) -> int: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class PropertyPair:
    def __init__(self, *args, **kwargs) -> None: ...
    def getPropertyName(self, *args, **kwargs) -> Any: ...
    def getPropertyValue(self, *args, **kwargs) -> Any: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...

class PropertySetting:
    def __init__(self, *args, **kwargs) -> None: ...
    def generateKey(self, *args, **kwargs) -> Any: ...
    def getDeviceLabel(self, *args, **kwargs) -> Any: ...
    def getKey(self, *args, **kwargs) -> Any: ...
    def getPropertyName(self, *args, **kwargs) -> Any: ...
    def getPropertyValue(self, *args, **kwargs) -> Any: ...
    def getReadOnly(self) -> bool: ...
    def getVerbose(self, *args, **kwargs) -> Any: ...
    def isEqualTo(self, PropertySettingps) -> bool: ...
    def __eq__(self, other) -> Any: ...
    def __ge__(self, other) -> Any: ...
    def __gt__(self, other) -> Any: ...
    def __hash__(self) -> Any: ...
    def __le__(self, other) -> Any: ...
    def __lt__(self, other) -> Any: ...
    def __ne__(self, other) -> Any: ...
