# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateLiveToVodTaskRequest(JDCloudRequest):
    """
    创建直播转点播任务
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateLiveToVodTaskRequest, self).__init__(
            '/createLiveToVodTask', 'POST', header, version)
        self.parameters = parameters


class CreateLiveToVodTaskParameters(object):

    def __init__(self, title, fileName, publishDomain, appName, streamName, recordTimes, recordFileType, ):
        """
        :param title: 视频标题
        :param fileName: 文件名称
        :param publishDomain: 推流域名
        :param appName: 应用名称
        :param streamName: 流名称
        :param recordTimes: 录制时间段集合
- 支持自定义1-10个时间段,拼接成一个文件
- 每个时间段不小于10s
- 总跨度不超过12小时
- 时间段按升序排列且无重叠

        :param recordFileType: 录制文件类型:
- 取值: ts, flv, mp4
- 不区分大小写

        """

        self.title = title
        self.fileName = fileName
        self.fileSize = None
        self.coverUrl = None
        self.description = None
        self.categoryId = None
        self.tags = None
        self.transcodeTemplateIds = None
        self.watermarkIds = None
        self.publishDomain = publishDomain
        self.appName = appName
        self.streamName = streamName
        self.recordTimes = recordTimes
        self.recordFileType = recordFileType
        self.taskExternalId = None
        self.priority = None

    def setFileSize(self, fileSize):
        """
        :param fileSize: (Optional) 文件大小
        """
        self.fileSize = fileSize

    def setCoverUrl(self, coverUrl):
        """
        :param coverUrl: (Optional) 封面地址
        """
        self.coverUrl = coverUrl

    def setDescription(self, description):
        """
        :param description: (Optional) 视频描述
        """
        self.description = description

    def setCategoryId(self, categoryId):
        """
        :param categoryId: (Optional) 分类ID
        """
        self.categoryId = categoryId

    def setTags(self, tags):
        """
        :param tags: (Optional) 视频标签集合
        """
        self.tags = tags

    def setTranscodeTemplateIds(self, transcodeTemplateIds):
        """
        :param transcodeTemplateIds: (Optional) 转码模板ID集合
        """
        self.transcodeTemplateIds = transcodeTemplateIds

    def setWatermarkIds(self, watermarkIds):
        """
        :param watermarkIds: (Optional) 水印ID集合
        """
        self.watermarkIds = watermarkIds

    def setTaskExternalId(self, taskExternalId):
        """
        :param taskExternalId: (Optional) 直播录制任务外键
        """
        self.taskExternalId = taskExternalId

    def setPriority(self, priority):
        """
        :param priority: (Optional) 任务优先级:
- 取值: low, medium, high
- 不区分大小写

        """
        self.priority = priority

