# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class SearchLogContextRequest(JDCloudRequest):
    """
    搜索日志上下文
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(SearchLogContextRequest, self).__init__(
            '/regions/{regionId}/logsets/{logsetUID}/logtopics/{logtopicUID}/logcontext', 'POST', header, version)
        self.parameters = parameters


class SearchLogContextParameters(object):

    def __init__(self, regionId, logsetUID, logtopicUID, anchor, id, lineSize, time):
        """
        :param regionId: 地域 Id
        :param logsetUID: 日志集 UID
        :param logtopicUID: 日志主题 UID
        :param anchor: 查询anchor,基于该值偏移进行上下文检索
        :param id: 日志记录ID
        :param lineSize: 查看上下文行数大小，最大支持200
        :param time: 查询日志时返回的时间戳
        """

        self.regionId = regionId
        self.logsetUID = logsetUID
        self.logtopicUID = logtopicUID
        self.anchor = anchor
        self.direction = None
        self.filters = None
        self.id = id
        self.lineSize = lineSize
        self.time = time

    def setDirection(self, direction):
        """
        :param direction: (Optional) 搜索方向,默认both,可取值:up,down,both
        """
        self.direction = direction

    def setFilters(self, filters):
        """
        :param filters: (Optional) 指定返回字段，只对系统日志生效，不填默认按照产品线配置返回字段，Name支持：key，Values填入返回字段
        """
        self.filters = filters

