# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeStackEventsRequest(JDCloudRequest):
    """
    查询资源栈事件列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeStackEventsRequest, self).__init__(
            '/regions/{regionId}/stacks/{stackId}/events', 'GET', header, version)
        self.parameters = parameters


class DescribeStackEventsParameters(object):

    def __init__(self, regionId, stackId, ):
        """
        :param regionId: 地域 ID
        :param stackId: 资源栈 ID
        """

        self.regionId = regionId
        self.stackId = stackId
        self.pageNumber = None
        self.pageSize = None
        self.startTime = None
        self.endTime = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 当前所在页，默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 页面大小，默认为20；取值范围[1, 100]
        """
        self.pageSize = pageSize

    def setStartTime(self, startTime):
        """
        :param startTime: (Optional) 事件开始时间
        """
        self.startTime = startTime

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 事件结束时间
        """
        self.endTime = endTime

