"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmsEncryptionKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_kms_1 = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class KmsEncryptionKey extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.environmentName = (_b = props === null || props === void 0 ? void 0 : props.environmentName) !== null && _b !== void 0 ? _b : 'DEV';
        this.description = this.getKeyName(props === null || props === void 0 ? void 0 : props.description);
        this.keyName = this.getKeyName(props === null || props === void 0 ? void 0 : props.keyName);
        this.kmsKey = new aws_kms_1.Key(this, 'EncryptionKey', {
            alias: this.keyName,
            description: this.description,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            policy: KmsEncryptionKey.createKeyPolicy((_c = props.kmsAdministratorArns) !== null && _c !== void 0 ? _c : []),
        });
        core_1.Tags.of(this).add('environment', this.environmentName);
        core_1.Tags.of(this).add('alias', this.keyName);
    }
    /**
     * @stability stable
     */
    static getArnPrincipals(kmsAdministratorArns) {
        return kmsAdministratorArns.map((arn) => new aws_iam_1.ArnPrincipal(arn));
    }
    /**
     * @stability stable
     */
    static getAdministratorArns(kmsAdministratorArns) {
        return [
            new aws_iam_1.CompositePrincipal(...KmsEncryptionKey.getArnPrincipals(kmsAdministratorArns)),
        ];
    }
    /**
     * @stability stable
     */
    static createKeyPolicy(kmsAdministratorArns) {
        return new aws_iam_1.PolicyDocument({
            statements: [
                new aws_iam_1.PolicyStatement({
                    actions: ['kms:*'],
                    resources: ['*'],
                    principals: KmsEncryptionKey.getAdministratorArns(kmsAdministratorArns),
                }),
            ],
        });
    }
    /**
     * @stability stable
     */
    getKeyName(keyName) {
        return keyName !== null && keyName !== void 0 ? keyName : `${this.environmentName}-kms-encryption-key`;
    }
}
exports.KmsEncryptionKey = KmsEncryptionKey;
_a = JSII_RTTI_SYMBOL_1;
KmsEncryptionKey[_a] = { fqn: "kms-encryption-key.KmsEncryptionKey", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia21zRW5jcnlwdGlvbktleS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9rbXNFbmNyeXB0aW9uS2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsOENBSzBCO0FBQzFCLDhDQUF1QztBQUN2Qyx3Q0FBK0Q7Ozs7QUFTL0QsTUFBYSxnQkFBaUIsU0FBUSxnQkFBUzs7OztJQWtDN0MsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsUUFBK0IsRUFBRTs7UUFFakMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsZUFBZSxTQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxlQUFlLG1DQUFJLEtBQUssQ0FBQztRQUN2RCxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ3ZELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsT0FBTyxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLGFBQUcsQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFO1lBQzNDLEtBQUssRUFBRSxJQUFJLENBQUMsT0FBTztZQUNuQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsYUFBYSxFQUFFLG9CQUFhLENBQUMsTUFBTTtZQUNuQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUMsZUFBZSxPQUN0QyxLQUFLLENBQUMsb0JBQW9CLG1DQUFJLEVBQUUsQ0FDakM7U0FDRixDQUFDLENBQUM7UUFDSCxXQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLGVBQXlCLENBQUMsQ0FBQztRQUNqRSxXQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7SUFwREQsTUFBTSxDQUFDLGdCQUFnQixDQUFDLG9CQUE4QjtRQUNwRCxPQUFPLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsSUFBSSxzQkFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQzs7OztJQUVELE1BQU0sQ0FBQyxvQkFBb0IsQ0FDekIsb0JBQThCO1FBRTlCLE9BQU87WUFDTCxJQUFJLDRCQUFrQixDQUNwQixHQUFHLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDLENBQzNEO1NBQ0YsQ0FBQztJQUNKLENBQUM7Ozs7SUFFRCxNQUFNLENBQUMsZUFBZSxDQUFDLG9CQUE4QjtRQUNuRCxPQUFPLElBQUksd0JBQWMsQ0FBQztZQUN4QixVQUFVLEVBQUU7Z0JBQ1YsSUFBSSx5QkFBZSxDQUFDO29CQUNsQixPQUFPLEVBQUUsQ0FBQyxPQUFPLENBQUM7b0JBQ2xCLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztvQkFDaEIsVUFBVSxFQUFFLGdCQUFnQixDQUFDLG9CQUFvQixDQUMvQyxvQkFBb0IsQ0FDckI7aUJBQ0YsQ0FBQzthQUNIO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7OztJQTRCRCxVQUFVLENBQUMsT0FBZ0I7UUFDekIsT0FBTyxPQUFPLGFBQVAsT0FBTyxjQUFQLE9BQU8sR0FBSSxHQUFHLElBQUksQ0FBQyxlQUFlLHFCQUFxQixDQUFDO0lBQ2pFLENBQUM7O0FBekRILDRDQTBEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIEFyblByaW5jaXBhbCxcbiAgQ29tcG9zaXRlUHJpbmNpcGFsLFxuICBQb2xpY3lEb2N1bWVudCxcbiAgUG9saWN5U3RhdGVtZW50LFxufSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IEtleSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1rbXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBSZW1vdmFsUG9saWN5LCBUYWdzIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgS21zRW5jcnlwdGlvbktleVByb3BzIHtcbiAgcmVhZG9ubHkga2V5TmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkga21zQWRtaW5pc3RyYXRvckFybnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnROYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIEttc0VuY3J5cHRpb25LZXkgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBzdGF0aWMgZ2V0QXJuUHJpbmNpcGFscyhrbXNBZG1pbmlzdHJhdG9yQXJuczogc3RyaW5nW10pOiBBcm5QcmluY2lwYWxbXSB7XG4gICAgcmV0dXJuIGttc0FkbWluaXN0cmF0b3JBcm5zLm1hcCgoYXJuKSA9PiBuZXcgQXJuUHJpbmNpcGFsKGFybikpO1xuICB9XG5cbiAgc3RhdGljIGdldEFkbWluaXN0cmF0b3JBcm5zKFxuICAgIGttc0FkbWluaXN0cmF0b3JBcm5zOiBzdHJpbmdbXSxcbiAgKTogQ29tcG9zaXRlUHJpbmNpcGFsW10ge1xuICAgIHJldHVybiBbXG4gICAgICBuZXcgQ29tcG9zaXRlUHJpbmNpcGFsKFxuICAgICAgICAuLi5LbXNFbmNyeXB0aW9uS2V5LmdldEFyblByaW5jaXBhbHMoa21zQWRtaW5pc3RyYXRvckFybnMpLFxuICAgICAgKSxcbiAgICBdO1xuICB9XG5cbiAgc3RhdGljIGNyZWF0ZUtleVBvbGljeShrbXNBZG1pbmlzdHJhdG9yQXJuczogc3RyaW5nW10pOiBQb2xpY3lEb2N1bWVudCB7XG4gICAgcmV0dXJuIG5ldyBQb2xpY3lEb2N1bWVudCh7XG4gICAgICBzdGF0ZW1lbnRzOiBbXG4gICAgICAgIG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgIGFjdGlvbnM6IFsna21zOionXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgICAgIHByaW5jaXBhbHM6IEttc0VuY3J5cHRpb25LZXkuZ2V0QWRtaW5pc3RyYXRvckFybnMoXG4gICAgICAgICAgICBrbXNBZG1pbmlzdHJhdG9yQXJucyxcbiAgICAgICAgICApLFxuICAgICAgICB9KSxcbiAgICAgIF0sXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgcmVhZG9ubHkga21zS2V5OiBLZXk7XG4gIHB1YmxpYyByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGtleU5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGVudmlyb25tZW50TmFtZT86IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IEttc0VuY3J5cHRpb25LZXlQcm9wcyA9IHt9LFxuICApIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMuZW52aXJvbm1lbnROYW1lID0gcHJvcHM/LmVudmlyb25tZW50TmFtZSA/PyAnREVWJztcbiAgICB0aGlzLmRlc2NyaXB0aW9uID0gdGhpcy5nZXRLZXlOYW1lKHByb3BzPy5kZXNjcmlwdGlvbik7XG4gICAgdGhpcy5rZXlOYW1lID0gdGhpcy5nZXRLZXlOYW1lKHByb3BzPy5rZXlOYW1lKTtcbiAgICB0aGlzLmttc0tleSA9IG5ldyBLZXkodGhpcywgJ0VuY3J5cHRpb25LZXknLCB7XG4gICAgICBhbGlhczogdGhpcy5rZXlOYW1lLFxuICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LlJFVEFJTixcbiAgICAgIHBvbGljeTogS21zRW5jcnlwdGlvbktleS5jcmVhdGVLZXlQb2xpY3koXG4gICAgICAgIHByb3BzLmttc0FkbWluaXN0cmF0b3JBcm5zID8/IFtdLFxuICAgICAgKSxcbiAgICB9KTtcbiAgICBUYWdzLm9mKHRoaXMpLmFkZCgnZW52aXJvbm1lbnQnLCB0aGlzLmVudmlyb25tZW50TmFtZSBhcyBzdHJpbmcpO1xuICAgIFRhZ3Mub2YodGhpcykuYWRkKCdhbGlhcycsIHRoaXMua2V5TmFtZSk7XG4gIH1cblxuICBnZXRLZXlOYW1lKGtleU5hbWU/OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiBrZXlOYW1lID8/IGAke3RoaXMuZW52aXJvbm1lbnROYW1lfS1rbXMtZW5jcnlwdGlvbi1rZXlgO1xuICB9XG59XG4iXX0=