import { ArnPrincipal, CompositePrincipal, PolicyDocument } from '@aws-cdk/aws-iam';
import { Key } from '@aws-cdk/aws-kms';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface KmsEncryptionKeyProps {
    /**
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * @stability stable
     */
    readonly kmsAdministratorArns?: string[];
    /**
     * @stability stable
     */
    readonly environmentName?: string;
    /**
     * @stability stable
     */
    readonly description?: string;
}
/**
 * @stability stable
 */
export declare class KmsEncryptionKey extends Construct {
    /**
     * @stability stable
     */
    static getArnPrincipals(kmsAdministratorArns: string[]): ArnPrincipal[];
    /**
     * @stability stable
     */
    static getAdministratorArns(kmsAdministratorArns: string[]): CompositePrincipal[];
    /**
     * @stability stable
     */
    static createKeyPolicy(kmsAdministratorArns: string[]): PolicyDocument;
    /**
     * @stability stable
     */
    readonly kmsKey: Key;
    /**
     * @stability stable
     */
    readonly description?: string;
    /**
     * @stability stable
     */
    readonly keyName: string;
    /**
     * @stability stable
     */
    readonly environmentName?: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: KmsEncryptionKeyProps);
    /**
     * @stability stable
     */
    getKeyName(keyName?: string): string;
}
