# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AddCreditRequest(JDCloudRequest):
    """
    增加富媒体短信资质接口
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(AddCreditRequest, self).__init__(
            '/regions/{regionId}/addCredit', 'POST', header, version)
        self.parameters = parameters


class AddCreditParameters(object):

    def __init__(self, regionId, appId, name, description, businessLicense, businessLicenseName, signedAuthorization, signedAuthorizationName, informationSecurity, informationSecurityName, membershipCertificate, membershipCertificateName, otherCertificate, otherCertificateName):
        """
        :param regionId: Region ID
        :param appId: 应用ID
        :param name: 资质名称
        :param description: 资质描述
        :param businessLicense: 营业执照图片,必须是jpg图片的base64编码，只支持jpg图片
        :param businessLicenseName: 营业执照名称
        :param signedAuthorization: 签名授权书图片,必须是jpg图片的base64编码，只支持jpg图片
        :param signedAuthorizationName: 签名授权书名称
        :param informationSecurity: 信息安全保障责任书图片,必须是jpg图片的base64编码，只支持jpg图片
        :param informationSecurityName: 信息安全保障责任书名称
        :param membershipCertificate: 会员证明图片,必须是jpg图片的base64编码，只支持jpg图片
        :param membershipCertificateName: 会员证明名称
        :param otherCertificate: 其他证明图片,必须是jpg图片的base64编码，只支持jpg图片
        :param otherCertificateName: 其他证明名称
        """

        self.regionId = regionId
        self.appId = appId
        self.name = name
        self.description = description
        self.businessLicense = businessLicense
        self.businessLicenseName = businessLicenseName
        self.signedAuthorization = signedAuthorization
        self.signedAuthorizationName = signedAuthorizationName
        self.informationSecurity = informationSecurity
        self.informationSecurityName = informationSecurityName
        self.membershipCertificate = membershipCertificate
        self.membershipCertificateName = membershipCertificateName
        self.otherCertificate = otherCertificate
        self.otherCertificateName = otherCertificateName

