# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateSnapshotRequest(JDCloudRequest):
    """
    -   为指定云硬盘创建快照，新生成的快照的状态为creating。
-   同一地域下单用户快照的配额为15块。
-   为保证数据完整性，请您在创建快照之前，停止对云硬盘进行写入操作，以保证快照数据的完整性。
-   在执行创建快照前，建议您对云硬盘进行卸载操作，创建快照后再重新挂载到云主机上。
-   手动快照的生命周期独立于云硬盘，请您及时删除不需要的快照。
-   创建快照所需时间取决于云硬盘容量的大小，云硬盘容量越大耗时越长。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateSnapshotRequest, self).__init__(
            '/regions/{regionId}/snapshots', 'POST', header, version)
        self.parameters = parameters


class CreateSnapshotParameters(object):

    def __init__(self, regionId, snapshotSpec, clientToken):
        """
        :param regionId: 地域ID
        :param snapshotSpec: 创建快照规格
        :param clientToken: 幂等性校验参数
        """

        self.regionId = regionId
        self.snapshotSpec = snapshotSpec
        self.clientToken = clientToken

