# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['portablemc']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['portablemc = portablemc.cli:main']}

setup_kwargs = {
    'name': 'portablemc',
    'version': '2.2.0',
    'description': 'PortableMC is a module that provides both an API for development of your custom launcher and an executable script to run PortableMC CLI.',
    'long_description': '# Portable Minecraft Launcher\nAn easy-to-use portable Minecraft launcher in only one Python script!\nThis single-script launcher is still compatible with the official (Mojang) Minecraft Launcher stored\nin `.minecraft` and use it. The goals are speed and reliability for all Minecraft versions in a \nstateless manner. You can now customize the launcher with addons.\n\n![GitHub release (latest by date)](https://img.shields.io/github/v/release/mindstorm38/portablemc?label=stable&style=flat-square) &nbsp;![GitHub release (latest by date including pre-releases)](https://img.shields.io/github/v/release/mindstorm38/portablemc?include_prereleases&label=preview&style=flat-square) &nbsp;![GitHub all releases](https://img.shields.io/github/downloads/mindstorm38/portablemc/total?label=Github%20downloads&style=flat-square) &nbsp;![PyPI - Downloads](https://img.shields.io/pypi/dm/portablemc?label=PyPI%20downloads&style=flat-square) &nbsp;![Release cycle](https://img.shields.io/badge/Release%20cycle-2%2Fmonth-yellow?style=flat-square)\n\n### [Install now!](#installation) *[Fabric is now supported!](#fabric-support)*\n\n![illustration](doc/assets/illustration.png)\n\n*This launcher is tested for Python 3.6, 3.7, 3.8, 3.9, further testing using other versions are welcome.*\n\n# Table of contents\n- [Installation](#installation)\n  - [Install with PIP](#install-with-pip)\n  - [Single-file script](#single-file-script)\n- [Sub-commands](#sub-commands)\n  - [Start the game](#start-the-game)\n    - [Authentication](#authentication)\n    - [Offline mode](#offline-mode)\n    - [Custom JVM](#custom-jvm)\n    - [Auto connect to a server](#auto-connect-to-a-server)\n    - [Miscellaneous](#miscellaneous)\n  - [Search for versions](#search-for-versions)\n  - [Authentication sessions](#authentication-sessions)\n  - [Addon sub-command](#addon-sub-command)\n- [Addons](#addons)\n  - [Fabric support](#fabric-support)\n  - [Better console](#better-console)\n  - [Archives support](#archives-support)\n  - [Modrinth mod management](#modrinth-mod-management-wip)\n- [Contributors](#contributors)\n- [API Documentation ⇗](doc/API.md)\n- [Addon API Documentation ⇗](doc/ADDON.md)\n\n# Installation\nThe launcher can be installed in several ways, including Python Package Index *(PyPI)* or manually using the \nsingle-file script. Before starting, please check if your Python version is valid for the launcher by doing `python -V`, \nthe version must be greater or equal to 3.6.\n\n## Install with PIP\nThe easiest way to install the launcher is to use the `pip` tool of your Python installation. On some linux distribution \nyou might have to use `pip3` instead of `pip` in order to run it on Python 3. You can also use `python -m pip` you the\n`pip` command is not in the path and the python executable is.\n\n```sh\npip install --user portablemc\n```\n\nWe advise you to keep `--user` because this allows to install the launcher locally, it is implicit if you are not an \nadministrator and if you are, it allows not to modify other users\' installation.\n\nAfter that, you can try to show the launcher help message using `portablemc` in your terminal. If it fails, you must\nensure that the scripts directory is in your user path environment variable. On Windows you have to search for a\ndirectory at `%appdata%/Python/Python3X/Scripts` and add it to the user\'s environment variable `Path`. On UNIX\nsystems this should work properly because the script is put in `~/.local/bin`.\n\n# Single-file script\nOn each release, a single-file script is built and distributed on the [release page](https://github.com/mindstorm38/portablemc/releases).\nThis file has not to be installed, you can just run it using `python portablemc.py [...]`, on UNIX you can start the script\ndirectly with `portablemc.py` because the file has a *[shebang](https://wikipedia.org/wiki/Shebang)*.\n\n# Sub-commands\nArguments are split between multiple sub-commands. For example `<exec> <sub-command>`. You can use `-h` \nargument to display help *(also works for every sub-commands)*.\n\nYou may need to use `--main-dir <path>` if you want to change the main directory of the game. The main\ndirectory stores libraries, assets, versions. **By default** the location\nof this directory is OS-dependent, but always in your user\'s home directory, \n[check wiki for more information](https://minecraft.gamepedia.com/.minecraft).\n\nYou may also need `--work-dir <path>` to change the directory where your saves, resource packs and\nall "user-specific" content is stored. This can be useful if you have a shared read-only main directory \n(`--main-dir`) and user-specific working directory (for example in `~/.minecraft`, by default it\'s the\nlocation of your main directory). This launcher also stores the authentication credentials in this directory\n(since launcher version 1.1.4).\n\nThe two arguments `--main-dir` and `--work-dir` may or may not be used by sub commands, then you can alias\nthe command and always set the main and work directory like you want.\n\nAn advanced argument `--timeout <seconds>` can be used to set a global timeout value that can be freely used\nby the launcher or addons. The special value 0 is often interpreted as "please use the local cache only". For\nnow, it\'s used by the launcher only for the version manifest fetching as it is now locally cached.\n\n## Start the game\nThe `<exec> start [arguments...] [version]` sub-command is used to prepare and launch the game. A lot\nof arguments allow you to control how to game will behave. The only positional argument is the version - \nyou can either specify a full version id (which you can get from the [search](#search-for-versions) \nsub-command), or a type of version to select the latest of this type (`release` (default) or `snapshot`).\n\n### Authentication\nOnline mode is supported by this launcher, use the `-l <email_or_username>` (`--login`) argument to\nlog into your account *(login with a username is deprecated by Mojang)*. If your session is not\ncached nor valid, the launcher will ask for the password.\n\nYou can now use the the `-m` (`--microsoft`) to authenticate a Microsoft account if you already had\nmigrated your account. In this case the launcher will open a page in your web browser with the\nMicrosoft login page.\n\nYou can disable session caching using the argument `-t` (`--temp-login`). If your session is \nnot cached nor valid, you will be asked for the password on every launch.\n\nYou can also use `--anonymise` in order to hide most of your email when printing it to the terminal. For example,\n`foo.bar@gmail.com` will become `f*****r@g***l.com`, this is useful to avoid leaking it when recording or streaming.\nHowever, if you use this, make sure that you either use an alias or a variable with the `-l` argument, for exemple\n`-l $PMC_LOGIN`.\n\n**[Check below](#authentication-sessions) for more information about authentication sessions.**\n\n### Offline mode\nIf you need fake offline accounts you can use `-u <username>` (`--username`) to define the username and/or\n`-i <uuid>` (`--uuid`) to define your player\'s [UUID](https://wikipedia.org/wiki/Universally_unique_identifier).\n\nIf you omit the UUID, a random one is chosen. If you omit the username, the first 8 characters of the UUID\nare used for it. **These two arguments are overwritten by the `-l` (`--login`) argument**.\n\n### Custom JVM\nThe launcher uses Java Virtual Machine to run the game, by default the launcher downloads and uses the official JVM \n[distributed by Mojang](https://launchermeta.mojang.com/v1/products/java-runtime/2ec0cc96c44e5a76b9c8b7c39df7210883d12871/all.json)\nwhich is adapted to the running version. The JVM is installed in a sub-directory called `jvm` inside the main directory. \nYou can change it by providing a path to the `java` binary with the `--jvm <path_to/bin/java>` argument. By default, the\nlauncher starts the JVM with default arguments, these are the following and are the same as the Mojang launcher:\n\n```\n-Xmx2G -XX:+UnlockExperimentalVMOptions -XX:+UseG1GC -XX:G1NewSizePercent=20 -XX:G1ReservePercent=20 -XX:MaxGCPauseMillis=50 -XX:G1HeapRegionSize=32M\n```\n\nYou can change these arguments using the `--jvm-args <args>`, **please always quote your set of arguments**, this set must\nbe one argument for PMC. For example `--jvm-args "-Xmx2G -XX:+UnlockExperimentalVMOptions"`.\n\n### Auto connect to a server\nSince Minecraft 1.6 *(at least, need further tests to confirm)* we can start the game and automatically\nconnect to a server. To do that you can use `-s <addr>` (`--server`) for the server address \n(e.g. `mc.hypixel.net`) and the `-p` (`--server-port`) to specify its port, by default to 25565.\n\n### Miscellaneous\nWith `--dry`, the game is prepared but not started.\n\nWith `--demo` you can enable the [demo mode](https://minecraft.gamepedia.com/Demo_mode) of the game.  \n\nWith `--resol <width>x<height>` you can change the resolution of the game window.\n\nWith `--no-better-logging` flag you can disable the better logging configuration used by the launcher\nto avoid raw XML logging in the terminal.\n\nThe two arguments `--disable-mp` (mp: multiplayer), `--disable-chat` are obvious *(since 1.16)*.\n\n## Search for versions\nThe `<exec> search [-l] [version]` sub-command is used to search for versions. By default, this command\nwill search for official versions available to download, you can instead search for local versions\nusing the `-l` (`--local`) flag. The search string is optional, if not given all official or local\nversions are displayed.\n\n## Authentication sessions\nTwo subcommands allow you to store or logout of sessions: `<exec> login|logout <email_or_username>`.\nThese subcommands don\'t prevent you from using the `-l` (`--login`) argument when starting the game,\nthese are just here to manage the session storage.\n\nA new argument `-m` (`--microsoft`) is available for both subcommands since `1.1.4` for migrated \nMicrosoft accounts.\nThe launcher will open the Microsoft login page (with your email pre-typed in) in your web browser \nand wait until validated. \n\n**Your password is not saved!** Only a token is saved (the official launcher also does that)\nin the file `portablemc_auth.json` in the working directory. In older version of the launcher\n(`< 1.1.4`), this file was `portablemc_tokens` in the main directory, the migration from the old\nfile is automatic and irreversible (the old file is deleted).\n\n## Addon sub-command\nThe `<exec> addon list|dirs|show` sub-commands are used to list and show addons. The `addon dirs` subcommand is used\nto list all directories where you can place the addons\' folders.\n\n# Addons\nOfficially supported addons can be found in the [\'addons\' directory](https://github.com/mindstorm38/portablemc/tree/master/addons).\nTo install addons you have to run `addon dirs` to get all directories where you can place addons.\nTo check if the addons are properly installed, you can use the [\'addon list\' sub-command](#addons).\n\n## Fabric support\n[**Download (1.1.0)**](https://minhaskamal.github.io/DownGit/#/home?url=https://github.com/mindstorm38/portablemc/tree/master/addons/fabric)\n\nFabric is now supported through the addon `fabric`.\n\nThis add-on allows you to start Minecraft using FabricMC directly with the [start sub-command](#start-the-game), \nbut instead of a standard version like `1.16.5` you must use the following pattern: `fabric:<mc-version>`.\nUse `fabric:` to start fabric for latest release, `<mc-version>` can be a version type (`release` or `snapshot`), \nin this case the latest version of this type is selected.\n\nFor example, using the command `portablemc.py start fabric:1.16.5` will download and start the latest FabricMC mod loader for `1.16.5`.\n\nYou can also specify the loader version in addition using the following pattern: `fabric:<mc-version>:<loader-version>`.\n\n***For now, mods must be installed manually in the standard `mods` directory, an additional command to install and \nmanage mods was planed but this is not possible for now due to complex APIs and mods management by Fabric.***\n\n![fabric animation](doc/assets/fabricmc.gif)\n\n## Better console\n[**Download (1.1.0)**](https://downgit.github.io/#/home?url=https://github.com/mindstorm38/portablemc/tree/master/addons/console)\n\nAn addon named `console` can be used to display the Minecraft process\' console, this is useful to debug the game when\nit crashes multiple times, or simply if you can to track what\'s going on.\nAn overview of the console can be seen in the animated image in the fabric section just above, it provides a blue header\nsection with summary of the running session and Minecraft version, output lines are printed bellow it, you can then \nnavigate the output buffer.\n\n## Archives support\n[**Download (1.1.0)**](https://downgit.github.io/#/home?url=https://github.com/mindstorm38/portablemc/tree/master/addons/archives)\n\nAn addon named `archives` allows you to launch archived Minecraft versions.\nThis addon extends the [start sub-command](#start-the-game) and you can use `arc:` prefix, for exemple `start arc:a1.1.1`\nwill download, install and run the Alpha 1.1.1 version from the archives. This addon also extends the `search` subcommand\nwith an argument `--archives` (`-a`) to search versions in the archives.\n\n***This addon is based on all the work done by the [Omniarchive community](https://omniarchive.net/).***\nAll types of archived versions are supported:\n- [Pre-Classic (Rubydung)](https://archive.org/details/Minecraft-JE-Pre-Classic)\n- [Classic](https://archive.org/details/Minecraft-JE-Classic)\n- [Indev](https://archive.org/details/Minecraft-JE-Indev)\n- [Infdev](https://archive.org/details/Minecraft-JE-Infdev)\n- [Alpha](https://archive.org/details/Minecraft-JE-Alpha)\n- [Beta](https://archive.org/details/Minecraft-JE-Beta)\n\n## Modrinth mod management (W.I.P.)\n[**Download (1.0.0-pre3)**](https://downgit.github.io/#/home?url=https://github.com/mindstorm38/portablemc/tree/master/addons/modrinth)\n\nAn addon named `modrinth` that provides a sub-command `modr` to manage mod installation in the `mods` directory used\nby Fabric and Forge mod loaders. This addon is based on the Modrinth API, which is an open-source mods\' distribution\nplatform. Owners choose or not to put their mod on Modrinth so some popular mods cannot be found, but most recent \nones like CaffeineMC\'s mods (sodium, hydrogen) are available. Some Forge mods are also available.\n\nUse the `portablemc modr -h` to get general help message.\n\n# Contributors\nThis launcher would not be as functional without the contributors, and in particular the following for their bug reports\nand suggestions to make the launcher better: [GoodDay360](https://github.com/GoodDay360) and [Ristovski](https://github.com/Ristovski).\n\nThere must be a lot of hidden issues, if you want to contribute you just have to install and test the launcher, and\nreport every issue you encounter, do not hesitate!\n',
    'author': 'Théo Rozier',
    'author_email': 'contact@theorozier.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mindstorm38/portablemc',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
