N9K_C93180YC_EX_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "N9300",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/switches/nexus-9000-series-switches/datasheet-c78-742282.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "N9K-C93180YC-EX", "transceivers": []}
            ],
        }
    ],
}

N9K_C9372PX_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "N9300",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/switches/nexus-9000-series-switches/datasheet-c78-742282.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "N9K-C9372PX", "transceivers": []},
                {"productId": "N9K-C9372PX-E", "transceivers": []},
            ],
        }
    ],
}

WS_C3750_24PS_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "C3750",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/support/switches/catalyst-3750-metro-series-switches/products-release-notes-list.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "WS-C3750-24PS", "transceivers": []}
            ],
        }
    ],
}

ALL_3750S_MODEL = {
    "totalCount": "2",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "C3750",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/support/switches/catalyst-3750-metro-series-switches/products-release-notes-list.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "WS-C3750G-16TD", "transceivers": []},
                {"productId": "WS-C3750-24PS", "transceivers": []},
                {"productId": "WS-C3750-24TS", "transceivers": []},
                {"productId": "WS-C3750-48PS", "transceivers": []},
                {"productId": "WS-C3750-48TS", "transceivers": []},
                {"productId": "WS-C3750G-12S", "transceivers": []},
                {"productId": "WS-C3750G-24PS", "transceivers": []},
                {"productId": "WS-C3750G-24TS", "transceivers": []},
                {"productId": "WS-C3750G-24TS-E1U", "transceivers": []},
                {"productId": "WS-C3750G-24TS-S1U", "transceivers": []},
                {"productId": "WS-C3750G-48PS", "transceivers": []},
                {"productId": "WS-C3750G-48TS", "transceivers": []},
                {"productId": "WS-C3750-24FS-S", "transceivers": []},
                {"productId": "WS-C3750V2-24PS", "transceivers": []},
                {"productId": "WS-C3750V2-24TS", "transceivers": []},
                {"productId": "WS-C3750V2-48PS", "transceivers": []},
                {"productId": "WS-C3750V2-48TS", "transceivers": []},
                {"productId": "WS-C3750V2-24FS-S", "transceivers": []},
                {"productId": "WS-C3750E-24TD", "transceivers": []},
                {"productId": "WS-C3750E-24PD", "transceivers": []},
                {"productId": "WS-C3750E-48TD", "transceivers": []},
                {"productId": "WS-C3750E-48PD", "transceivers": []},
                {"productId": "WS-C3750E-48PDF", "transceivers": []},
                {"productId": "WS-C3750X-12S", "transceivers": []},
                {"productId": "WS-C3750X-24S", "transceivers": []},
                {"productId": "WS-C3750-24WFS", "transceivers": []},
                {"productId": "WS-C3750V2-24FS", "transceivers": []},
            ],
        },
        {
            "productFamily": "C3750X",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/support/switches/catalyst-3750-x-series-switches/tsd-products-support-series-home.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "WS-C3750X-24T", "transceivers": []},
                {"productId": "WS-C3750X-48T", "transceivers": []},
                {"productId": "WS-C3750X-24P", "transceivers": []},
                {"productId": "WS-C3750X-48P", "transceivers": []},
                {"productId": "WS-C3750X-48PF", "transceivers": []},
                {"productId": "WS-C3750X-12S", "transceivers": []},
                {"productId": "WS-C3750X-24S", "transceivers": []},
            ],
        },
    ],
}

XCVR_QSFP_40G_SR_BD = {
    "totalCount": "33",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "C9400",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/switches/catalyst-9400-series-switches/index.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "C9400-SUP-1",
                    "transceivers": [
                        {
                            "tmgId": "23366",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "100m (OM3)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "186",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.6.1",
                            "networkDeviceNotes": None,
                            "releaseId": "627",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "23367",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "150m (OM4)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "186",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.6.1",
                            "networkDeviceNotes": None,
                            "releaseId": "627",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "C9400-SUP-1XL",
                    "transceivers": [
                        {
                            "tmgId": "23368",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "100m (OM3)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "187",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.6.2",
                            "networkDeviceNotes": None,
                            "releaseId": "58",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "23369",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "150m (OM4)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "187",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.6.2",
                            "networkDeviceNotes": None,
                            "releaseId": "58",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "C9400-SUP-1XL-Y",
                    "transceivers": [
                        {
                            "tmgId": "36214",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "100m (OM3)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2041",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.9.1",
                            "networkDeviceNotes": None,
                            "releaseId": "981",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "36215",
                            "productFamilyId": "3",
                            "productFamily": "QSFP40G",
                            "productModelId": "151",
                            "productId": "QSFP-40G-SR-BD",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "QSFP+",
                            "reach": "150m (OM4)",
                            "temperatureRange": "10 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-660083.html",
                            "endOfSale": " ",
                            "dataRate": "40 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2041",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.9.1",
                            "networkDeviceNotes": None,
                            "releaseId": "981",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
            ],
        },
    ],
}

N9K_C93180YC_FX_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "N9300",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/switches/nexus-9000-series-switches/datasheet-c78-742282.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "N9K-C93180YC-FX", "transceivers": []}
            ],
        }
    ],
}

C9300_48S_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "C9300",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/switches/catalyst-9300-series-switches/index.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "C9300-48S", "transceivers": []}
            ],
        }
    ],
}

ISR2951_MODEL = {
    "totalCount": "1",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "ISR2900",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/support/routers/2900-series-integrated-services-routers-isr/tsd-products-support-series-home.html",
            "networkAndTransceiverCompatibility": [
                {"productId": "2951", "transceivers": []}
            ],
        }
    ],
}

ADV_SEARCH_IOS_XE_FET_10G_MODEL = {
    "totalCount": "2",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "C9300",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/switches/catalyst-9300-series-switches/index.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "C9300-NM-8X",
                    "transceivers": [
                        {
                            "tmgId": "18751",
                            "productFamilyId": "12",
                            "productFamily": "SFP10G",
                            "productModelId": "99",
                            "productId": "FET-10G",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP+",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-455693.pdf",
                            "endOfSale": " ",
                            "dataRate": "10 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "670",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.5.1",
                            "networkDeviceNotes": None,
                            "releaseId": "657",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                }
            ],
        },
        {
            "productFamily": "C9300L",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/switches/catalyst-9500-series-switches/data_sheet-c78-738978.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "C9300L-24T-4X",
                    "transceivers": [
                        {
                            "tmgId": "39519",
                            "productFamilyId": "12",
                            "productFamily": "SFP10G",
                            "productModelId": "99",
                            "productId": "FET-10G",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP+",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-455693.pdf",
                            "endOfSale": " ",
                            "dataRate": "10 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1827",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.12.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1641",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "C9300L-48T-4X",
                    "transceivers": [
                        {
                            "tmgId": "39573",
                            "productFamilyId": "12",
                            "productFamily": "SFP10G",
                            "productModelId": "99",
                            "productId": "FET-10G",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP+",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-455693.pdf",
                            "endOfSale": " ",
                            "dataRate": "10 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1828",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.12.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1641",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "C9300L-24P-4X",
                    "transceivers": [
                        {
                            "tmgId": "39627",
                            "productFamilyId": "12",
                            "productFamily": "SFP10G",
                            "productModelId": "99",
                            "productId": "FET-10G",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP+",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-455693.pdf",
                            "endOfSale": " ",
                            "dataRate": "10 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1829",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.12.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1641",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "C9300L-48P-4X",
                    "transceivers": [
                        {
                            "tmgId": "42136",
                            "productFamilyId": "12",
                            "productFamily": "SFP10G",
                            "productModelId": "99",
                            "productId": "FET-10G",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP+",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Duplex Fiber",
                            "media": "MMF",
                            "connectorType": "LC",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/transceiver-modules/data_sheet_c78-455693.pdf",
                            "endOfSale": " ",
                            "dataRate": "10 Gbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1830",
                            "breakoutMode": " ",
                            "osType": "IOS XE",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XE 16.12.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1641",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
    ],
}

ADV_SEARCH_UCS_XR_1GBPS_MODEL = {
    "totalCount": "5",
    "itemPerPage": None,
    "page": None,
    "networkDevices": [
        {
            "productFamily": "UCSB",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/servers-unified-computing/datasheet-c78-741116.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "UCS-FI-M-6324",
                    "transceivers": [
                        {
                            "tmgId": "42449",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "194",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.1(1e)",
                            "networkDeviceNotes": None,
                            "releaseId": "1121",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "42450",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "194",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.1(1e)",
                            "networkDeviceNotes": None,
                            "releaseId": "1121",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "UCS-FI-6332-U",
                    "transceivers": [
                        {
                            "tmgId": "36102",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "195",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.1",
                            "networkDeviceNotes": None,
                            "releaseId": "68",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "UCS-FI-6332-16UP-U",
                    "transceivers": [
                        {
                            "tmgId": "36081",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "196",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "67",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "36083",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "196",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.1",
                            "networkDeviceNotes": None,
                            "releaseId": "68",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "39261",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "196",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v3.1",
                            "networkDeviceNotes": None,
                            "releaseId": "68",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "N10-S6100",
                    "transceivers": [
                        {
                            "tmgId": "3819",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "905",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4340",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "905",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8300",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "905",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "N10-S6200",
                    "transceivers": [
                        {
                            "tmgId": "3820",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "906",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4341",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "906",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8301",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "906",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "N10-E0440",
                    "transceivers": [
                        {
                            "tmgId": "3821",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "907",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4342",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "907",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8302",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "907",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "N10-E0600",
                    "transceivers": [
                        {
                            "tmgId": "3822",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "908",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4343",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "908",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8303",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "908",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "N20-I6584",
                    "transceivers": [
                        {
                            "tmgId": "3823",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "909",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4344",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "909",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8304",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "909",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v1.3",
                            "networkDeviceNotes": None,
                            "releaseId": "258",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "UCS-FI-6248UP",
                    "transceivers": [
                        {
                            "tmgId": "3824",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "910",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4345",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "910",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8305",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "910",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "UCS-FI-E16UP",
                    "transceivers": [
                        {
                            "tmgId": "3825",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "911",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4346",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "911",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8306",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "911",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "UCS-IOM-2208XP",
                    "transceivers": [
                        {
                            "tmgId": "3826",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "912",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4347",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "912",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8307",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "912",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v2.0(1)",
                            "networkDeviceNotes": None,
                            "releaseId": "259",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "UCS-FI-6454",
                    "transceivers": [
                        {
                            "tmgId": "29789",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1423",
                            "breakoutMode": " ",
                            "osType": "UCS",
                            "domSupport": " ",
                            "softReleaseMinVer": "UCS Manager v4.0(1a)",
                            "networkDeviceNotes": None,
                            "releaseId": "2361",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
        {
            "productFamily": "NCS5000",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/routers/network-convergence-system-5000-series/index.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "NCS 5001",
                    "transceivers": [
                        {
                            "tmgId": "4440",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1017",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.0.0",
                            "networkDeviceNotes": None,
                            "releaseId": "329",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS 5002",
                    "transceivers": [
                        {
                            "tmgId": "4441",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1018",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.0.0",
                            "networkDeviceNotes": None,
                            "releaseId": "329",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
        {
            "productFamily": "NCS5500",
            "networkFamilyDataSheet": "http://www.cisco.com/c/en/us/products/routers/network-convergence-system-5500-series/index.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "NC55-24H12F-SE",
                    "transceivers": [
                        {
                            "tmgId": "40027",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": " ",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "210",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.3.2",
                            "networkDeviceNotes": None,
                            "releaseId": "359",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-5501",
                    "transceivers": [
                        {
                            "tmgId": "4442",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "212",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.1.1",
                            "networkDeviceNotes": None,
                            "releaseId": "93",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-5501-SE",
                    "transceivers": [
                        {
                            "tmgId": "4443",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "213",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.1.1",
                            "networkDeviceNotes": None,
                            "releaseId": "93",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NC55-MOD-A-S",
                    "transceivers": [
                        {
                            "tmgId": "30334",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1461",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.1",
                            "networkDeviceNotes": None,
                            "releaseId": "782",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-55A2-MOD-S",
                    "transceivers": [
                        {
                            "tmgId": "30482",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1481",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.1",
                            "networkDeviceNotes": None,
                            "releaseId": "782",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NC55-MOD-A-SE-S",
                    "transceivers": [
                        {
                            "tmgId": "35275",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1901",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.6.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1701",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-55A2-MOD-HD-S",
                    "transceivers": [
                        {
                            "tmgId": "35372",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1921",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.1",
                            "networkDeviceNotes": None,
                            "releaseId": "782",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-55A2-MOD-SE-S",
                    "transceivers": [
                        {
                            "tmgId": "38120",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2241",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.6.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1701",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-55A2-MOD-HX-S",
                    "transceivers": [
                        {
                            "tmgId": "40066",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2401",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.1",
                            "networkDeviceNotes": None,
                            "releaseId": "782",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "NCS-55A2-MOD-SE-H-S",
                    "transceivers": [
                        {
                            "tmgId": "40113",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2402",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.6.1",
                            "networkDeviceNotes": None,
                            "releaseId": "1701",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
        {
            "productFamily": "ASR9000",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/routers/asr-9000-series-aggregation-services-routers/datasheet-listing.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "A9K-40GE-B",
                    "transceivers": [
                        {
                            "tmgId": "8390",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "251",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-40GE-E",
                    "transceivers": [
                        {
                            "tmgId": "8391",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "252",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-2T20GE-B",
                    "transceivers": [
                        {
                            "tmgId": "8392",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "253",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-2T20GE-E",
                    "transceivers": [
                        {
                            "tmgId": "8393",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "254",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-2T20GE-L",
                    "transceivers": [
                        {
                            "tmgId": "8394",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "255",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-40GE-L",
                    "transceivers": [
                        {
                            "tmgId": "8395",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "256",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 3.9.0",
                            "networkDeviceNotes": None,
                            "releaseId": "673",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-MPA-20X1GE",
                    "transceivers": [
                        {
                            "tmgId": "4473",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "257",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "36524",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "257",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.0.1",
                            "networkDeviceNotes": None,
                            "releaseId": "92",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8398",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "257",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.2.0",
                            "networkDeviceNotes": None,
                            "releaseId": "573",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "36534",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "257",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.0.1",
                            "networkDeviceNotes": None,
                            "releaseId": "92",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-40GE-TR",
                    "transceivers": [
                        {
                            "tmgId": "4469",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "511",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.4",
                            "networkDeviceNotes": None,
                            "releaseId": "395",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8388",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "511",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-40GE-SE",
                    "transceivers": [
                        {
                            "tmgId": "4470",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "512",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.4",
                            "networkDeviceNotes": None,
                            "releaseId": "395",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8389",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "512",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-4T16GE-TR",
                    "transceivers": [
                        {
                            "tmgId": "4471",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "513",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.4",
                            "networkDeviceNotes": None,
                            "releaseId": "395",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8396",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "513",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "73",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-4T16GE-SE",
                    "transceivers": [
                        {
                            "tmgId": "4472",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "514",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.4",
                            "networkDeviceNotes": None,
                            "releaseId": "395",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8397",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "514",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "73",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-RSP440-TR",
                    "transceivers": [
                        {
                            "tmgId": "37615",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "515",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-RSP440-SE",
                    "transceivers": [
                        {
                            "tmgId": "4474",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "516",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "ASR-9000V-AC",
                    "transceivers": [
                        {
                            "tmgId": "4478",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "520",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8400",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "520",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "ASR-9000V-DC-A",
                    "transceivers": [
                        {
                            "tmgId": "4480",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "521",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8401",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "521",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "ASR-9000V-DC-E",
                    "transceivers": [
                        {
                            "tmgId": "4482",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "522",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8402",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "522",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "ASR-9000V-24-A",
                    "transceivers": [
                        {
                            "tmgId": "3915",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "140",
                            "productId": "GLC-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "0 to 70C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "523",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.2.3",
                            "networkDeviceNotes": None,
                            "releaseId": "398",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4483",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "523",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.0",
                            "networkDeviceNotes": None,
                            "releaseId": "399",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4484",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "523",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8403",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "523",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9KV-V2-AC",
                    "transceivers": [
                        {
                            "tmgId": "4485",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "524",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.0",
                            "networkDeviceNotes": None,
                            "releaseId": "399",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4486",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "524",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8404",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "524",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9KV-V2-DC-A",
                    "transceivers": [
                        {
                            "tmgId": "4487",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "525",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.0",
                            "networkDeviceNotes": None,
                            "releaseId": "399",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4488",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "525",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8405",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "525",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9KV-V2-DC-E",
                    "transceivers": [
                        {
                            "tmgId": "4489",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "526",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.0",
                            "networkDeviceNotes": None,
                            "releaseId": "399",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "4490",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "526",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                        {
                            "tmgId": "8406",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "197",
                            "productId": "SFP-GE-T",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": "Y",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "526",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 4.3.0",
                            "networkDeviceNotes": None,
                            "releaseId": "400",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        },
                    ],
                },
                {
                    "productId": "A9K-24X10GE-1G-SE",
                    "transceivers": [
                        {
                            "tmgId": "36933",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1061",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "85",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-24X10GE-1G-TR",
                    "transceivers": [
                        {
                            "tmgId": "36974",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1062",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "85",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-48X10GE-1G-SE",
                    "transceivers": [
                        {
                            "tmgId": "37059",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1063",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "85",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-48X10GE-1G-TR",
                    "transceivers": [
                        {
                            "tmgId": "37017",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1064",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "85",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A9K-RSP440-LT",
                    "transceivers": [
                        {
                            "tmgId": "37617",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "0",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2161",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 5.2.2",
                            "networkDeviceNotes": None,
                            "releaseId": "90",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A99-48X10GE-1G-SE",
                    "transceivers": [
                        {
                            "tmgId": "43693",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2801",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.2",
                            "networkDeviceNotes": None,
                            "releaseId": "1661",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "A99-48X10GE-1G-TR",
                    "transceivers": [
                        {
                            "tmgId": "43778",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "10BASE-T, 100BASE-T, 1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2802",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.5.2",
                            "networkDeviceNotes": None,
                            "releaseId": "1661",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
        {
            "productFamily": "NCS540",
            "networkFamilyDataSheet": "https://www.cisco.com/c/en/us/products/collateral/routers/network-convergence-system-500-series-routers/datasheet-c78-740296.html",
            "networkAndTransceiverCompatibility": [
                {
                    "productId": "N540-24Z8Q2C-SYS",
                    "transceivers": [
                        {
                            "tmgId": "29609",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "1021",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.3.2",
                            "networkDeviceNotes": None,
                            "releaseId": "359",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "N540-ACC-SYS",
                    "transceivers": [
                        {
                            "tmgId": "29673",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2181",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.3.2",
                            "networkDeviceNotes": None,
                            "releaseId": "359",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "N540X-ACC-SYS",
                    "transceivers": [
                        {
                            "tmgId": "37655",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2182",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.3.2",
                            "networkDeviceNotes": None,
                            "releaseId": "359",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
                {
                    "productId": "N540-24Z8Q2C-M",
                    "transceivers": [
                        {
                            "tmgId": "42674",
                            "productFamilyId": "11",
                            "productFamily": "SFPGE",
                            "productModelId": "141",
                            "productId": "GLC-TE",
                            "version": " ",
                            "versionId": None,
                            "description": None,
                            "formFactor": "SFP",
                            "reach": "100m",
                            "temperatureRange": "-5 to 85C",
                            "digitalDiagnostic": "N",
                            "cableType": "Cat5e/6A",
                            "media": "Copper",
                            "connectorType": "RJ-45",
                            "transmissionStandard": "1000BASE-T",
                            "transceiverModelDataSheet": "https://www.cisco.com/c/en/us/products/collateral/interfaces-modules/gigabit-ethernet-gbic-sfp-modules/product_data_sheet0900aecd8033f885.html",
                            "endOfSale": " ",
                            "dataRate": "10/100/1000 Mbps",
                            "transceiverNotes": None,
                            "noteCount": "1",
                            "state": None,
                            "stateMessage": None,
                            "updatedOn": None,
                            "updatedBy": None,
                            "transceiverBusinessUnit": "TMG",
                            "networkModelId": "2641",
                            "breakoutMode": " ",
                            "osType": "IOS XR",
                            "domSupport": " ",
                            "softReleaseMinVer": "IOS XR 6.3.2",
                            "networkDeviceNotes": None,
                            "releaseId": "359",
                            "softReleaseDOM": "—",
                            "type": "Optic",
                        }
                    ],
                },
            ],
        },
    ],
}
