
# kitchen_sink schema


Kitchen Sink Schema

This schema does not do anything useful. It exists to test all features of linkml.

This particular text field exists to demonstrate markdown within a text field:

Lists:

   * a
   * b
   * c

And links, e.g to [Person](Person.md)


### Records

 * [Address](Address.md)
 * [CodeSystem](CodeSystem.md)
 * [Concept](Concept.md)
     * [DiagnosisConcept](DiagnosisConcept.md)
     * [ProcedureConcept](ProcedureConcept.md)
 * [Dataset](Dataset.md)
 * [Event](Event.md)
     * [BirthEvent](BirthEvent.md)
     * [EmploymentEvent](EmploymentEvent.md)
     * [MarriageEvent](MarriageEvent.md)
     * [MedicalEvent](MedicalEvent.md)
 * [FakeClass](FakeClass.md)
 * [Friend](Friend.md)
 * [Organization](Organization.md)
     * [Company](Company.md)
 * [Person](Person.md) - A person, living or dead
 * [Place](Place.md)
 * [Relationship](Relationship.md)
     * [FamilialRelationship](FamilialRelationship.md)
 * [Activity](Activity.md) - a provence-generating activity
 * [Agent](Agent.md) - a provence-generating agent
 * [ClassWithSpaces](ClassWithSpaces.md)
     * [SubclassTest](SubclassTest.md)

### Traits

 * [HasAliases](HasAliases.md)
 * [WithLocation](WithLocation.md)

### Fields

 * [acted on behalf of](acted_on_behalf_of.md)
 * [activity set](activity_set.md)
 * [addresses](addresses.md)
 * [age in years](age_in_years.md) - number of years since birth
 * [agent set](agent_set.md)
 * [city](city.md)
 * [➞slot with space 1](classWithSpaces__slot_with_space_1.md)
 * [➞ceo](company__ceo.md)
 * [➞activities](dataset__activities.md)
 * [➞code systems](dataset__code_systems.md)
 * [➞companies](dataset__companies.md)
 * [➞persons](dataset__persons.md)
 * [description](description.md)
 * [diagnosis](diagnosis.md)
 * [employed at](employed_at.md)
 * [ended at time](ended_at_time.md)
 * [➞test_attribute](fakeClass__test_attribute.md)
 * [has birth event](has_birth_event.md)
 * [has employment history](has_employment_history.md)
 * [has familial relationships](has_familial_relationships.md)
 * [has marriage history](has_marriage_history.md)
 * [has medical history](has_medical_history.md)
 * [➞aliases](hasAliases__aliases.md)
 * [id](id.md)
 * [in code system](in_code_system.md)
 * [in location](in_location.md)
 * [is current](is_current.md)
 * [married to](married_to.md)
 * [name](name.md)
     * [Person➞name](Person_name.md)
 * [procedure](procedure.md)
 * [related to](related_to.md)
     * [FamilialRelationship➞related to](FamilialRelationship_related_to.md)
 * [started at time](started_at_time.md)
 * [street](street.md)
 * [➞slot with space 2](subclassTest__slot_with_space_2.md)
 * [type](type.md)
     * [EmploymentEvent➞type](EmploymentEvent_type.md)
     * [FamilialRelationship➞type](FamilialRelationship_type.md)
 * [used](used.md)
 * [was associated with](was_associated_with.md)
 * [was generated by](was_generated_by.md)
 * [was informed by](was_informed_by.md)

### Enums

 * [DiagnosisType](DiagnosisType.md)
 * [EmploymentEventType](EmploymentEventType.md) - codes for different kinds of employment/HR related events
 * [FamilialRelationshipType](FamilialRelationshipType.md)
 * [other codes](other codes.md)

### Subsets

 * [SubsetA](SubsetA.md) - test subset A
 * [SubsetB](SubsetB.md) - test subset B

### Types


#### Built in

 * **Bool**
 * **Decimal**
 * **ElementIdentifier**
 * **NCName**
 * **NodeIdentifier**
 * **URI**
 * **URIorCURIE**
 * **XSDDate**
 * **XSDDateTime**
 * **XSDTime**
 * **float**
 * **int**
 * **str**

#### Defined

 * [AgeInYearsType](AgeInYearsType.md)  (**int**) 
 * [Boolean](Boolean.md)  (**Bool**)  - A binary (true or false) value
 * [Date](Date.md)  (**XSDDate**)  - a date (year, month and day) in an idealized calendar
 * [Datetime](Datetime.md)  (**XSDDateTime**)  - The combination of a date and time
 * [Decimal](Decimal.md)  (**Decimal**)  - A real number with arbitrary precision that conforms to the xsd:decimal specification
 * [Double](Double.md)  (**float**)  - A real number that conforms to the xsd:double specification
 * [Float](Float.md)  (**float**)  - A real number that conforms to the xsd:float specification
 * [Integer](Integer.md)  (**int**)  - An integer
 * [Ncname](Ncname.md)  (**NCName**)  - Prefix part of CURIE
 * [Nodeidentifier](Nodeidentifier.md)  (**NodeIdentifier**)  - A URI, CURIE or BNODE that represents a node in a model.
 * [Objectidentifier](Objectidentifier.md)  (**ElementIdentifier**)  - A URI or CURIE that represents an object in the model.
 * [PhoneNumberType](PhoneNumberType.md)  (**str**) 
 * [String](String.md)  (**str**)  - A character string
 * [Time](Time.md)  (**XSDTime**)  - A time object represents a (local) time of day, independent of any particular day
 * [Uri](Uri.md)  (**URI**)  - a complete URI
 * [Uriorcurie](Uriorcurie.md)  (**URIorCURIE**)  - a URI or a CURIE
