
# Slot: treats


holds between a therapeutic procedure or chemical substance and a disease or phenotypic feature that it is used to treat

URI: [biolink:treats](https://w3id.org/biolink/vocab/treats)


## Domain and Range

[ChemicalOrDrugOrTreatment](ChemicalOrDrugOrTreatment.md) &#8594;  <sub>0..\*</sub> [DiseaseOrPhenotypicFeature](DiseaseOrPhenotypicFeature.md)

## Parents

 *  is_a: [ameliorates](ameliorates.md)

## Children

 *  [approved to treat](approved_to_treat.md)

## Used by


## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | is substance that treats |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | DRUGBANK:treats |
|  | | SEMMEDDB:TREATS |
|  | | SEMMEDDB:treats |
|  | | WIKIDATA_PROPERTY:P2175 |
| **Narrow Mappings:** | | RO:0002606 |
|  | | NCIT:regimen_has_accepted_use_for_disease |
|  | | REPODB:clinically_tested_approved_unknown_phase |
|  | | REPODB:clinically_tested_suspended_phase_0 |
|  | | REPODB:clinically_tested_suspended_phase_1 |
|  | | REPODB:clinically_tested_suspended_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_suspended_phase_2 |
|  | | REPODB:clinically_tested_suspended_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_suspended_phase_3 |
|  | | REPODB:clinically_tested_terminated_phase_0 |
|  | | REPODB:clinically_tested_terminated_phase_1 |
|  | | REPODB:clinically_tested_terminated_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_terminated_phase_2 |
|  | | REPODB:clinically_tested_terminated_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_terminated_phase_3 |
|  | | REPODB:clinically_tested_withdrawn_phase_0 |
|  | | REPODB:clinically_tested_withdrawn_phase_1 |
|  | | REPODB:clinically_tested_withdrawn_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_withdrawn_phase_2 |
|  | | REPODB:clinically_tested_withdrawn_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_withdrawn_phase_3 |
|  | | RTXKG1:indicated_for |
|  | | SNOMED:plays_role |
| **Broad Mappings:** | | RO:0003307 |
| **Related Mappings:** | | MONDO:disease_responds_to |

