
# Slot: id


A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI

URI: [biolink:sequence_variant_id](https://w3id.org/biolink/vocab/sequence_variant_id)


## Domain and Range

[SequenceVariant](SequenceVariant.md) &#8594;  <sub>1..1</sub> [String](types/String.md)

## Parents

 *  is_a: [id](id.md)

## Children


## Used by

 * [SequenceVariant](SequenceVariant.md)
 * [Snv](Snv.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Examples:** | | Example(value='ZFIN:ZDB-ALT-980203-1091', description='ti282a allele from ZFIN') |
|  | | Example(value='ClinVarVariant:17681', description='NM_007294.3(BRCA1):c.2521C>T (p.Arg841Trp)') |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | alliancegenome:primaryId |
|  | | gff3:ID |
|  | | gpi:DB_Object_ID |

