
# Slot: sequence localization attribute


An attribute that can be applied to a genome sequence localization edge. These edges connect a genomic entity such as an exon to an entity such as a chromosome. Edge properties are used to ascribe specific positional information and other metadata to the localization. In pragmatic terms this can be thought of as columns in a GFF3 line.

URI: [biolink:sequence_localization_attribute](https://w3id.org/biolink/vocab/sequence_localization_attribute)


## Domain and Range

[GenomicSequenceLocalization](GenomicSequenceLocalization.md) &#8594;  <sub>0..1</sub> [String](types/String.md)

## Parents

 *  is_a: [association slot](association_slot.md)

## Children

 *  [genome build](genome_build.md)
 *  [interbase coordinate](interbase_coordinate.md)
 *  [phase](phase.md)
 *  [strand](strand.md)

## Used by

