
# Slot: related to


A relationship that is asserted between two named things

URI: [biolink:related_to](https://w3id.org/biolink/vocab/related_to)


## Domain and Range

[NamedThing](NamedThing.md) &#8594;  <sub>0..\*</sub> [NamedThing](NamedThing.md)

## Parents


## Children

 *  [affected by](affected_by.md)
 *  [affects](affects.md)
 *  [affects risk for](affects_risk_for.md)
 *  [broad match](broad_match.md)
 *  [caused by](caused_by.md)
 *  [close match](close_match.md)
 *  [coexists with](coexists_with.md)
 *  [contraindicated for](contraindicated_for.md)
 *  [contributes to](contributes_to.md)
 *  [contributor](contributor.md)
 *  [correlated with](correlated_with.md)
 *  [derives from](derives_from.md)
 *  [derives into](derives_into.md)
 *  [develops from](develops_from.md)
 *  [disease has basis in](disease_has_basis_in.md)
 *  [expressed in](expressed_in.md)
 *  [expresses](expresses.md)
 *  [gene product of](gene_product_of.md)
 *  [genetic association](genetic_association.md)
 *  [has completed](has_completed.md)
 *  [has decreased amount](has_decreased_amount.md)
 *  [has gene product](has_gene_product.md)
 *  [has increased amount](has_increased_amount.md)
 *  [has molecular consequence](has_molecular_consequence.md)
 *  [has not completed](has_not_completed.md)
 *  [has participant](has_participant.md)
 *  [has phenotype](has_phenotype.md)
 *  [has sequence location](has_sequence_location.md)
 *  [in linkage disequilibrium with](in_linkage_disequilibrium_with.md)
 *  [in taxon](in_taxon.md)
 *  [interacts with](interacts_with.md)
 *  [is sequence variant of](is_sequence_variant_of.md)
 *  [lacks part](lacks_part.md)
 *  [located in](located_in.md)
 *  [location of](location_of.md)
 *  [manifestation of](manifestation_of.md)
 *  [narrow match](narrow_match.md)
 *  [occurs in](occurs_in.md)
 *  [opposite of](opposite_of.md)
 *  [overlaps](overlaps.md)
 *  [participates in](participates_in.md)
 *  [phenotype of](phenotype_of.md)
 *  [prevented by](prevented_by.md)
 *  [produced by](produced_by.md)
 *  [produces](produces.md)
 *  [related condition](related_condition.md)
 *  [similar to](similar_to.md)
 *  [subclass of](subclass_of.md)
 *  [superclass of](superclass_of.md)
 *  [temporally related to](temporally_related_to.md)
 *  [transcribed from](transcribed_from.md)
 *  [transcribed to](transcribed_to.md)
 *  [translates to](translates_to.md)
 *  [translation of](translation_of.md)
 *  [treated by](treated_by.md)

## Used by


## Other properties

|  |  |  |
| --- | --- | --- |
| **Exact Mappings:** | | skos:relatedMatch |
|  | | SEMMEDDB:ASSOCIATED_WITH |
|  | | SEMMEDDB:associated_with |
|  | | UMLS:related_to |
| **Narrow Mappings:** | | SEMMEDDB:compared_with |
|  | | SEMMEDDB:higher_than |
|  | | SEMMEDDB:lower_than |
|  | | BFO:0000054 |
|  | | UBERON_CORE:protects |
|  | | GOREL:0002005 |
|  | | GOREL:0012006 |
|  | | BFO:0000068 |
|  | | BFO:0000069 |
|  | | BTO:related_to |
|  | | CHEBI:is_conjugate_acid_of |
|  | | CHEBI:is_conjugate_base_of |
|  | | CPT:has_add_on_code |
|  | | CPT:mapped_to |
|  | | EFO:0006351 |
|  | | FMA:connected_to |
|  | | FMA:continuous_with |
|  | | FMA:homonym_of |
|  | | FMA:related_developmental_entity_of |
|  | | RO:0002093 |
|  | | RO:0002092 |
|  | | RO:0002084 |
|  | | GOREL:0002005 |
|  | | GOREL:0012006 |
|  | | HCPCS:mapped_to |
|  | | HMDB:disease |
|  | | HMDB:has_protein_association |
|  | | IAO:0000136 |
|  | | LOINC:has_answer |
|  | | LOINC:has_challenge |
|  | | LOINC:has_evaluation |
|  | | LOINC:mapped_to |
|  | | LOINC:mth_has_expanded_form |
|  | | MESH:RO |
|  | | MESH:has_mapping_qualifier |
|  | | MESH:mapped_to |
|  | | MONDO:disease_shares_features_of |
|  | | NCIT:disease_may_have_associated_disease |
|  | | NCIT:human_disease_maps_to_eo_disease |
|  | | NCIT:is_abnormal_cell_of_disease |
|  | | NCIT:is_related_to_endogenous_product |
|  | | OBO:core#connected_to |
|  | | OBO:core#innervated_by |
|  | | OBO:envo#has_increased_levels_of |
|  | | OBO:has_role |
|  | | OBO:nbo#is_about |
|  | | RO:0000053 |
|  | | PATO-PROPERTY:decreased_in_magnitude_relative_to |
|  | | PATO-PROPERTY:has_cross_section |
|  | | PATO-PROPERTY:has_relative_magnitude |
|  | | PATO-PROPERTY:increased_in_magnitude_relative_to |
|  | | PATO-PROPERTY:reciprocal_of |
|  | | RO:0000052 |
|  | | RO:0002001 |
|  | | RO:0002002 |
|  | | RO:0002003 |
|  | | RO:0002008 |
|  | | RO:0002134 |
|  | | RO:0002150 |
|  | | RO:0002159 |
|  | | RO:0002176 |
|  | | RO:0002177 |
|  | | RO:0002178 |
|  | | RO:0002179 |
|  | | RO:0002314 |
|  | | RO:0002322 |
|  | | RO:0002328 |
|  | | RO:0002332 |
|  | | RO:0002338 |
|  | | RO:0002339 |
|  | | RO:0002341 |
|  | | RO:0002342 |
|  | | RO:0002344 |
|  | | RO:0002348 |
|  | | RO:0002349 |
|  | | RO:0002356 |
|  | | RO:0002371 |
|  | | RO:0002372 |
|  | | RO:0002373 |
|  | | RO:0002374 |
|  | | RO:0002385 |
|  | | RO:0002387 |
|  | | RO:0002451 |
|  | | RO:0002494 |
|  | | RO:0002495 |
|  | | RO:0002568 |
|  | | RO:0002573 |
|  | | RO:0004026 |
|  | | RO:0004027 |
|  | | RO:0009001 |
|  | | RO:0009004 |
|  | | RTXKG1:functionally_related_to |
|  | | RXNORM:has_form |
|  | | RXNORM:reformulated_to |
|  | | SNOMED:has_associated_morphology |
|  | | SNOMED:has_associated_procedure |
|  | | SNOMED:has_direct_morphology |
|  | | SNOMED:has_disposition |
|  | | SNOMED:has_indirect_morphology |
|  | | SNOMED:has_modification |
|  | | SNOMED:has_procedure_morphology |
|  | | SNOMED:has_specimen_source_morphology |
|  | | SNOMED:inheres_in |
|  | | SNOMED:is_interpreted_by |
|  | | SNOMED:relative_to_part_of |
|  | | UBERON:synapsed_by |
|  | | UMLS:RO |
|  | | UMLS:RQ |
|  | | UMLS:class_code_classified_by |
|  | | UMLS:exhibited_by |
|  | | UMLS:has_context_binding |
|  | | UMLS:has_form |
|  | | UMLS:has_mapping_qualifier |
|  | | UMLS:larger_than |
|  | | UMLS:mapped_to |
|  | | UMLS:owning_section_of |
| **Broad Mappings:** | | owl:topObjectProperty |

