
# Slot: type


Ontology term for publication type may be drawn from Dublin Core types (https://www.dublincore.org/specifications/dublin-core/dcmi-type-vocabulary/), FRBR-aligned Bibliographic Ontology (https://sparontologies.github.io/fabio/current/fabio.html), the MESH publication types (https://www.nlm.nih.gov/mesh/pubtypes.html), the Confederation of Open Access Repositories (COAR) Controlled Vocabulary for Resource Type Genres (http://vocabularies.coar-repositories.org/documentation/resource_types/), Wikidata (https://www.wikidata.org/wiki/Wikidata:Publication_types), or equivalent publication type ontology. When a given publication type ontology term is used within a given knowledge graph, then the CURIE identified term must be documented in the graph as a concept node of biolink:category biolink:OntologyClass.

URI: [biolink:publication_type](https://w3id.org/biolink/vocab/publication_type)


## Domain and Range

[Publication](Publication.md) &#8594;  <sub>1..1</sub> [String](types/String.md)

## Parents

 *  is_a: [type](type.md)

## Children

 *  [book➞type](book_type.md)
 *  [serial➞type](serial_type.md)

## Used by

 * [Article](Article.md)
 * [BookChapter](BookChapter.md)
 * [Publication](Publication.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Mappings:** | | dct:type |
| **Exact Mappings:** | | alliancegenome:soTermId |
|  | | gff3:type |
|  | | gpi:DB_Object_Type |

