
# Slot: predicate


A high-level grouping for the relationship type. AKA minimal predicate. This is analogous to category for nodes.

URI: [biolink:predicate](https://w3id.org/biolink/vocab/predicate)


## Domain and Range

[Association](Association.md) &#8594;  <sub>1..1</sub> [PredicateType](types/PredicateType.md)

## Parents

 *  is_a: [association slot](association_slot.md)

## Children

 *  [anatomical entity to anatomical entity ontogenic association➞predicate](anatomical_entity_to_anatomical_entity_ontogenic_association_predicate.md)
 *  [anatomical entity to anatomical entity part of association➞predicate](anatomical_entity_to_anatomical_entity_part_of_association_predicate.md)
 *  [chemical to chemical derivation association➞predicate](chemical_to_chemical_derivation_association_predicate.md)
 *  [contributor association➞predicate](contributor_association_predicate.md)
 *  [gene regulatory relationship➞predicate](gene_regulatory_relationship_predicate.md)
 *  [gene to expression site association➞predicate](gene_to_expression_site_association_predicate.md)
 *  [gene to gene coexpression association➞predicate](gene_to_gene_coexpression_association_predicate.md)
 *  [gene to gene homology association➞predicate](gene_to_gene_homology_association_predicate.md)
 *  [gene to gene product relationship➞predicate](gene_to_gene_product_relationship_predicate.md)
 *  [genomic sequence localization➞predicate](genomic_sequence_localization_predicate.md)
 *  [genotype to disease association➞predicate](genotype_to_disease_association_predicate.md)
 *  [genotype to gene association➞predicate](genotype_to_gene_association_predicate.md)
 *  [genotype to genotype part association➞predicate](genotype_to_genotype_part_association_predicate.md)
 *  [genotype to phenotypic feature association➞predicate](genotype_to_phenotypic_feature_association_predicate.md)
 *  [genotype to variant association➞predicate](genotype_to_variant_association_predicate.md)
 *  [material sample derivation association➞predicate](material_sample_derivation_association_predicate.md)
 *  [model to disease association mixin➞predicate](model_to_disease_association_mixin_predicate.md)
 *  [organism taxon to environment association➞predicate](organism_taxon_to_environment_association_predicate.md)
 *  [organism taxon to organism taxon interaction➞predicate](organism_taxon_to_organism_taxon_interaction_predicate.md)
 *  [organism taxon to organism taxon specialization➞predicate](organism_taxon_to_organism_taxon_specialization_predicate.md)
 *  [pairwise gene to gene interaction➞predicate](pairwise_gene_to_gene_interaction_predicate.md)
 *  [population to population association➞predicate](population_to_population_association_predicate.md)
 *  [variant to disease association➞predicate](variant_to_disease_association_predicate.md)
 *  [variant to gene association➞predicate](variant_to_gene_association_predicate.md)

## Used by

 * [AnatomicalEntityToAnatomicalEntityAssociation](AnatomicalEntityToAnatomicalEntityAssociation.md)
 * [Association](Association.md)
 * [BehaviorToBehavioralFeatureAssociation](BehaviorToBehavioralFeatureAssociation.md)
 * [CaseToPhenotypicFeatureAssociation](CaseToPhenotypicFeatureAssociation.md)
 * [CellLineAsAModelOfDiseaseAssociation](CellLineAsAModelOfDiseaseAssociation.md)
 * [CellLineToDiseaseOrPhenotypicFeatureAssociation](CellLineToDiseaseOrPhenotypicFeatureAssociation.md)
 * [ChemicalToChemicalAssociation](ChemicalToChemicalAssociation.md)
 * [ChemicalToDiseaseOrPhenotypicFeatureAssociation](ChemicalToDiseaseOrPhenotypicFeatureAssociation.md)
 * [ChemicalToGeneAssociation](ChemicalToGeneAssociation.md)
 * [ChemicalToPathwayAssociation](ChemicalToPathwayAssociation.md)
 * [DiseaseOrPhenotypicFeatureAssociationToLocationAssociation](DiseaseOrPhenotypicFeatureAssociationToLocationAssociation.md)
 * [DiseaseOrPhenotypicFeatureToLocationAssociation](DiseaseOrPhenotypicFeatureToLocationAssociation.md)
 * [DiseaseToExposureEventAssociation](DiseaseToExposureEventAssociation.md)
 * [DiseaseToPhenotypicFeatureAssociation](DiseaseToPhenotypicFeatureAssociation.md)
 * [DrugToGeneAssociation](DrugToGeneAssociation.md)
 * [ExonToTranscriptRelationship](ExonToTranscriptRelationship.md)
 * [ExposureEventToOutcomeAssociation](ExposureEventToOutcomeAssociation.md)
 * [ExposureEventToPhenotypicFeatureAssociation](ExposureEventToPhenotypicFeatureAssociation.md)
 * [FunctionalAssociation](FunctionalAssociation.md)
 * [GeneAsAModelOfDiseaseAssociation](GeneAsAModelOfDiseaseAssociation.md)
 * [GeneHasVariantThatContributesToDiseaseAssociation](GeneHasVariantThatContributesToDiseaseAssociation.md)
 * [GeneToDiseaseAssociation](GeneToDiseaseAssociation.md)
 * [GeneToGeneAssociation](GeneToGeneAssociation.md)
 * [GeneToGoTermAssociation](GeneToGoTermAssociation.md)
 * [GeneToPhenotypicFeatureAssociation](GeneToPhenotypicFeatureAssociation.md)
 * [MacromolecularMachineToBiologicalProcessAssociation](MacromolecularMachineToBiologicalProcessAssociation.md)
 * [MacromolecularMachineToCellularComponentAssociation](MacromolecularMachineToCellularComponentAssociation.md)
 * [MacromolecularMachineToMolecularActivityAssociation](MacromolecularMachineToMolecularActivityAssociation.md)
 * [MaterialSampleToDiseaseOrPhenotypicFeatureAssociation](MaterialSampleToDiseaseOrPhenotypicFeatureAssociation.md)
 * [OrganismTaxonToOrganismTaxonAssociation](OrganismTaxonToOrganismTaxonAssociation.md)
 * [OrganismalEntityAsAModelOfDiseaseAssociation](OrganismalEntityAsAModelOfDiseaseAssociation.md)
 * [SequenceAssociation](SequenceAssociation.md)
 * [SequenceFeatureRelationship](SequenceFeatureRelationship.md)
 * [SequenceVariantModulatesTreatmentAssociation](SequenceVariantModulatesTreatmentAssociation.md)
 * [TranscriptToGeneRelationship](TranscriptToGeneRelationship.md)
 * [VariantToPhenotypicFeatureAssociation](VariantToPhenotypicFeatureAssociation.md)
 * [VariantToPopulationAssociation](VariantToPopulationAssociation.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Local names:** | | annotation predicate (ga4gh) |
|  | | predicate (translator) |
| **Mappings:** | | rdf:predicate |
| **Exact Mappings:** | | owl:annotatedProperty |
|  | | OBAN:association_has_predicate |

