
# Slot: is metabolite


indicates whether a chemical substance is a metabolite

URI: [biolink:is_metabolite](https://w3id.org/biolink/vocab/is_metabolite)


## Domain and Range

[ChemicalSubstance](ChemicalSubstance.md) &#8594;  <sub>0..1</sub> [Boolean](types/Boolean.md)

## Parents

 *  is_a: [node property](node_property.md)

## Children


## Used by

 * [Carbohydrate](Carbohydrate.md)
 * [ChemicalExposure](ChemicalExposure.md)
 * [ChemicalSubstance](ChemicalSubstance.md)
 * [ComplexChemicalExposure](ComplexChemicalExposure.md)
 * [EnvironmentalFoodContaminant](EnvironmentalFoodContaminant.md)
 * [FoodAdditive](FoodAdditive.md)
 * [FoodComponent](FoodComponent.md)
 * [Macronutrient](Macronutrient.md)
 * [Metabolite](Metabolite.md)
 * [Micronutrient](Micronutrient.md)
 * [Nutrient](Nutrient.md)
 * [ProcessedMaterial](ProcessedMaterial.md)
 * [Vitamin](Vitamin.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Exact Mappings:** | | CHEBI:25212 |

