
# Slot: in taxon


connects an entity to its taxonomic classification. Only certain kinds of entities can be taxonomically classified; see 'thing with taxon'

URI: [biolink:in_taxon](https://w3id.org/biolink/vocab/in_taxon)


## Domain and Range

[ThingWithTaxon](ThingWithTaxon.md) &#8594;  <sub>0..\*</sub> [OrganismTaxon](OrganismTaxon.md)

## Parents

 *  is_a: [related to](related_to.md)

## Children


## Used by

 * [RNAProduct](RNAProduct.md)
 * [RNAProductIsoform](RNAProductIsoform.md)
 * [AnatomicalEntity](AnatomicalEntity.md)
 * [BehavioralFeature](BehavioralFeature.md)
 * [Carbohydrate](Carbohydrate.md)
 * [Case](Case.md)
 * [Cell](Cell.md)
 * [CellularComponent](CellularComponent.md)
 * [ChemicalExposure](ChemicalExposure.md)
 * [ChemicalSubstance](ChemicalSubstance.md)
 * [ClinicalFinding](ClinicalFinding.md)
 * [CodingSequence](CodingSequence.md)
 * [Cohort](Cohort.md)
 * [ComplexChemicalExposure](ComplexChemicalExposure.md)
 * [Disease](Disease.md)
 * [DiseaseOrPhenotypicFeature](DiseaseOrPhenotypicFeature.md)
 * [DiseaseOrPhenotypicFeatureExposure](DiseaseOrPhenotypicFeatureExposure.md)
 * [DiseaseOrPhenotypicFeatureOutcome](DiseaseOrPhenotypicFeatureOutcome.md)
 * [Drug](Drug.md)
 * [DrugExposure](DrugExposure.md)
 * [DrugToGeneInteractionExposure](DrugToGeneInteractionExposure.md)
 * [EnvironmentalFoodContaminant](EnvironmentalFoodContaminant.md)
 * [Exon](Exon.md)
 * [Food](Food.md)
 * [FoodAdditive](FoodAdditive.md)
 * [FoodComponent](FoodComponent.md)
 * [Gene](Gene.md)
 * [GeneFamily](GeneFamily.md)
 * [Genome](Genome.md)
 * [GenomicBackgroundExposure](GenomicBackgroundExposure.md)
 * [GenomicEntity](GenomicEntity.md)
 * [Genotype](Genotype.md)
 * [GrossAnatomicalStructure](GrossAnatomicalStructure.md)
 * [Haplotype](Haplotype.md)
 * [IndividualOrganism](IndividualOrganism.md)
 * [LifeStage](LifeStage.md)
 * [Macronutrient](Macronutrient.md)
 * [Metabolite](Metabolite.md)
 * [MicroRNA](MicroRNA.md)
 * [Micronutrient](Micronutrient.md)
 * [MolecularEntity](MolecularEntity.md)
 * [NoncodingRNAProduct](NoncodingRNAProduct.md)
 * [Nutrient](Nutrient.md)
 * [PathologicalAnatomicalExposure](PathologicalAnatomicalExposure.md)
 * [PathologicalAnatomicalOutcome](PathologicalAnatomicalOutcome.md)
 * [PathologicalAnatomicalStructure](PathologicalAnatomicalStructure.md)
 * [PhenotypicFeature](PhenotypicFeature.md)
 * [PopulationOfIndividualOrganisms](PopulationOfIndividualOrganisms.md)
 * [ProcessedMaterial](ProcessedMaterial.md)
 * [Protein](Protein.md)
 * [ProteinIsoform](ProteinIsoform.md)
 * [ReagentTargetedGene](ReagentTargetedGene.md)
 * [SequenceVariant](SequenceVariant.md)
 * [SiRNA](SiRNA.md)
 * [Snv](Snv.md)
 * [StudyPopulation](StudyPopulation.md)
 * [ThingWithTaxon](ThingWithTaxon.md)
 * [Transcript](Transcript.md)
 * [Vitamin](Vitamin.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | instance of |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | WIKIDATA_PROPERTY:P703 |
| **Close Mappings:** | | NCIT:is_organism_source_of_gene_product |
|  | | NCIT:organism_has_gene |
| **Narrow Mappings:** | | NCIT:gene_found_in_organism |
|  | | NCIT:gene_product_has_organism_source |
|  | | RO:0002160 |
| **Related Mappings:** | | RO:0002162 |

