
# Slot: id


A unique identifier for an entity. Must be either a CURIE shorthand for a URI or a complete URI

URI: [biolink:id](https://w3id.org/biolink/vocab/id)


## Domain and Range

None &#8594;  <sub>1..1</sub> [String](types/String.md)

## Parents


## Children

 *  [agent➞id](agent_id.md)
 *  [pairwise molecular interaction➞id](pairwise_molecular_interaction_id.md)
 *  [publication➞id](publication_id.md)
 *  [sequence variant➞id](sequence_variant_id.md)

## Used by

 * [RNAProduct](RNAProduct.md)
 * [RNAProductIsoform](RNAProductIsoform.md)
 * [Activity](Activity.md)
 * [AdministrativeEntity](AdministrativeEntity.md)
 * [AnatomicalEntity](AnatomicalEntity.md)
 * [AnatomicalEntityToAnatomicalEntityAssociation](AnatomicalEntityToAnatomicalEntityAssociation.md)
 * [AnatomicalEntityToAnatomicalEntityOntogenicAssociation](AnatomicalEntityToAnatomicalEntityOntogenicAssociation.md)
 * [AnatomicalEntityToAnatomicalEntityPartOfAssociation](AnatomicalEntityToAnatomicalEntityPartOfAssociation.md)
 * [Association](Association.md)
 * [Behavior](Behavior.md)
 * [BehaviorToBehavioralFeatureAssociation](BehaviorToBehavioralFeatureAssociation.md)
 * [BehavioralExposure](BehavioralExposure.md)
 * [BehavioralFeature](BehavioralFeature.md)
 * [BehavioralOutcome](BehavioralOutcome.md)
 * [BiologicalEntity](BiologicalEntity.md)
 * [BiologicalProcess](BiologicalProcess.md)
 * [BiologicalProcessOrActivity](BiologicalProcessOrActivity.md)
 * [BioticExposure](BioticExposure.md)
 * [Carbohydrate](Carbohydrate.md)
 * [Case](Case.md)
 * [CaseToPhenotypicFeatureAssociation](CaseToPhenotypicFeatureAssociation.md)
 * [Cell](Cell.md)
 * [CellLine](CellLine.md)
 * [CellLineAsAModelOfDiseaseAssociation](CellLineAsAModelOfDiseaseAssociation.md)
 * [CellLineToDiseaseOrPhenotypicFeatureAssociation](CellLineToDiseaseOrPhenotypicFeatureAssociation.md)
 * [CellularComponent](CellularComponent.md)
 * [ChemicalExposure](ChemicalExposure.md)
 * [ChemicalSubstance](ChemicalSubstance.md)
 * [ChemicalToChemicalAssociation](ChemicalToChemicalAssociation.md)
 * [ChemicalToChemicalDerivationAssociation](ChemicalToChemicalDerivationAssociation.md)
 * [ChemicalToDiseaseOrPhenotypicFeatureAssociation](ChemicalToDiseaseOrPhenotypicFeatureAssociation.md)
 * [ChemicalToGeneAssociation](ChemicalToGeneAssociation.md)
 * [ChemicalToPathwayAssociation](ChemicalToPathwayAssociation.md)
 * [ClinicalEntity](ClinicalEntity.md)
 * [ClinicalFinding](ClinicalFinding.md)
 * [ClinicalIntervention](ClinicalIntervention.md)
 * [ClinicalTrial](ClinicalTrial.md)
 * [CodingSequence](CodingSequence.md)
 * [Cohort](Cohort.md)
 * [ComplexChemicalExposure](ComplexChemicalExposure.md)
 * [ConfidenceLevel](ConfidenceLevel.md)
 * [ContributorAssociation](ContributorAssociation.md)
 * [Dataset](Dataset.md)
 * [DatasetDistribution](DatasetDistribution.md)
 * [DatasetSummary](DatasetSummary.md)
 * [DatasetVersion](DatasetVersion.md)
 * [Death](Death.md)
 * [Device](Device.md)
 * [Disease](Disease.md)
 * [DiseaseOrPhenotypicFeature](DiseaseOrPhenotypicFeature.md)
 * [DiseaseOrPhenotypicFeatureAssociationToLocationAssociation](DiseaseOrPhenotypicFeatureAssociationToLocationAssociation.md)
 * [DiseaseOrPhenotypicFeatureExposure](DiseaseOrPhenotypicFeatureExposure.md)
 * [DiseaseOrPhenotypicFeatureOutcome](DiseaseOrPhenotypicFeatureOutcome.md)
 * [DiseaseOrPhenotypicFeatureToLocationAssociation](DiseaseOrPhenotypicFeatureToLocationAssociation.md)
 * [DiseaseToExposureEventAssociation](DiseaseToExposureEventAssociation.md)
 * [DiseaseToPhenotypicFeatureAssociation](DiseaseToPhenotypicFeatureAssociation.md)
 * [Drug](Drug.md)
 * [DrugExposure](DrugExposure.md)
 * [DrugToGeneAssociation](DrugToGeneAssociation.md)
 * [DrugToGeneInteractionExposure](DrugToGeneInteractionExposure.md)
 * [Entity](Entity.md)
 * [EnvironmentalExposure](EnvironmentalExposure.md)
 * [EnvironmentalFeature](EnvironmentalFeature.md)
 * [EnvironmentalFoodContaminant](EnvironmentalFoodContaminant.md)
 * [EnvironmentalProcess](EnvironmentalProcess.md)
 * [EpidemiologicalOutcome](EpidemiologicalOutcome.md)
 * [EvidenceType](EvidenceType.md)
 * [Exon](Exon.md)
 * [ExonToTranscriptRelationship](ExonToTranscriptRelationship.md)
 * [ExposureEventToOutcomeAssociation](ExposureEventToOutcomeAssociation.md)
 * [ExposureEventToPhenotypicFeatureAssociation](ExposureEventToPhenotypicFeatureAssociation.md)
 * [Food](Food.md)
 * [FoodAdditive](FoodAdditive.md)
 * [FoodComponent](FoodComponent.md)
 * [FunctionalAssociation](FunctionalAssociation.md)
 * [Gene](Gene.md)
 * [GeneAsAModelOfDiseaseAssociation](GeneAsAModelOfDiseaseAssociation.md)
 * [GeneFamily](GeneFamily.md)
 * [GeneHasVariantThatContributesToDiseaseAssociation](GeneHasVariantThatContributesToDiseaseAssociation.md)
 * [GeneRegulatoryRelationship](GeneRegulatoryRelationship.md)
 * [GeneToDiseaseAssociation](GeneToDiseaseAssociation.md)
 * [GeneToExpressionSiteAssociation](GeneToExpressionSiteAssociation.md)
 * [GeneToGeneAssociation](GeneToGeneAssociation.md)
 * [GeneToGeneCoexpressionAssociation](GeneToGeneCoexpressionAssociation.md)
 * [GeneToGeneHomologyAssociation](GeneToGeneHomologyAssociation.md)
 * [GeneToGeneProductRelationship](GeneToGeneProductRelationship.md)
 * [GeneToGoTermAssociation](GeneToGoTermAssociation.md)
 * [GeneToPhenotypicFeatureAssociation](GeneToPhenotypicFeatureAssociation.md)
 * [Genome](Genome.md)
 * [GenomicBackgroundExposure](GenomicBackgroundExposure.md)
 * [GenomicEntity](GenomicEntity.md)
 * [GenomicSequenceLocalization](GenomicSequenceLocalization.md)
 * [Genotype](Genotype.md)
 * [GenotypeAsAModelOfDiseaseAssociation](GenotypeAsAModelOfDiseaseAssociation.md)
 * [GenotypeToDiseaseAssociation](GenotypeToDiseaseAssociation.md)
 * [GenotypeToGeneAssociation](GenotypeToGeneAssociation.md)
 * [GenotypeToGenotypePartAssociation](GenotypeToGenotypePartAssociation.md)
 * [GenotypeToPhenotypicFeatureAssociation](GenotypeToPhenotypicFeatureAssociation.md)
 * [GenotypeToVariantAssociation](GenotypeToVariantAssociation.md)
 * [GeographicExposure](GeographicExposure.md)
 * [GeographicLocation](GeographicLocation.md)
 * [GeographicLocationAtTime](GeographicLocationAtTime.md)
 * [GrossAnatomicalStructure](GrossAnatomicalStructure.md)
 * [Haplotype](Haplotype.md)
 * [Hospitalization](Hospitalization.md)
 * [HospitalizationOutcome](HospitalizationOutcome.md)
 * [IndividualOrganism](IndividualOrganism.md)
 * [InformationContentEntity](InformationContentEntity.md)
 * [LifeStage](LifeStage.md)
 * [MacromolecularMachineToBiologicalProcessAssociation](MacromolecularMachineToBiologicalProcessAssociation.md)
 * [MacromolecularMachineToCellularComponentAssociation](MacromolecularMachineToCellularComponentAssociation.md)
 * [MacromolecularMachineToMolecularActivityAssociation](MacromolecularMachineToMolecularActivityAssociation.md)
 * [Macronutrient](Macronutrient.md)
 * [MaterialSample](MaterialSample.md)
 * [MaterialSampleDerivationAssociation](MaterialSampleDerivationAssociation.md)
 * [MaterialSampleToDiseaseOrPhenotypicFeatureAssociation](MaterialSampleToDiseaseOrPhenotypicFeatureAssociation.md)
 * [Metabolite](Metabolite.md)
 * [MicroRNA](MicroRNA.md)
 * [Micronutrient](Micronutrient.md)
 * [MolecularActivity](MolecularActivity.md)
 * [MolecularEntity](MolecularEntity.md)
 * [MortalityOutcome](MortalityOutcome.md)
 * [NamedThing](NamedThing.md)
 * [NoncodingRNAProduct](NoncodingRNAProduct.md)
 * [Nutrient](Nutrient.md)
 * [OrganismTaxon](OrganismTaxon.md)
 * [OrganismTaxonToEnvironmentAssociation](OrganismTaxonToEnvironmentAssociation.md)
 * [OrganismTaxonToOrganismTaxonAssociation](OrganismTaxonToOrganismTaxonAssociation.md)
 * [OrganismTaxonToOrganismTaxonInteraction](OrganismTaxonToOrganismTaxonInteraction.md)
 * [OrganismTaxonToOrganismTaxonSpecialization](OrganismTaxonToOrganismTaxonSpecialization.md)
 * [OrganismalEntity](OrganismalEntity.md)
 * [OrganismalEntityAsAModelOfDiseaseAssociation](OrganismalEntityAsAModelOfDiseaseAssociation.md)
 * [PairwiseGeneToGeneInteraction](PairwiseGeneToGeneInteraction.md)
 * [PathologicalAnatomicalExposure](PathologicalAnatomicalExposure.md)
 * [PathologicalAnatomicalOutcome](PathologicalAnatomicalOutcome.md)
 * [PathologicalAnatomicalStructure](PathologicalAnatomicalStructure.md)
 * [PathologicalProcess](PathologicalProcess.md)
 * [PathologicalProcessExposure](PathologicalProcessExposure.md)
 * [PathologicalProcessOutcome](PathologicalProcessOutcome.md)
 * [Pathway](Pathway.md)
 * [Phenomenon](Phenomenon.md)
 * [PhenotypicFeature](PhenotypicFeature.md)
 * [PhysicalEntity](PhysicalEntity.md)
 * [PhysiologicalProcess](PhysiologicalProcess.md)
 * [PlanetaryEntity](PlanetaryEntity.md)
 * [PopulationOfIndividualOrganisms](PopulationOfIndividualOrganisms.md)
 * [PopulationToPopulationAssociation](PopulationToPopulationAssociation.md)
 * [Procedure](Procedure.md)
 * [ProcessedMaterial](ProcessedMaterial.md)
 * [Protein](Protein.md)
 * [ProteinIsoform](ProteinIsoform.md)
 * [ReagentTargetedGene](ReagentTargetedGene.md)
 * [SequenceAssociation](SequenceAssociation.md)
 * [SequenceFeatureRelationship](SequenceFeatureRelationship.md)
 * [SequenceVariantModulatesTreatmentAssociation](SequenceVariantModulatesTreatmentAssociation.md)
 * [SiRNA](SiRNA.md)
 * [SocioeconomicExposure](SocioeconomicExposure.md)
 * [SocioeconomicOutcome](SocioeconomicOutcome.md)
 * [StudyPopulation](StudyPopulation.md)
 * [Transcript](Transcript.md)
 * [TranscriptToGeneRelationship](TranscriptToGeneRelationship.md)
 * [Treatment](Treatment.md)
 * [VariantAsAModelOfDiseaseAssociation](VariantAsAModelOfDiseaseAssociation.md)
 * [VariantToDiseaseAssociation](VariantToDiseaseAssociation.md)
 * [VariantToGeneAssociation](VariantToGeneAssociation.md)
 * [VariantToGeneExpressionAssociation](VariantToGeneExpressionAssociation.md)
 * [VariantToPhenotypicFeatureAssociation](VariantToPhenotypicFeatureAssociation.md)
 * [VariantToPopulationAssociation](VariantToPopulationAssociation.md)
 * [Vitamin](Vitamin.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | alliancegenome:primaryId |
|  | | gff3:ID |
|  | | gpi:DB_Object_ID |

