
# Slot: enabled by


holds between a process and a physical entity, where the physical entity executes the process

URI: [biolink:enabled_by](https://w3id.org/biolink/vocab/enabled_by)


## Domain and Range

[BiologicalProcessOrActivity](BiologicalProcessOrActivity.md) &#8594;  <sub>0..\*</sub> [PhysicalEntity](PhysicalEntity.md)

## Parents

 *  is_a: [has participant](has_participant.md)

## Children

 *  [molecular activity➞enabled by](molecular_activity_enabled_by.md)

## Used by

 * [Behavior](Behavior.md)
 * [BehavioralExposure](BehavioralExposure.md)
 * [BehavioralOutcome](BehavioralOutcome.md)
 * [BiologicalProcess](BiologicalProcess.md)
 * [BiologicalProcessOrActivity](BiologicalProcessOrActivity.md)
 * [Death](Death.md)
 * [MortalityOutcome](MortalityOutcome.md)
 * [PathologicalProcess](PathologicalProcess.md)
 * [PathologicalProcessExposure](PathologicalProcessExposure.md)
 * [PathologicalProcessOutcome](PathologicalProcessOutcome.md)
 * [Pathway](Pathway.md)
 * [PhysiologicalProcess](PhysiologicalProcess.md)
 * [SocioeconomicExposure](SocioeconomicExposure.md)
 * [SocioeconomicOutcome](SocioeconomicOutcome.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | RO:0002333 |

