
# Slot: name


The human-readable 'attribute name' can be set to a string which reflects its context of interpretation, e.g. SEPIO evidence/provenance/confidence annotation or it can default to the name associated with the 'has attribute type' slot ontology term.

URI: [biolink:attribute_name](https://w3id.org/biolink/vocab/attribute_name)


## Domain and Range

[Attribute](Attribute.md) &#8594;  <sub>0..1</sub> [LabelType](types/LabelType.md)

## Parents

 *  is_a: [name](name.md)

## Children


## Used by

 * [Attribute](Attribute.md)
 * [BiologicalSex](BiologicalSex.md)
 * [ClinicalAttribute](ClinicalAttribute.md)
 * [ClinicalCourse](ClinicalCourse.md)
 * [ClinicalMeasurement](ClinicalMeasurement.md)
 * [ClinicalModifier](ClinicalModifier.md)
 * [GenotypicSex](GenotypicSex.md)
 * [Inheritance](Inheritance.md)
 * [Onset](Onset.md)
 * [OrganismAttribute](OrganismAttribute.md)
 * [PhenotypicQuality](PhenotypicQuality.md)
 * [PhenotypicSex](PhenotypicSex.md)
 * [SeverityValue](SeverityValue.md)
 * [SocioeconomicAttribute](SocioeconomicAttribute.md)
 * [Zygosity](Zygosity.md)

## Other properties

|  |  |  |
| --- | --- | --- |
| **Aliases:** | | label |
|  | | display name |
|  | | title |
| **Mappings:** | | rdfs:label |
| **In Subsets:** | | translator_minimal |
|  | | samples |
| **Exact Mappings:** | | gff3:Name |
|  | | gpi:DB_Object_Name |
| **Narrow Mappings:** | | dct:title |
|  | | WIKIDATA_PROPERTY:P1476 |

