
# Slot: approved to treat


holds between a therapeutic procedure or chemical substance and a disease or phenotypic feature for which it is approved for treatment to some level of clinical trial. Note that in terms of REPODB narrow mappings, terms containing 'suspended', 'terminated' or 'withdrawn' should be mapped onto associations using this term for which 'negated: true' is asserted.

URI: [biolink:approved_to_treat](https://w3id.org/biolink/vocab/approved_to_treat)


## Domain and Range

[ChemicalOrDrugOrTreatment](ChemicalOrDrugOrTreatment.md) &#8594;  <sub>0..\*</sub> [DiseaseOrPhenotypicFeature](DiseaseOrPhenotypicFeature.md)

## Parents

 *  is_a: [treats](treats.md)

## Children


## Used by


## Other properties

|  |  |  |
| --- | --- | --- |
| **Exact Mappings:** | | NCIT:C172573 |
| **Narrow Mappings:** | | NCIT:R172 |
|  | | NCIT:regimen_has_accepted_use_for_disease |
|  | | REPODB:clinically_tested_approved_unknown_phase |
|  | | REPODB:clinically_tested_suspended_phase_0 |
|  | | REPODB:clinically_tested_suspended_phase_1 |
|  | | REPODB:clinically_tested_suspended_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_suspended_phase_2 |
|  | | REPODB:clinically_tested_suspended_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_suspended_phase_3 |
|  | | REPODB:clinically_tested_terminated_phase_0 |
|  | | REPODB:clinically_tested_terminated_phase_1 |
|  | | REPODB:clinically_tested_terminated_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_terminated_phase_2 |
|  | | REPODB:clinically_tested_terminated_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_terminated_phase_3 |
|  | | REPODB:clinically_tested_withdrawn_phase_0 |
|  | | REPODB:clinically_tested_withdrawn_phase_1 |
|  | | REPODB:clinically_tested_withdrawn_phase_1_or_phase_2 |
|  | | REPODB:clinically_tested_withdrawn_phase_2 |
|  | | REPODB:clinically_tested_withdrawn_phase_2_or_phase_3 |
|  | | REPODB:clinically_tested_withdrawn_phase_3 |

