
# Slot: affects


describes an entity that has a direct affect on the state or quality of another existing entity. Use of the 'affects' predicate implies that the affected entity already exists, unlike predicates such as 'affects risk for' and 'prevents, where the outcome is something that may or may not come to be.

URI: [biolink:affects](https://w3id.org/biolink/vocab/affects)


## Domain and Range

[NamedThing](NamedThing.md) &#8594;  <sub>0..\*</sub> [NamedThing](NamedThing.md)

## Parents

 *  is_a: [related to](related_to.md)

## Children

 *  [affects abundance of](affects_abundance_of.md)
 *  [affects activity of](affects_activity_of.md)
 *  [affects degradation of](affects_degradation_of.md)
 *  [affects expression in](affects_expression_in.md)
 *  [affects expression of](affects_expression_of.md)
 *  [affects folding of](affects_folding_of.md)
 *  [affects localization of](affects_localization_of.md)
 *  [affects metabolic processing of](affects_metabolic_processing_of.md)
 *  [affects molecular modification of](affects_molecular_modification_of.md)
 *  [affects mutation rate of](affects_mutation_rate_of.md)
 *  [affects response to](affects_response_to.md)
 *  [affects secretion of](affects_secretion_of.md)
 *  [affects splicing of](affects_splicing_of.md)
 *  [affects stability of](affects_stability_of.md)
 *  [affects synthesis of](affects_synthesis_of.md)
 *  [affects transport of](affects_transport_of.md)
 *  [affects uptake of](affects_uptake_of.md)
 *  [ameliorates](ameliorates.md)
 *  [disrupts](disrupts.md)
 *  [entity regulates entity](entity_regulates_entity.md)
 *  [exacerbates](exacerbates.md)
 *  [process regulates process](process_regulates_process.md)

## Used by


## Other properties

|  |  |  |
| --- | --- | --- |
| **In Subsets:** | | translator_minimal |
| **Exact Mappings:** | | SEMMEDDB:AFFECTS |
|  | | SEMMEDDB:affects |
|  | | DGIdb:affects |
|  | | RTXKG1:affects |
| **Narrow Mappings:** | | SEMMEDDB:administered_to |
|  | | CTD:prediction_hypothesis |
|  | | GOREL:0001006 |
|  | | CTD:inferred |
|  | | UPHENO:0000001 |
|  | | RO:0002263 |
|  | | RO:0002264 |
|  | | NCIT:R158 |
|  | | NCIT:R160 |
|  | | NCIT:R30 |
|  | | NCIT:R150 |
|  | | NCIT:R72 |
|  | | NCIT:R146 |
|  | | NCIT:R124 |
|  | | NCIT:R173 |
|  | | NCIT:R100 |
|  | | NCIT:R102 |
|  | | NCIT:R101 |
|  | | NCIT:R113 |
|  | | NCIT:R23 |
|  | | NCIT:R25 |
|  | | NCIT:gene_mapped_to_disease |
|  | | NCIT:R133 |
|  | | RO:0002343 |
|  | | RO:0002355 |
|  | | RO:0002591 |
|  | | RO:0002592 |
|  | | RO:0012003 |
|  | | SNOMED:has_pathological_process |
| **Related Mappings:** | | DRUGBANK:pathway |

