
# Class: taxonomic rank


A descriptor for the rank within a taxonomic classification. Example instance: TAXRANK:0000017 (kingdom)

URI: [biolink:TaxonomicRank](https://w3id.org/biolink/vocab/TaxonomicRank)


[![img](https://yuml.me/diagram/nofunky;dir:TB/class/[OrganismTaxon]++-%20has%20taxonomic%20rank%200..1>[TaxonomicRank],[OntologyClass]^-[TaxonomicRank],[OrganismTaxon],[OntologyClass])](https://yuml.me/diagram/nofunky;dir:TB/class/[OrganismTaxon]++-%20has%20taxonomic%20rank%200..1>[TaxonomicRank],[OntologyClass]^-[TaxonomicRank],[OrganismTaxon],[OntologyClass])

## Identifier prefixes

 * TAXRANK

## Parents

 *  is_a: [OntologyClass](OntologyClass.md) - a concept or class in an ontology, vocabulary or thesaurus. Note that nodes in a biolink compatible KG can be considered both instances of biolink classes, and OWL classes in their own right. In general you should not need to use this class directly. Instead, use the appropriate biolink class. For example, for the GO concept of endocytosis (GO:0006897), use bl:BiologicalProcess as the type.

## Referenced by Class

 *  **None** *[has taxonomic rank](has_taxonomic_rank.md)*  <sub>0..1</sub>  **[TaxonomicRank](TaxonomicRank.md)**
 *  **[OrganismTaxon](OrganismTaxon.md)** *[organism taxon➞has taxonomic rank](organism_taxon_has_taxonomic_rank.md)*  <sub>0..1</sub>  **[TaxonomicRank](TaxonomicRank.md)**

## Attributes


## Other properties

|  |  |  |
| --- | --- | --- |
| **Mappings:** | | WIKIDATA:Q427626 |

