
# Class: outcome


An entity that has the role of being the consequence of an exposure event. This is an abstract mixin grouping of various categories of possible biological or non-biological (e.g. clinical) outcomes.

URI: [biolink:Outcome](https://w3id.org/biolink/vocab/Outcome)


[![img](https://yuml.me/diagram/nofunky;dir:TB/class/[EntityToOutcomeAssociationMixin]++-%20object%201..1>[Outcome],[SocioeconomicOutcome]uses%20-.->[Outcome],[PathologicalProcessOutcome]uses%20-.->[Outcome],[PathologicalAnatomicalOutcome]uses%20-.->[Outcome],[MortalityOutcome]uses%20-.->[Outcome],[HospitalizationOutcome]uses%20-.->[Outcome],[EpidemiologicalOutcome]uses%20-.->[Outcome],[DiseaseOrPhenotypicFeatureOutcome]uses%20-.->[Outcome],[BehavioralOutcome]uses%20-.->[Outcome],[SocioeconomicOutcome],[PathologicalProcessOutcome],[PathologicalAnatomicalOutcome],[MortalityOutcome],[HospitalizationOutcome],[EpidemiologicalOutcome],[EntityToOutcomeAssociationMixin],[DiseaseOrPhenotypicFeatureOutcome],[BehavioralOutcome])](https://yuml.me/diagram/nofunky;dir:TB/class/[EntityToOutcomeAssociationMixin]++-%20object%201..1>[Outcome],[SocioeconomicOutcome]uses%20-.->[Outcome],[PathologicalProcessOutcome]uses%20-.->[Outcome],[PathologicalAnatomicalOutcome]uses%20-.->[Outcome],[MortalityOutcome]uses%20-.->[Outcome],[HospitalizationOutcome]uses%20-.->[Outcome],[EpidemiologicalOutcome]uses%20-.->[Outcome],[DiseaseOrPhenotypicFeatureOutcome]uses%20-.->[Outcome],[BehavioralOutcome]uses%20-.->[Outcome],[SocioeconomicOutcome],[PathologicalProcessOutcome],[PathologicalAnatomicalOutcome],[MortalityOutcome],[HospitalizationOutcome],[EpidemiologicalOutcome],[EntityToOutcomeAssociationMixin],[DiseaseOrPhenotypicFeatureOutcome],[BehavioralOutcome])

## Mixin for

 * [BehavioralOutcome](BehavioralOutcome.md) (mixin)  - An outcome resulting from an exposure event which is the manifestation of human behavior.
 * [DiseaseOrPhenotypicFeatureOutcome](DiseaseOrPhenotypicFeatureOutcome.md) (mixin)  - Physiological outcomes resulting from an exposure event which is the manifestation of a disease or other characteristic phenotype.
 * [EpidemiologicalOutcome](EpidemiologicalOutcome.md) (mixin)  - An epidemiological outcome, such as societal disease burden, resulting from an exposure event.
 * [HospitalizationOutcome](HospitalizationOutcome.md) (mixin)  - An outcome resulting from an exposure event which is the increased manifestation of acute (e.g. emergency room visit) or chronic (inpatient) hospitalization.
 * [MortalityOutcome](MortalityOutcome.md) (mixin)  - An outcome of death from resulting from an exposure event.
 * [PathologicalAnatomicalOutcome](PathologicalAnatomicalOutcome.md) (mixin)  - An outcome resulting from an exposure event which is the manifestation of an abnormal anatomical structure.
 * [PathologicalProcessOutcome](PathologicalProcessOutcome.md) (mixin)  - An outcome resulting from an exposure event which is the manifestation of a pathological process.
 * [SocioeconomicOutcome](SocioeconomicOutcome.md) (mixin)  - An general social or economic outcome, such as healthcare costs, utilization, etc., resulting from an exposure event

## Referenced by Class

 *  **[EntityToOutcomeAssociationMixin](EntityToOutcomeAssociationMixin.md)** *[entity to outcome association mixin➞object](entity_to_outcome_association_mixin_object.md)*  <sub>1..1</sub>  **[Outcome](Outcome.md)**

## Attributes

