
# Class: macromolecular complex mixin


A stable assembly of two or more macromolecules, i.e. proteins, nucleic acids, carbohydrates or lipids, in which at least one component is a protein and the constituent parts function together.

URI: [biolink:MacromolecularComplexMixin](https://w3id.org/biolink/vocab/MacromolecularComplexMixin)


[![img](https://yuml.me/diagram/nofunky;dir:TB/class/[MacromolecularMachineMixin],[MacromolecularMachineMixin]^-[MacromolecularComplexMixin&#124;name(i):symbol_type%20%3F])](https://yuml.me/diagram/nofunky;dir:TB/class/[MacromolecularMachineMixin],[MacromolecularMachineMixin]^-[MacromolecularComplexMixin&#124;name(i):symbol_type%20%3F])

## Identifier prefixes

 * INTACT
 * GO
 * PR
 * REACT

## Parents

 *  is_a: [MacromolecularMachineMixin](MacromolecularMachineMixin.md) - A union of gene locus, gene product, and macromolecular complex mixin. These are the basic units of function in a cell. They either carry out individual biological activities, or they encode molecules which do this.

## Attributes


### Inherited from macromolecular machine mixin:

 * [macromolecular machine mixin➞name](macromolecular_machine_mixin_name.md)  <sub>0..1</sub>
     * Description: genes are typically designated by a short symbol and a full name. We map the symbol to the default display name and use an additional slot for full name
     * Range: [SymbolType](types/SymbolType.md)
     * in subsets: (translator_minimal,samples)

## Other properties

|  |  |  |
| --- | --- | --- |
| **In Subsets:** | | model_organism_database |
| **Exact Mappings:** | | GO:0032991 |
|  | | WIKIDATA:Q22325163 |

