# Examples of use

## Introductory Example

See [PersonSchema](https://github.com/linkml/linkml/tree/main/examples/PersonSchema)

This schema will be used as a core example throughout. It represents
people, their attributes, and related entities such as
organizations.

## Example Models

### Biolink

The Biolink Model is a knowledge graph schema for representing core biological and clinical entities and their inter-relationships.

 * [biolink/biolink-model](https://github.com/biolink/biolink-model) repo
 * [generated docs](https://biolink.github.io/biolink-model/)

### National Microbiome Data Collaborative

The NMDC schema represents environmental omics samples, associated
biogeochemical and environmental metadata, and the outputs of various
kinds of omics processes and computational workflows on these samples.

See [National Microbiome Data Collaborative](https://github.com/microbiomedata/nmdc-metadata)

### Cancer Research Data Commons - Harmonized Model

See [Cancer Research Data Commons - Harmonized Model](https://cancerdhc.github.io/ccdhmodel/), developed by the NIH [Center for Cancer Data Harmonization](https://harmonization.datacommons.cancer.gov/)

### LinkML

LinkML is itself described as a LinkML model

 * [linkml/linkml-model](https://github.com/linkml/linkml-model) repo
 * [generated docs](https://linkml.io/linkml-model/docs/)

## LinkML Registry

The LinkML registry collects some existing schemas and allows for basic browsing:

 * [linkml/linkml-registry](https://linkml.io/linkml-registry/registry/)
