# LinkML representation generators

| command line | module | Generator name | function | help file |
| -----------  | ------ | -------------  | -------- | --------- |
|  gen-yaml    | [yamlgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-yaml.py) | YamlGenerator | Validate YAML or emit compiled module | [yamlgen help](../../tests/test_scripts/output/gennaml/help) |
|  gen-jsonld-context   | [jsonldcontextgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-lsonld-context.py) |    ContextGenerator | generate a JSON-LD @context block  | [contextgen help](../../tests/test_scripts/output/gencontext/help) |
|  gen-csv   | [csvgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-csv.py) |    CsvGenerator | generate a csv summary  | [csvgen help](../../tests/test_scripts/output/gencsv/help) |
|  gen-graphviz   | [dotgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-graphviz.py) |    DotGenerator | generate graphviz representation  | [dotgen help](../../tests/test_scripts/output/gengraphviz/help) |
|  gen-golr-views   | [golrgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-golr-views.py) |    GolrSchemaGenerator | generate a GOLR(?) representation  | [golrgen help](../../tests/test_scripts/output/genglor/help) |
|  gen-graphql   | [graphqlgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-graphql.py) |    GraphqlGenerator | generate a graphql representation  | [graphql help](../../tests/test_scripts/output/gengraphql/help) |
|  gen-prolog  | [lpgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-prolog.py) | LogicProgramGenerator | generate prolog representation | [prolog help](../../tests/test_scripts/output/genprolog/help) |
|  gen-proto  | [protogen.py](https://github.com/linkml/blob/master/linkml/generators/gen-proto.py) | ProtoGenerator | generate Protobuf Schema representation | [proto help](../../tests/test_scripts/output/genproto/help) |
|  gen-jsonld | [jsonldgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-jsonld.py) | JSONLDGenerator | generate JSON representation | [jsonld help](../../tests/test_scripts/output/genjsonld/help) |
|  gen-json-schema   | [jsonschemagen.py](https://github.com/linkml/blob/master/linkml/generators/gen-json-schema.py) |    JsonSchemaGenerator | generate JSON Schema representation  | [jsonschmeagen help](../../tests/test_scripts/output/genjsonschema/help) |
|  gen-markdown   | [markdowngen.py](https://github.com/linkml/blob/master/linkml/generators/gen-markdown.py) |    MarkdownGenerator | generate markdown documentation of the model  | [markdowngen help](../../tests/test_scripts/output/genmarkdown/help) |
|  gen-namespaces | [namespacegen.py](https://github.com/linkml/blob/master/linkml/generators/gen-namespaces.py) | NamespaceGenerator | generate namespace manager for URI's in model | [namespacegen help](../../tests/test_scripts/output/gennamespace/help) |
|  gen-owl   | [owlgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-owl.py) |    OwlSchemaGenerator | generate an OWL representation  | [owlgen help](../../tests/test_scripts/output/genowl/help) |
|  gen-proto   | [protogen.py](https://github.com/linkml/blob/master/linkml/generators/gen-proto.py) |    ProtoGenerator | generate a proto(?) representation  | [protogen help](../../tests/test_scripts/output/genproto/help) |
|  gen-python   | [pythongen.py](https://github.com/linkml/blob/master/linkml/generators/gen-python.py) | PythonGenerator | generate python classes for a model  | [pythongen help](../../tests/test_scripts/output/genpython/help) |
|  gen-rdf | [rdfgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-rdf.py) | RDFGenerator | generate RDF representation of model | [rdfgen help](../../tests/test_scripts/output/genrdf/help) |
|  gen-shex   | [shexgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-shex.py) |    ShExGenerator | generate a ShEx model representation  | [shexgen help](../../tests/test_scripts/output/genshex/help) |
|  gen-yuml   | [yumlgen.py](https://github.com/linkml/blob/master/linkml/generators/gen-yuml.py) |    YumlGenerator | generate YUML representation via [YUML](https://yuml.me/)  | [yumlgen help](../../tests/test_scripts/output/genuml/help) | 






