# uvtools
[![Build Status](https://travis-ci.org/HERA-Team/uvtools.svg?branch=master)](https://travis-ci.org/HERA-Team/uvtools)
[![codecov](https://codecov.io/gh/HERA-Team/uvtools/branch/main/graph/badge.svg?token=BImdA3Oz6u)](https://codecov.io/gh/HERA-Team/uvtools)

Tools useful for the handling, visualization, and analysis of interferometric data.

## Installation
Best method is to install from [![pypi](https://pypi.org/project/uvtools)] with `pip install uvtools`


Developer install from the github repo by cloning/pulling and then in ./uvtools/ run `pip install .`

If you use `conda` (preferred), then you may wish to install the following packages
manually before installing `uvtools` (if you don't have them already)::

    $ conda install -c conda-forge numpy scipy "aipy>=3.0rc2"

If you are developing `uvtools`, you will also require `nose` and `pyuvdata` to run
tests. All of these packages can be installed with the following commands::

    $ conda create -n uvtools python=3
    $ conda activate uvtools
    $ conda env update -n uvtools -f environment.yml
    $ pip install -e .

To test the package, execute the following command::

    $ nosetests uvtools/tests/test_dspec.py uvtools/tests/test_utils.py

## Making a Release

To make a release of `uvtools` (both on Github and PyPI), head to the most current
[Draft Release](https://github.com/HERA-Team/uvtools/releases) and note the *suggested*
release version. Contact the maintainers with your intention to make a release either
to that version (or, if appropriate, to a different version), and publish the release
via the Github UI. All done!
