import time
import click
import threading
try:
    from socketserver import BaseRequestHandler
    from socketserver import ThreadingMixIn
    from socketserver import TCPServer
    from socketserver import UDPServer
except ImportError:
    from SocketServer import BaseRequestHandler
    from SocketServer import ThreadingMixIn
    from SocketServer import TCPServer

BUFFER_SIZE = 1024

class ThreadedTCPRequestHandler(BaseRequestHandler):

    def handle(self):
        print("CLIENT CONNECTED: ", self.request)
        while True:
            data = self.request.recv(BUFFER_SIZE)
            print(self.request, data)
            if not data:
                break
            else:
                self.request.send("CLIENT DATA: ", data)
        print("CLIENT SHUTDOWN: ", self.request)

class ThreadedTCPServer(ThreadingMixIn, TCPServer):
    pass

@click.command()
@click.argument("port", nargs=-1)
def run(port):
    """Start echo server on given ports. Press CTRL+C to stop.
    The default listenning port is 3682. You can listen on many ports at the same time.

    Example:

    echo-server 8001 8002 8003
    """
    ports = port
    if not ports:
        ports = [3682]
    servers = []
    server_threads = []
    for port in ports:
        server = ThreadedTCPServer(("0.0.0.0", port), ThreadedTCPRequestHandler)
        server_thread = threading.Thread(target=server.serve_forever)
        server_thread.daemon = True
        server_thread.start()
        servers.append(server)
        server_threads.append(server_threads)
        print("Echo server running on port: {0}".format(port))
    while True:
        try:
            time.sleep(60)
        except:
            print("Interrupted, shutdown servers...")
            for server in servers:
                server.shutdown()
            print("done.")
            break

if __name__ == "__main__":
    run()
